/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.repository;

import androidx.lifecycle.LiveData;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionRepository;
import com.chuckerteam.chucker.internal.data.room.ChuckerDatabase;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/chuckerteam/chucker/internal/data/repository/HttpTransactionDatabaseRepository;", "Lcom/chuckerteam/chucker/internal/data/repository/HttpTransactionRepository;", "database", "Lcom/chuckerteam/chucker/internal/data/room/ChuckerDatabase;", "(Lcom/chuckerteam/chucker/internal/data/room/ChuckerDatabase;)V", "executor", "Ljava/util/concurrent/Executor;", "transcationDao", "Lcom/chuckerteam/chucker/internal/data/room/HttpTransactionDao;", "getTranscationDao", "()Lcom/chuckerteam/chucker/internal/data/room/HttpTransactionDao;", "deleteAllTransactions", "", "deleteOldTransactions", "threshold", "", "getFilteredTransactionTuples", "Landroidx/lifecycle/LiveData;", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "code", "", "path", "getSortedTransactionTuples", "getTransaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "transactionId", "insertTransaction", "transaction", "updateTransaction", "", "com.github.ChuckerTeam.Chucker.library"})
public final class HttpTransactionDatabaseRepository
implements HttpTransactionRepository {
    private final Executor executor;
    private final ChuckerDatabase database;

    private final HttpTransactionDao getTranscationDao() {
        return this.database.transactionDao();
    }

    @Override
    @NotNull
    public LiveData<List<HttpTransactionTuple>> getFilteredTransactionTuples(@NotNull String code, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        CharSequence charSequence = path;
        boolean bl = false;
        String pathQuery = charSequence.length() > 0 ? '%' + path + '%' : "%";
        return this.getTranscationDao().getFilteredTuples(code + '%', pathQuery);
    }

    @Override
    @NotNull
    public LiveData<HttpTransaction> getTransaction(long transactionId) {
        return this.getTranscationDao().getById(transactionId);
    }

    @Override
    @NotNull
    public LiveData<List<HttpTransactionTuple>> getSortedTransactionTuples() {
        return this.getTranscationDao().getSortedTuples();
    }

    @Override
    public void deleteAllTransactions() {
        this.executor.execute(new Runnable(this){
            final /* synthetic */ HttpTransactionDatabaseRepository this$0;

            public final void run() {
                HttpTransactionDatabaseRepository.access$getTranscationDao$p(this.this$0).deleteAll();
            }
            {
                this.this$0 = httpTransactionDatabaseRepository;
            }
        });
    }

    @Override
    public void insertTransaction(@NotNull HttpTransaction transaction2) {
        Intrinsics.checkParameterIsNotNull((Object)transaction2, (String)"transaction");
        this.executor.execute(new Runnable(this, transaction2){
            final /* synthetic */ HttpTransactionDatabaseRepository this$0;
            final /* synthetic */ HttpTransaction $transaction;

            public final void run() {
                Long id;
                Long l = id = HttpTransactionDatabaseRepository.access$getTranscationDao$p(this.this$0).insert(this.$transaction);
                this.$transaction.setId(l != null ? l : 0L);
            }
            {
                this.this$0 = httpTransactionDatabaseRepository;
                this.$transaction = httpTransaction;
            }
        });
    }

    @Override
    public int updateTransaction(@NotNull HttpTransaction transaction2) {
        Intrinsics.checkParameterIsNotNull((Object)transaction2, (String)"transaction");
        return this.getTranscationDao().update(transaction2);
    }

    @Override
    public void deleteOldTransactions(long threshold) {
        this.executor.execute(new Runnable(this, threshold){
            final /* synthetic */ HttpTransactionDatabaseRepository this$0;
            final /* synthetic */ long $threshold;

            public final void run() {
                HttpTransactionDatabaseRepository.access$getTranscationDao$p(this.this$0).deleteBefore(this.$threshold);
            }
            {
                this.this$0 = httpTransactionDatabaseRepository;
                this.$threshold = l;
            }
        });
    }

    public HttpTransactionDatabaseRepository(@NotNull ChuckerDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)database), (String)"database");
        this.database = database;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        this.executor = executorService;
    }

    public static final /* synthetic */ HttpTransactionDao access$getTranscationDao$p(HttpTransactionDatabaseRepository $this) {
        return $this.getTranscationDao();
    }
}

