/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import com.chuckerteam.chucker.api.ChuckerCollector;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.IOUtils;
import com.chuckerteam.chucker.internal.support.OkHttpUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001f\u0010\u001f\u001a\u00020\u00172\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0!\"\u00020\n\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "maxContentLength", "", "headersToRedact", "", "", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/ChuckerCollector;JLjava/util/Set;)V", "", "io", "Lcom/chuckerteam/chucker/internal/support/IOUtils;", "filterHeaders", "Lokhttp3/Headers;", "headers", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "processRequest", "", "request", "Lokhttp3/Request;", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "processResponse", "response", "processResponseBody", "redactHeader", "headerName", "", "([Ljava/lang/String;)V", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class ChuckerInterceptor
implements Interceptor {
    private final IOUtils io;
    private final Set<String> headersToRedact;
    private final Context context;
    private final ChuckerCollector collector;
    private final long maxContentLength;
    private static final Charset UTF8;
    private static final long MAX_BLOB_SIZE = 1000000L;
    private static final String CONTENT_TYPE_IMAGE = "image";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    public static final Companion Companion;

    public final void redactHeader(String ... headerName) {
        Intrinsics.checkParameterIsNotNull((Object)headerName, (String)"headerName");
        CollectionsKt.addAll((Collection)this.headersToRedact, (Object[])headerName);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = null;
        HttpTransaction transaction2 = new HttpTransaction();
        Request request2 = request;
        Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
        this.processRequest(request2, transaction2);
        this.collector.onRequestSent$com_github_ChuckerTeam_Chucker_library(transaction2);
        try {
            Response response2 = chain.proceed(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"chain.proceed(request)");
            response = response2;
        }
        catch (IOException e) {
            transaction2.setError(e.toString());
            this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(transaction2);
            throw (Throwable)e;
        }
        Response processedResponse = this.processResponse(response, transaction2);
        this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(transaction2);
        return processedResponse;
    }

    private final void processRequest(Request request, HttpTransaction transaction2) {
        RequestBody requestBody = request.body();
        boolean encodingIsSupported = this.io.bodyHasSupportedEncoding(request.headers().get(CONTENT_ENCODING));
        HttpTransaction httpTransaction = transaction2;
        boolean bl = false;
        boolean bl2 = false;
        HttpTransaction $this$apply = httpTransaction;
        boolean bl3 = false;
        Headers headers = request.headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"request.headers()");
        $this$apply.setRequestHeaders(headers);
        HttpUrl httpUrl = request.url();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"request.url()");
        $this$apply.populateUrl(httpUrl);
        $this$apply.setRequestBodyPlainText(encodingIsSupported);
        $this$apply.setRequestDate(System.currentTimeMillis());
        $this$apply.setMethod(request.method());
        RequestBody requestBody2 = requestBody;
        $this$apply.setRequestContentType(requestBody2 != null && (requestBody2 = requestBody2.contentType()) != null ? requestBody2.toString() : null);
        RequestBody requestBody3 = requestBody;
        $this$apply.setRequestContentLength(requestBody3 != null ? requestBody3.contentLength() : 0L);
        if (requestBody != null && encodingIsSupported) {
            BufferedSource source = this.io.getNativeSource((BufferedSource)new Buffer(), OkHttpUtils.isGzipped(request));
            Buffer buffer = source.buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF8");
            Charset charset2 = charset;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                Charset charset3 = contentType.charset(UTF8);
                if (charset3 == null) {
                    Charset charset4 = UTF8;
                    charset3 = charset4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset4, (String)"UTF8");
                }
                charset2 = charset3;
            }
            Buffer buffer2 = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)buffer2, (String)"buffer");
            if (this.io.isPlaintext(buffer2)) {
                String content = this.io.readFromBuffer(buffer, charset2, this.maxContentLength);
                transaction2.setRequestBody(content);
            } else {
                transaction2.setResponseBodyPlainText(false);
            }
        }
    }

    private final Response processResponse(Response response, HttpTransaction transaction2) {
        boolean responseEncodingIsSupported = this.io.bodyHasSupportedEncoding(response.headers().get(CONTENT_ENCODING));
        HttpTransaction httpTransaction = transaction2;
        boolean bl = false;
        boolean bl2 = false;
        HttpTransaction $this$apply = httpTransaction;
        boolean bl3 = false;
        Headers headers = response.request().headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"response.request().headers()");
        $this$apply.setRequestHeaders(this.filterHeaders(headers));
        Headers headers2 = response.headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers2, (String)"response.headers()");
        $this$apply.setResponseHeaders(this.filterHeaders(headers2));
        $this$apply.setResponseBodyPlainText(responseEncodingIsSupported);
        $this$apply.setRequestDate(response.sentRequestAtMillis());
        $this$apply.setResponseDate(response.receivedResponseAtMillis());
        $this$apply.setProtocol(response.protocol().toString());
        $this$apply.setResponseCode(response.code());
        $this$apply.setResponseMessage(response.message());
        $this$apply.setResponseContentType(OkHttpUtils.getContentType(response));
        $this$apply.setResponseContentLength(OkHttpUtils.getContentLenght(response));
        $this$apply.setTookMs(response.receivedResponseAtMillis() - response.sentRequestAtMillis());
        return responseEncodingIsSupported ? this.processResponseBody(response, transaction2) : response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response processResponseBody(Response response, HttpTransaction transaction2) {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return response;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBody, (String)"response.body() ?: return response");
        ResponseBody responseBody2 = responseBody;
        MediaType contentType = responseBody2.contentType();
        Object object = contentType;
        if (object == null || (object = object.charset(UTF8)) == null) {
            object = UTF8;
        }
        Object charset = object;
        long contentLength = responseBody2.contentLength();
        Source responseSource = OkHttpUtils.isGzipped(response) ? (Source)new GzipSource((Source)responseBody2.source()) : (Source)responseBody2.source();
        Buffer buffer = new Buffer();
        boolean bl = false;
        boolean bl2 = false;
        Buffer $this$apply = buffer;
        boolean bl3 = false;
        Closeable closeable = (Closeable)responseSource;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            Source it = (Source)closeable;
            boolean bl5 = false;
            long l = $this$apply.writeAll(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Buffer buffer2 = buffer;
        if (this.io.isPlaintext(buffer2)) {
            transaction2.setResponseBodyPlainText(true);
            if (contentLength != 0L) {
                transaction2.setResponseBody(buffer2.clone().readString((Charset)charset));
            }
        } else {
            boolean isImageContentType;
            transaction2.setResponseBodyPlainText(false);
            Object object2 = contentType;
            boolean bl6 = object2 != null && (object2 = object2.toString()) != null && StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)CONTENT_TYPE_IMAGE, (boolean)true) ? true : (isImageContentType = false);
            if (isImageContentType && buffer2.size() < 1000000L) {
                transaction2.setResponseImageData(buffer2.clone().readByteArray());
            }
        }
        Response response2 = response.newBuilder().body(ResponseBody.create((MediaType)contentType, (long)contentLength, (BufferedSource)((BufferedSource)buffer2))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response.newBuilder()\n  \u2026er))\n            .build()");
        return response2;
    }

    private final Headers filterHeaders(Headers headers) {
        Headers.Builder builder = headers.newBuilder();
        for (String name : headers.names()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = this.headersToRedact;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String userHeader = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)userHeader, (String)name, (boolean)true)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            builder.set(name, "**");
        }
        Headers headers2 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers2, (String)"builder.build()");
        return headers2;
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength, @NotNull Set<String> headersToRedact) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull(headersToRedact, (String)"headersToRedact");
        this.context = context;
        this.collector = collector;
        this.maxContentLength = maxContentLength;
        this.io = new IOUtils(this.context);
        this.headersToRedact = CollectionsKt.toMutableSet((Iterable)headersToRedact);
    }

    public /* synthetic */ ChuckerInterceptor(Context context, ChuckerCollector chuckerCollector, long l, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chuckerCollector = new ChuckerCollector(context, false, null, 6, null);
        }
        if ((n & 4) != 0) {
            l = 250000L;
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        this(context, chuckerCollector, l, set);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector, long maxContentLength) {
        this(context, collector, maxContentLength, null, 8, null);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context, @NotNull ChuckerCollector collector) {
        this(context, collector, 0L, null, 12, null);
    }

    @JvmOverloads
    public ChuckerInterceptor(@NotNull Context context) {
        this(context, null, 0L, null, 14, null);
    }

    static {
        Companion = new Companion(null);
        UTF8 = Charset.forName("UTF-8");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerInterceptor$Companion;", "", "()V", "CONTENT_ENCODING", "", "CONTENT_TYPE_IMAGE", "MAX_BLOB_SIZE", "", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

