/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionActivity;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionAdapter;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionListFragment;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 02\u00020\u00012\u00020\u00022\u00020\u00032\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u000bH\u0016J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u000bH\u0016J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionListFragment;", "Landroidx/fragment/app/Fragment;", "Landroidx/appcompat/widget/SearchView$OnQueryTextListener;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionClickListListener;", "Landroidx/lifecycle/Observer;", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "()V", "adapter", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;", "currentFilter", "", "dataSource", "Landroidx/lifecycle/LiveData;", "tutorialView", "Landroid/view/View;", "getDataSource", "onAttach", "", "context", "Landroid/content/Context;", "onChanged", "tuples", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "inflater", "Landroid/view/MenuInflater;", "onCreateView", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onOptionsItemSelected", "", "item", "Landroid/view/MenuItem;", "onQueryTextChange", "newText", "onQueryTextSubmit", "query", "onTransactionClick", "transactionId", "", "position", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionListFragment
extends Fragment
implements SearchView.OnQueryTextListener,
TransactionAdapter.TransactionClickListListener,
Observer<List<? extends HttpTransactionTuple>> {
    private String currentFilter = "";
    private TransactionAdapter adapter;
    private LiveData<List<HttpTransactionTuple>> dataSource;
    private View tutorialView;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        View view = inflater.inflate(R.layout.chucker_fragment_transaction_list, container, false);
        View view2 = view.findViewById(R.id.tutorial);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById(R.id.tutorial)");
        this.tutorialView = view2;
        View view3 = view.findViewById(R.id.link);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view.findViewById<TextView>(R.id.link)");
        ((TextView)view3).setMovementMethod(LinkMovementMethod.getInstance());
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.list);
        View view4 = view;
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"view");
        Context context = view4.getContext();
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(context, 1));
        Context context2 = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        this.adapter = new TransactionAdapter(context2, this);
        RecyclerView recyclerView2 = recyclerView;
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"recyclerView");
        TransactionAdapter transactionAdapter = this.adapter;
        if (transactionAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        recyclerView2.setAdapter((RecyclerView.Adapter)transactionAdapter);
        return view;
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super.onAttach(context);
        LiveData<List<HttpTransactionTuple>> liveData = this.dataSource = this.getDataSource(this.currentFilter);
        if (liveData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataSource");
        }
        liveData.observe((LifecycleOwner)this, (Observer)this);
    }

    public void onCreateOptionsMenu(@NotNull Menu menu2, @NotNull MenuInflater inflater) {
        MenuItem searchMenuItem;
        Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        inflater.inflate(R.menu.chucker_transactions_list, menu2);
        MenuItem menuItem = searchMenuItem = menu2.findItem(R.id.search);
        Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"searchMenuItem");
        View view = menuItem.getActionView();
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.appcompat.widget.SearchView");
        }
        SearchView searchView = (SearchView)view;
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        if (item.getItemId() == R.id.clear) {
            new AlertDialog.Builder(this.requireContext()).setTitle(R.string.chucker_clear).setMessage(R.string.chucker_clear_http_confirmation).setPositiveButton(R.string.chucker_clear, (DialogInterface.OnClickListener)onOptionsItemSelected.1.INSTANCE).setNegativeButton(R.string.chucker_cancel, null).show();
            bl = true;
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    public boolean onQueryTextSubmit(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return true;
    }

    public boolean onQueryTextChange(@NotNull String newText) {
        Intrinsics.checkParameterIsNotNull((Object)newText, (String)"newText");
        this.currentFilter = newText;
        LiveData<List<HttpTransactionTuple>> liveData = this.dataSource;
        if (liveData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataSource");
        }
        liveData.removeObservers((LifecycleOwner)this);
        LiveData<List<HttpTransactionTuple>> liveData2 = this.dataSource = this.getDataSource(this.currentFilter);
        if (liveData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataSource");
        }
        liveData2.observe((LifecycleOwner)this, (Observer)this);
        return true;
    }

    private final LiveData<List<HttpTransactionTuple>> getDataSource(String currentFilter) {
        CharSequence charSequence = currentFilter;
        boolean bl = false;
        return charSequence.length() == 0 ? RepositoryProvider.INSTANCE.transaction().getSortedTransactionTuples() : (TextUtils.isDigitsOnly((CharSequence)currentFilter) ? RepositoryProvider.INSTANCE.transaction().getFilteredTransactionTuples(currentFilter, "") : RepositoryProvider.INSTANCE.transaction().getFilteredTransactionTuples("", currentFilter));
    }

    public void onChanged(@NotNull List<HttpTransactionTuple> tuples) {
        Intrinsics.checkParameterIsNotNull(tuples, (String)"tuples");
        TransactionAdapter transactionAdapter = this.adapter;
        if (transactionAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        transactionAdapter.setData(tuples);
        View view = this.tutorialView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tutorialView");
        }
        view.setVisibility(tuples.isEmpty() ? 0 : 8);
    }

    @Override
    public void onTransactionClick(long transactionId, int position) {
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"requireActivity()");
        TransactionActivity.Companion.start((Context)fragmentActivity, transactionId);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionListFragment$Companion;", "", "()V", "newInstance", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionListFragment;", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        @NotNull
        public final TransactionListFragment newInstance() {
            return new TransactionListFragment();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

