/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentManager;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.Chucker;
import com.chuckerteam.chucker.internal.ui.BaseChuckerActivity;
import com.chuckerteam.chucker.internal.ui.HomePageAdapter;
import com.chuckerteam.chucker.internal.ui.error.ErrorActivity;
import com.chuckerteam.chucker.internal.ui.error.ErrorAdapter;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionActivity;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionAdapter;
import com.google.android.material.tabs.TabLayout;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/chuckerteam/chucker/internal/ui/MainActivity;", "Lcom/chuckerteam/chucker/internal/ui/BaseChuckerActivity;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionClickListListener;", "Lcom/chuckerteam/chucker/internal/ui/error/ErrorAdapter$ErrorClickListListener;", "()V", "applicationName", "", "getApplicationName", "()Ljava/lang/CharSequence;", "viewPager", "Landroidx/viewpager/widget/ViewPager;", "consumeIntent", "", "intent", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onErrorClick", "throwableId", "", "position", "", "onNewIntent", "onTransactionClick", "transactionId", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class MainActivity
extends BaseChuckerActivity
implements TransactionAdapter.TransactionClickListListener,
ErrorAdapter.ErrorClickListListener {
    private ViewPager viewPager;
    @NotNull
    public static final String EXTRA_SCREEN = "EXTRA_SCREEN";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final CharSequence getApplicationName() {
        CharSequence charSequence = this.getApplicationInfo().loadLabel(this.getPackageManager());
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"applicationInfo.loadLabel(packageManager)");
        return charSequence;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.chucker_activity_main);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        Toolbar toolbar2 = toolbar;
        Intrinsics.checkExpressionValueIsNotNull((Object)toolbar2, (String)"toolbar");
        toolbar2.setSubtitle(this.getApplicationName());
        View view = this.findViewById(R.id.viewPager);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.viewPager)");
        ViewPager viewPager = this.viewPager = (ViewPager)view;
        if (viewPager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewPager");
        }
        Context context = (Context)this;
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"supportFragmentManager");
        viewPager.setAdapter((PagerAdapter)new HomePageAdapter(context, fragmentManager));
        TabLayout tabLayout = (TabLayout)this.findViewById(R.id.tabLayout);
        ViewPager viewPager2 = this.viewPager;
        if (viewPager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewPager");
        }
        tabLayout.setupWithViewPager(viewPager2);
        ViewPager viewPager3 = this.viewPager;
        if (viewPager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewPager");
        }
        viewPager3.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TabLayout.TabLayoutOnPageChangeListener(this, tabLayout, tabLayout){
            final /* synthetic */ MainActivity this$0;
            final /* synthetic */ TabLayout $tabLayout;

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                if (position == 0) {
                    Chucker.dismissTransactionsNotification((Context)this.this$0);
                } else {
                    Chucker.dismissErrorsNotification((Context)this.this$0);
                }
            }
            {
                this.this$0 = $outer;
                this.$tabLayout = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        this.consumeIntent(intent);
    }

    protected void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        super.onNewIntent(intent);
        this.consumeIntent(intent);
    }

    private final void consumeIntent(Intent intent) {
        int screenToShow = intent.getIntExtra(EXTRA_SCREEN, 1);
        if (screenToShow == 1) {
            ViewPager viewPager = this.viewPager;
            if (viewPager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewPager");
            }
            viewPager.setCurrentItem(0);
        } else {
            ViewPager viewPager = this.viewPager;
            if (viewPager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewPager");
            }
            viewPager.setCurrentItem(1);
        }
    }

    @Override
    public void onErrorClick(long throwableId, int position) {
        ErrorActivity.Companion.start((Context)this, throwableId);
    }

    @Override
    public void onTransactionClick(long transactionId, int position) {
        TransactionActivity.Companion.start((Context)this, transactionId);
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/chuckerteam/chucker/internal/ui/MainActivity$Companion;", "", "()V", "EXTRA_SCREEN", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

