/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.ui.error;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.internal.data.entity.RecordedThrowableTuple;
import com.chuckerteam.chucker.api.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.api.internal.ui.error.ErrorAdapter;
import java.util.List;

public class ErrorListFragment
extends Fragment {
    private ErrorAdapter adapter;
    private ErrorAdapter.ErrorClickListListener listener;

    public static Fragment newInstance() {
        return new ErrorListFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof ErrorAdapter.ErrorClickListListener)) {
            throw new IllegalArgumentException("Context must implement the listener.");
        }
        this.listener = (ErrorAdapter.ErrorClickListListener)context;
        RepositoryProvider.throwable().getSortedThrowablesTuples().observe((LifecycleOwner)this, (Observer)new Observer<List<RecordedThrowableTuple>>(){

            public void onChanged(@Nullable List<RecordedThrowableTuple> tuples) {
                ErrorListFragment.this.adapter.setData(tuples);
            }
        });
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.chucker_fragment_error_list, container, false);
        if (view instanceof RecyclerView) {
            RecyclerView recyclerView = (RecyclerView)view;
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.getContext(), 1));
            this.adapter = new ErrorAdapter(this.getContext(), this.listener);
            recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        }
        return view;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.chucker_errors_list, menu2);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear) {
            this.askForConfirmation();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void askForConfirmation() {
        new AlertDialog.Builder(this.getContext()).setTitle(R.string.chucker_clear).setMessage(R.string.chucker_clear_error_confirmation).setPositiveButton(R.string.chucker_clear, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RepositoryProvider.throwable().deleteAllThrowables();
            }
        }).setNegativeButton(R.string.chucker_cancel, null).show();
    }
}

