/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.support;

import android.content.Context;
import com.chuckerteam.chucker.R;
import java.io.EOFException;
import java.nio.charset.Charset;
import okio.Buffer;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

public class IOUtils {
    private final Context context;

    public IOUtils(Context context) {
        this.context = context;
    }

    public boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public String readFromBuffer(Buffer buffer, Charset charset, long maxContentLength) {
        long bufferSize = buffer.size();
        long maxBytes = Math.min(bufferSize, maxContentLength);
        String body = "";
        try {
            body = buffer.readString(maxBytes, charset);
        }
        catch (EOFException e) {
            body = body + this.context.getString(R.string.chucker_body_unexpected_eof);
        }
        if (bufferSize > maxContentLength) {
            body = body + this.context.getString(R.string.chucker_body_content_truncated);
        }
        return body;
    }

    public BufferedSource getNativeSource(BufferedSource input, boolean isGzipped) {
        if (isGzipped) {
            GzipSource source = new GzipSource((Source)input);
            return Okio.buffer((Source)source);
        }
        return input;
    }

    public boolean bodyHasSupportedEncoding(String contentEncoding) {
        return contentEncoding == null || contentEncoding.isEmpty() || contentEncoding.equalsIgnoreCase("identity") || contentEncoding.equalsIgnoreCase("gzip");
    }

    public boolean bodyIsGzipped(String contentEncoding) {
        return "gzip".equalsIgnoreCase(contentEncoding);
    }
}

