/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.ui.transaction;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.api.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.api.internal.support.FormatUtils;
import com.chuckerteam.chucker.api.internal.support.SimpleOnPageChangedListener;
import com.chuckerteam.chucker.api.internal.ui.BaseChuckerActivity;
import com.chuckerteam.chucker.api.internal.ui.transaction.TransactionFragment;
import com.chuckerteam.chucker.api.internal.ui.transaction.TransactionOverviewFragment;
import com.chuckerteam.chucker.api.internal.ui.transaction.TransactionPayloadFragment;
import java.util.ArrayList;
import java.util.List;

public class TransactionActivity
extends BaseChuckerActivity {
    private static final String ARG_TRANSACTION_ID = "transaction_id";
    private static int selectedTabPosition = 0;
    TextView title;
    Adapter adapter;
    private long transactionId;
    private HttpTransaction transaction;

    public static void start(Context context, long transactionId) {
        Intent intent = new Intent(context, TransactionActivity.class);
        intent.putExtra(ARG_TRANSACTION_ID, transactionId);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ViewPager viewPager;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.chucker_activity_transaction);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.title = (TextView)this.findViewById(R.id.toolbar_title);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
        }
        if ((viewPager = (ViewPager)this.findViewById(R.id.viewpager)) != null) {
            this.setupViewPager(viewPager);
        }
        TabLayout tabLayout = (TabLayout)this.findViewById(R.id.tabs);
        tabLayout.setupWithViewPager(viewPager);
        this.transactionId = this.getIntent().getLongExtra(ARG_TRANSACTION_ID, 0L);
    }

    @Override
    protected void onResume() {
        super.onResume();
        RepositoryProvider.transaction().getTransaction(this.transactionId).observe((LifecycleOwner)this, (Observer)new Observer<HttpTransaction>(){

            public void onChanged(@Nullable HttpTransaction observed) {
                TransactionActivity.this.transaction = observed;
                TransactionActivity.this.populateUI(observed);
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.chucker_transaction, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.share_text) {
            this.share(FormatUtils.getShareText((Context)this, this.transaction));
            return true;
        }
        if (item.getItemId() == R.id.share_curl) {
            this.share(FormatUtils.getShareCurlCommand(this.transaction));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void populateUI(HttpTransaction transaction) {
        if (transaction != null) {
            this.title.setText((CharSequence)String.format("%s %s", transaction.getMethod(), transaction.getPath()));
            for (TransactionFragment fragment : this.adapter.fragments) {
                fragment.transactionUpdated(transaction);
            }
        }
    }

    private void setupViewPager(ViewPager viewPager) {
        this.adapter = new Adapter(this.getSupportFragmentManager());
        this.adapter.addFragment(new TransactionOverviewFragment(), this.getString(R.string.chucker_overview));
        this.adapter.addFragment(TransactionPayloadFragment.newInstance(0), this.getString(R.string.chucker_request));
        this.adapter.addFragment(TransactionPayloadFragment.newInstance(1), this.getString(R.string.chucker_response));
        viewPager.setAdapter((PagerAdapter)this.adapter);
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new SimpleOnPageChangedListener(){

            @Override
            public void onPageSelected(int position) {
                selectedTabPosition = position;
            }
        });
        viewPager.setCurrentItem(selectedTabPosition);
    }

    private void share(String content) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", content);
        sendIntent.setType("text/plain");
        this.startActivity(Intent.createChooser((Intent)sendIntent, null));
    }

    static class Adapter
    extends FragmentPagerAdapter {
        final List<TransactionFragment> fragments = new ArrayList<TransactionFragment>();
        private final List<String> fragmentTitles = new ArrayList<String>();

        Adapter(FragmentManager fm) {
            super(fm);
        }

        void addFragment(TransactionFragment fragment, String title) {
            this.fragments.add(fragment);
            this.fragmentTitles.add(title);
        }

        public Fragment getItem(int position) {
            return (Fragment)this.fragments.get(position);
        }

        public int getCount() {
            return this.fragments.size();
        }

        public CharSequence getPageTitle(int position) {
            return this.fragmentTitles.get(position);
        }
    }
}

