/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.ui;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.Chucker;
import com.chuckerteam.chucker.api.internal.ui.BaseChuckerActivity;
import com.chuckerteam.chucker.api.internal.ui.HomePageAdapter;
import com.chuckerteam.chucker.api.internal.ui.error.ErrorActivity;
import com.chuckerteam.chucker.api.internal.ui.error.ErrorAdapter;
import com.chuckerteam.chucker.api.internal.ui.transaction.TransactionActivity;
import com.chuckerteam.chucker.api.internal.ui.transaction.TransactionAdapter;

public class MainActivity
extends BaseChuckerActivity
implements TransactionAdapter.TransactionClickListListener,
ErrorAdapter.ErrorClickListListener {
    public static final String EXTRA_SCREEN = "EXTRA_SCREEN";
    private ViewPager viewPager;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.chucker_activity_main);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setSubtitle((CharSequence)this.getApplicationName());
        this.viewPager = (ViewPager)this.findViewById(R.id.viewPager);
        this.viewPager.setAdapter((PagerAdapter)new HomePageAdapter((Context)this, this.getSupportFragmentManager()));
        TabLayout tabLayout = (TabLayout)this.findViewById(R.id.tabLayout);
        tabLayout.setupWithViewPager(this.viewPager);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TabLayout.TabLayoutOnPageChangeListener(tabLayout){

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                if (position == 0) {
                    Chucker.dismissTransactionsNotification((Context)MainActivity.this);
                } else {
                    Chucker.dismissErrorsNotification((Context)MainActivity.this);
                }
            }
        });
        this.consumeIntent(this.getIntent());
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.consumeIntent(intent);
    }

    private void consumeIntent(Intent intent) {
        int screenToShow = intent.getIntExtra(EXTRA_SCREEN, 1);
        if (screenToShow == 1) {
            this.viewPager.setCurrentItem(0);
        } else {
            this.viewPager.setCurrentItem(1);
        }
    }

    private String getApplicationName() {
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : this.getString(stringId);
    }

    @Override
    public void onErrorClick(long throwableId, int position) {
        ErrorActivity.start((Context)this, throwableId);
    }

    @Override
    public void onTransactionClick(long transactionId, int position) {
        TransactionActivity.start((Context)this, transactionId);
    }
}

