/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.data.room;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.api.internal.data.room.HttpTransactionDao;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class HttpTransactionDao_Impl
implements HttpTransactionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfHttpTransaction;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfHttpTransaction;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBefore;

    public HttpTransactionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHttpTransaction = new EntityInsertionAdapter<HttpTransaction>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `transactions`(`id`,`requestDate`,`responseDate`,`tookMs`,`protocol`,`method`,`url`,`host`,`path`,`scheme`,`requestContentLength`,`requestContentType`,`requestHeaders`,`requestBody`,`isRequestBodyPlainText`,`responseCode`,`responseMessage`,`error`,`responseContentLength`,`responseContentType`,`responseHeaders`,`responseBody`,`isResponseBodyPlainText`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, HttpTransaction value) {
                stmt.bindLong(1, value.getId());
                if (value.getRequestDate() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, value.getRequestDate().longValue());
                }
                if (value.getResponseDate() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, value.getResponseDate().longValue());
                }
                if (value.getTookMs() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, value.getTookMs().longValue());
                }
                if (value.getProtocol() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getProtocol());
                }
                if (value.getMethod() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMethod());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUrl());
                }
                if (value.getHost() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getHost());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getPath());
                }
                if (value.getScheme() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getScheme());
                }
                if (value.getRequestContentLength() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, value.getRequestContentLength().longValue());
                }
                if (value.getRequestContentType() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getRequestContentType());
                }
                if (value.getRequestHeaders() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getRequestHeaders());
                }
                if (value.getRequestBody() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getRequestBody());
                }
                int _tmp = value.isRequestBodyPlainText() ? 1 : 0;
                stmt.bindLong(15, (long)_tmp);
                if (value.getResponseCode() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, (long)value.getResponseCode().intValue());
                }
                if (value.getResponseMessage() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getResponseMessage());
                }
                if (value.getError() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getError());
                }
                if (value.getResponseContentLength() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindLong(19, value.getResponseContentLength().longValue());
                }
                if (value.getResponseContentType() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getResponseContentType());
                }
                if (value.getResponseHeaders() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.getResponseHeaders());
                }
                if (value.getResponseBody() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getResponseBody());
                }
                int _tmp_1 = value.isResponseBodyPlainText() ? 1 : 0;
                stmt.bindLong(23, (long)_tmp_1);
            }
        };
        this.__updateAdapterOfHttpTransaction = new EntityDeletionOrUpdateAdapter<HttpTransaction>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `transactions` SET `id` = ?,`requestDate` = ?,`responseDate` = ?,`tookMs` = ?,`protocol` = ?,`method` = ?,`url` = ?,`host` = ?,`path` = ?,`scheme` = ?,`requestContentLength` = ?,`requestContentType` = ?,`requestHeaders` = ?,`requestBody` = ?,`isRequestBodyPlainText` = ?,`responseCode` = ?,`responseMessage` = ?,`error` = ?,`responseContentLength` = ?,`responseContentType` = ?,`responseHeaders` = ?,`responseBody` = ?,`isResponseBodyPlainText` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, HttpTransaction value) {
                stmt.bindLong(1, value.getId());
                if (value.getRequestDate() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, value.getRequestDate().longValue());
                }
                if (value.getResponseDate() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, value.getResponseDate().longValue());
                }
                if (value.getTookMs() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, value.getTookMs().longValue());
                }
                if (value.getProtocol() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getProtocol());
                }
                if (value.getMethod() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMethod());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUrl());
                }
                if (value.getHost() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getHost());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getPath());
                }
                if (value.getScheme() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getScheme());
                }
                if (value.getRequestContentLength() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, value.getRequestContentLength().longValue());
                }
                if (value.getRequestContentType() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getRequestContentType());
                }
                if (value.getRequestHeaders() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getRequestHeaders());
                }
                if (value.getRequestBody() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getRequestBody());
                }
                int _tmp = value.isRequestBodyPlainText() ? 1 : 0;
                stmt.bindLong(15, (long)_tmp);
                if (value.getResponseCode() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, (long)value.getResponseCode().intValue());
                }
                if (value.getResponseMessage() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getResponseMessage());
                }
                if (value.getError() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getError());
                }
                if (value.getResponseContentLength() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindLong(19, value.getResponseContentLength().longValue());
                }
                if (value.getResponseContentType() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getResponseContentType());
                }
                if (value.getResponseHeaders() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.getResponseHeaders());
                }
                if (value.getResponseBody() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getResponseBody());
                }
                int _tmp_1 = value.isResponseBodyPlainText() ? 1 : 0;
                stmt.bindLong(23, (long)_tmp_1);
                stmt.bindLong(24, value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM transactions";
                return "DELETE FROM transactions";
            }
        };
        this.__preparedStmtOfDeleteBefore = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM transactions WHERE requestDate <= ?";
                return "DELETE FROM transactions WHERE requestDate <= ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long insert(HttpTransaction transaction) {
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfHttpTransaction.insertAndReturnId((Object)transaction);
            this.__db.setTransactionSuccessful();
            Long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(HttpTransaction transaction) {
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__updateAdapterOfHttpTransaction.handle((Object)transaction);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBefore(long threshold) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteBefore.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, threshold);
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteBefore.release(_stmt);
        }
    }

    @Override
    public LiveData<List<HttpTransactionTuple>> getSortedTuples() {
        String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestContentLength, responseContentLength, error FROM transactions ORDER BY requestDate DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestContentLength, responseContentLength, error FROM transactions ORDER BY requestDate DESC", (int)0);
        return new ComputableLiveData<List<HttpTransactionTuple>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<HttpTransactionTuple> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("transactions", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    HttpTransactionDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = HttpTransactionDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfRequestDate = _cursor.getColumnIndexOrThrow("requestDate");
                    int _cursorIndexOfTookMs = _cursor.getColumnIndexOrThrow("tookMs");
                    int _cursorIndexOfProtocol = _cursor.getColumnIndexOrThrow("protocol");
                    int _cursorIndexOfMethod = _cursor.getColumnIndexOrThrow("method");
                    int _cursorIndexOfHost = _cursor.getColumnIndexOrThrow("host");
                    int _cursorIndexOfPath = _cursor.getColumnIndexOrThrow("path");
                    int _cursorIndexOfScheme = _cursor.getColumnIndexOrThrow("scheme");
                    int _cursorIndexOfResponseCode = _cursor.getColumnIndexOrThrow("responseCode");
                    int _cursorIndexOfRequestContentLength = _cursor.getColumnIndexOrThrow("requestContentLength");
                    int _cursorIndexOfResponseContentLength = _cursor.getColumnIndexOrThrow("responseContentLength");
                    int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("error");
                    ArrayList<HttpTransactionTuple> _result = new ArrayList<HttpTransactionTuple>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        Long _tmpRequestContentLength = _cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestContentLength));
                        Long _tmpResponseContentLength = _cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseContentLength));
                        String _tmpError = _cursor.getString(_cursorIndexOfError);
                        HttpTransactionTuple _item = new HttpTransactionTuple(_tmpId, _tmpRequestDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseCode, _tmpRequestContentLength, _tmpResponseContentLength, _tmpError);
                        _result.add(_item);
                    }
                    ArrayList<HttpTransactionTuple> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<HttpTransactionTuple>> getFilteredTuples(String codeQuery, String pathQuery) {
        String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestContentLength, responseContentLength, error FROM transactions WHERE responseCode LIKE ? AND path LIKE ? ORDER BY requestDate DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestContentLength, responseContentLength, error FROM transactions WHERE responseCode LIKE ? AND path LIKE ? ORDER BY requestDate DESC", (int)2);
        int _argIndex = 1;
        if (codeQuery == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, codeQuery);
        }
        _argIndex = 2;
        if (pathQuery == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pathQuery);
        }
        return new ComputableLiveData<List<HttpTransactionTuple>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<HttpTransactionTuple> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("transactions", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    HttpTransactionDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = HttpTransactionDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfRequestDate = _cursor.getColumnIndexOrThrow("requestDate");
                    int _cursorIndexOfTookMs = _cursor.getColumnIndexOrThrow("tookMs");
                    int _cursorIndexOfProtocol = _cursor.getColumnIndexOrThrow("protocol");
                    int _cursorIndexOfMethod = _cursor.getColumnIndexOrThrow("method");
                    int _cursorIndexOfHost = _cursor.getColumnIndexOrThrow("host");
                    int _cursorIndexOfPath = _cursor.getColumnIndexOrThrow("path");
                    int _cursorIndexOfScheme = _cursor.getColumnIndexOrThrow("scheme");
                    int _cursorIndexOfResponseCode = _cursor.getColumnIndexOrThrow("responseCode");
                    int _cursorIndexOfRequestContentLength = _cursor.getColumnIndexOrThrow("requestContentLength");
                    int _cursorIndexOfResponseContentLength = _cursor.getColumnIndexOrThrow("responseContentLength");
                    int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("error");
                    ArrayList<HttpTransactionTuple> _result = new ArrayList<HttpTransactionTuple>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        Long _tmpRequestContentLength = _cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestContentLength));
                        Long _tmpResponseContentLength = _cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseContentLength));
                        String _tmpError = _cursor.getString(_cursorIndexOfError);
                        HttpTransactionTuple _item = new HttpTransactionTuple(_tmpId, _tmpRequestDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpHost, _tmpPath, _tmpScheme, _tmpResponseCode, _tmpRequestContentLength, _tmpResponseContentLength, _tmpError);
                        _result.add(_item);
                    }
                    ArrayList<HttpTransactionTuple> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<HttpTransaction> getById(long id) {
        String _sql = "SELECT * FROM transactions WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM transactions WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id);
        return new ComputableLiveData<HttpTransaction>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected HttpTransaction compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("transactions", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    HttpTransactionDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = HttpTransactionDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    HttpTransaction _result;
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfRequestDate = _cursor.getColumnIndexOrThrow("requestDate");
                    int _cursorIndexOfResponseDate = _cursor.getColumnIndexOrThrow("responseDate");
                    int _cursorIndexOfTookMs = _cursor.getColumnIndexOrThrow("tookMs");
                    int _cursorIndexOfProtocol = _cursor.getColumnIndexOrThrow("protocol");
                    int _cursorIndexOfMethod = _cursor.getColumnIndexOrThrow("method");
                    int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("url");
                    int _cursorIndexOfHost = _cursor.getColumnIndexOrThrow("host");
                    int _cursorIndexOfPath = _cursor.getColumnIndexOrThrow("path");
                    int _cursorIndexOfScheme = _cursor.getColumnIndexOrThrow("scheme");
                    int _cursorIndexOfRequestContentLength = _cursor.getColumnIndexOrThrow("requestContentLength");
                    int _cursorIndexOfRequestContentType = _cursor.getColumnIndexOrThrow("requestContentType");
                    int _cursorIndexOfRequestHeaders = _cursor.getColumnIndexOrThrow("requestHeaders");
                    int _cursorIndexOfRequestBody = _cursor.getColumnIndexOrThrow("requestBody");
                    int _cursorIndexOfIsRequestBodyPlainText = _cursor.getColumnIndexOrThrow("isRequestBodyPlainText");
                    int _cursorIndexOfResponseCode = _cursor.getColumnIndexOrThrow("responseCode");
                    int _cursorIndexOfResponseMessage = _cursor.getColumnIndexOrThrow("responseMessage");
                    int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("error");
                    int _cursorIndexOfResponseContentLength = _cursor.getColumnIndexOrThrow("responseContentLength");
                    int _cursorIndexOfResponseContentType = _cursor.getColumnIndexOrThrow("responseContentType");
                    int _cursorIndexOfResponseHeaders = _cursor.getColumnIndexOrThrow("responseHeaders");
                    int _cursorIndexOfResponseBody = _cursor.getColumnIndexOrThrow("responseBody");
                    int _cursorIndexOfIsResponseBodyPlainText = _cursor.getColumnIndexOrThrow("isResponseBodyPlainText");
                    if (_cursor.moveToFirst()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        Long _tmpRequestDate = _cursor.isNull(_cursorIndexOfRequestDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestDate));
                        Long _tmpResponseDate = _cursor.isNull(_cursorIndexOfResponseDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseDate));
                        Long _tmpTookMs = _cursor.isNull(_cursorIndexOfTookMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTookMs));
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        Long _tmpRequestContentLength = _cursor.isNull(_cursorIndexOfRequestContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfRequestContentLength));
                        String _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
                        String _tmpRequestHeaders = _cursor.getString(_cursorIndexOfRequestHeaders);
                        String _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsRequestBodyPlainText);
                        boolean _tmpIsRequestBodyPlainText = _tmp != 0;
                        Integer _tmpResponseCode = _cursor.isNull(_cursorIndexOfResponseCode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfResponseCode));
                        String _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
                        String _tmpError = _cursor.getString(_cursorIndexOfError);
                        Long _tmpResponseContentLength = _cursor.isNull(_cursorIndexOfResponseContentLength) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfResponseContentLength));
                        String _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
                        String _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
                        String _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsResponseBodyPlainText);
                        boolean _tmpIsResponseBodyPlainText = _tmp_1 != 0;
                        _result = new HttpTransaction(_tmpId, _tmpRequestDate, _tmpResponseDate, _tmpTookMs, _tmpProtocol, _tmpMethod, _tmpUrl, _tmpHost, _tmpPath, _tmpScheme, _tmpRequestContentLength, _tmpRequestContentType, _tmpRequestHeaders, _tmpRequestBody, _tmpIsRequestBodyPlainText, _tmpResponseCode, _tmpResponseMessage, _tmpError, _tmpResponseContentLength, _tmpResponseContentType, _tmpResponseHeaders, _tmpResponseBody, _tmpIsResponseBodyPlainText);
                    } else {
                        _result = null;
                    }
                    HttpTransaction httpTransaction = _result;
                    return httpTransaction;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }
}

