/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.data.repository;

import android.arch.lifecycle.LiveData;
import com.chuckerteam.chucker.api.internal.data.entity.RecordedThrowable;
import com.chuckerteam.chucker.api.internal.data.entity.RecordedThrowableTuple;
import com.chuckerteam.chucker.api.internal.data.repository.RecordedThrowableRepository;
import com.chuckerteam.chucker.api.internal.data.room.ChuckerDatabase;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\rH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/chuckerteam/chucker/api/internal/data/repository/RecordedThrowableDatabaseRepository;", "Lcom/chuckerteam/chucker/api/internal/data/repository/RecordedThrowableRepository;", "database", "Lcom/chuckerteam/chucker/api/internal/data/room/ChuckerDatabase;", "(Lcom/chuckerteam/chucker/api/internal/data/room/ChuckerDatabase;)V", "executor", "Ljava/util/concurrent/Executor;", "deleteAllThrowables", "", "deleteOldThrowables", "threshold", "", "getRecordedThrowable", "Landroid/arch/lifecycle/LiveData;", "Lcom/chuckerteam/chucker/api/internal/data/entity/RecordedThrowable;", "id", "getSortedThrowablesTuples", "", "Lcom/chuckerteam/chucker/api/internal/data/entity/RecordedThrowableTuple;", "saveThrowable", "throwable", "library_release"})
public final class RecordedThrowableDatabaseRepository
implements RecordedThrowableRepository {
    private final Executor executor;
    private final ChuckerDatabase database;

    @Override
    @NotNull
    public LiveData<RecordedThrowable> getRecordedThrowable(long id2) {
        return this.database.throwableDao().getById(id2);
    }

    @Override
    public void deleteAllThrowables() {
        this.executor.execute(new Runnable(this){
            final /* synthetic */ RecordedThrowableDatabaseRepository this$0;

            public final void run() {
                RecordedThrowableDatabaseRepository.access$getDatabase$p(this.this$0).throwableDao().deleteAll();
            }
            {
                this.this$0 = recordedThrowableDatabaseRepository;
            }
        });
    }

    @Override
    @NotNull
    public LiveData<List<RecordedThrowableTuple>> getSortedThrowablesTuples() {
        return this.database.throwableDao().getTuples();
    }

    @Override
    public void saveThrowable(@NotNull RecordedThrowable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        this.executor.execute(new Runnable(this, throwable){
            final /* synthetic */ RecordedThrowableDatabaseRepository this$0;
            final /* synthetic */ RecordedThrowable $throwable;

            public final void run() {
                RecordedThrowableDatabaseRepository.access$getDatabase$p(this.this$0).throwableDao().insert(this.$throwable);
            }
            {
                this.this$0 = recordedThrowableDatabaseRepository;
                this.$throwable = recordedThrowable;
            }
        });
    }

    @Override
    public void deleteOldThrowables(long threshold) {
        this.executor.execute(new Runnable(this, threshold){
            final /* synthetic */ RecordedThrowableDatabaseRepository this$0;
            final /* synthetic */ long $threshold;

            public final void run() {
                RecordedThrowableDatabaseRepository.access$getDatabase$p(this.this$0).throwableDao().deleteBefore(this.$threshold);
            }
            {
                this.this$0 = recordedThrowableDatabaseRepository;
                this.$threshold = l;
            }
        });
    }

    public RecordedThrowableDatabaseRepository(@NotNull ChuckerDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)database), (String)"database");
        this.database = database;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        this.executor = executorService;
    }

    public static final /* synthetic */ ChuckerDatabase access$getDatabase$p(RecordedThrowableDatabaseRepository $this) {
        return $this.database;
    }
}

