/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import com.chuckerteam.chucker.api.RetentionManager;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.api.internal.data.entity.RecordedThrowable;
import com.chuckerteam.chucker.api.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.api.internal.support.NotificationHelper;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0015\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerCollector;", "", "context", "Landroid/content/Context;", "showNotification", "", "retentionManager", "Lcom/chuckerteam/chucker/api/RetentionManager;", "(Landroid/content/Context;ZLcom/chuckerteam/chucker/api/RetentionManager;)V", "notificationHelper", "Lcom/chuckerteam/chucker/api/internal/support/NotificationHelper;", "getRetentionManager", "()Lcom/chuckerteam/chucker/api/RetentionManager;", "setRetentionManager", "(Lcom/chuckerteam/chucker/api/RetentionManager;)V", "getShowNotification", "()Z", "setShowNotification", "(Z)V", "onError", "", "tag", "", "throwable", "", "onRequestSent", "transaction", "Lcom/chuckerteam/chucker/api/internal/data/entity/HttpTransaction;", "onRequestSent$library_release", "onResponseReceived", "onResponseReceived$library_release", "library_release"})
public final class ChuckerCollector {
    private final NotificationHelper notificationHelper;
    private boolean showNotification;
    @NotNull
    private RetentionManager retentionManager;

    public final void onError(@NotNull String tag, @NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        RecordedThrowable recordedThrowable = new RecordedThrowable(tag, throwable);
        RepositoryProvider.throwable().saveThrowable(recordedThrowable);
        if (this.showNotification) {
            this.notificationHelper.show(recordedThrowable);
        }
        this.retentionManager.doMaintenance$library_release();
    }

    public final void onRequestSent$library_release(@NotNull HttpTransaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        RepositoryProvider.transaction().insertTransaction(transaction);
        if (this.showNotification) {
            this.notificationHelper.show(transaction);
        }
        this.retentionManager.doMaintenance$library_release();
    }

    public final void onResponseReceived$library_release(@NotNull HttpTransaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        int updated = RepositoryProvider.transaction().updateTransaction(transaction);
        if (this.showNotification && updated > 0) {
            this.notificationHelper.show(transaction);
        }
    }

    public final boolean getShowNotification() {
        return this.showNotification;
    }

    public final void setShowNotification(boolean bl) {
        this.showNotification = bl;
    }

    @NotNull
    public final RetentionManager getRetentionManager() {
        return this.retentionManager;
    }

    public final void setRetentionManager(@NotNull RetentionManager retentionManager) {
        Intrinsics.checkParameterIsNotNull((Object)retentionManager, (String)"<set-?>");
        this.retentionManager = retentionManager;
    }

    @JvmOverloads
    public ChuckerCollector(@NotNull Context context, boolean showNotification, @NotNull RetentionManager retentionManager) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)retentionManager, (String)"retentionManager");
        this.showNotification = showNotification;
        this.retentionManager = retentionManager;
        this.notificationHelper = new NotificationHelper(context);
        RepositoryProvider.initialize(context);
    }

    @JvmOverloads
    public /* synthetic */ ChuckerCollector(Context context, boolean bl, RetentionManager retentionManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            retentionManager = new RetentionManager(context, null, 2, null);
        }
        this(context, bl, retentionManager);
    }

    @JvmOverloads
    public ChuckerCollector(@NotNull Context context, boolean showNotification) {
        this(context, showNotification, null, 4, null);
    }

    @JvmOverloads
    public ChuckerCollector(@NotNull Context context) {
        this(context, false, null, 6, null);
    }
}

