/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui.error;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.LoaderManager;
import android.support.v4.app.ShareCompat;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.ChuckContentProvider;
import com.readystatesoftware.chuck.internal.data.LocalCupboard;
import com.readystatesoftware.chuck.internal.data.RecordedThrowable;
import java.io.Serializable;
import java.text.DateFormat;

public class ErrorActivity
extends AppCompatActivity
implements LoaderManager.LoaderCallbacks<Cursor> {
    public static final String EXTRA_ID = "EXTRA_ID";
    private long throwableId;
    private RecordedThrowable throwable;
    private TextView title;
    private TextView tag;
    private TextView clazz;
    private TextView message;
    private TextView date;
    private TextView stacktrace;

    public static void start(Context context, Long id2) {
        Intent intent = new Intent(context, ErrorActivity.class);
        intent.putExtra(EXTRA_ID, (Serializable)id2);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.chuck_activity_error);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.title = (TextView)this.findViewById(R.id.toolbar_title);
        ActionBar ab = this.getSupportActionBar();
        ab.setDisplayHomeAsUpEnabled(true);
        this.tag = (TextView)this.findViewById(R.id.tag);
        this.clazz = (TextView)this.findViewById(R.id.clazz);
        this.message = (TextView)this.findViewById(R.id.message);
        this.date = (TextView)this.findViewById(R.id.date);
        this.stacktrace = (TextView)this.findViewById(R.id.stacktrace);
        this.date.setVisibility(8);
        this.throwableId = this.getIntent().getLongExtra(EXTRA_ID, 0L);
        this.getSupportLoaderManager().initLoader(2, null, (LoaderManager.LoaderCallbacks)this);
    }

    protected void onResume() {
        super.onResume();
        this.getSupportLoaderManager().restartLoader(2, null, (LoaderManager.LoaderCallbacks)this);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.chuck_error, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.share_text) {
            this.share(this.throwable);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void share(RecordedThrowable throwable) {
        String text = this.getString(R.string.chuck_share_error_content, new Object[]{DateFormat.getDateTimeInstance(3, 2).format(throwable.getDate()), throwable.getClazz(), throwable.getTag(), throwable.getMessage(), throwable.getContent()});
        this.startActivity(ShareCompat.IntentBuilder.from((Activity)this).setType("text/plain").setSubject(this.getString(R.string.chuck_share_error_title)).setText((CharSequence)text).createChooserIntent());
    }

    @NonNull
    public Loader<Cursor> onCreateLoader(int id2, @Nullable Bundle args) {
        CursorLoader loader = new CursorLoader((Context)this);
        loader.setUri(ContentUris.withAppendedId((Uri)ChuckContentProvider.ERROR_URI, (long)this.throwableId));
        return loader;
    }

    public void onLoadFinished(@NonNull Loader<Cursor> loader, Cursor data) {
        this.throwable = (RecordedThrowable)LocalCupboard.getInstance().withCursor(data).get(RecordedThrowable.class);
        this.populateUI();
    }

    public void onLoaderReset(@NonNull Loader<Cursor> loader) {
    }

    private void populateUI() {
        if (this.throwable != null) {
            String dateStr = DateFormat.getDateTimeInstance(3, 2).format(this.throwable.getDate());
            this.title.setText((CharSequence)dateStr);
            this.tag.setText((CharSequence)this.throwable.getTag());
            this.clazz.setText((CharSequence)this.throwable.getClazz());
            this.message.setText((CharSequence)this.throwable.getMessage());
            this.stacktrace.setText((CharSequence)this.throwable.getContent());
        }
    }
}

