/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.api.Chuck;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.data.RecordedThrowable;
import com.readystatesoftware.chuck.internal.ui.BaseChuckActivity;
import com.readystatesoftware.chuck.internal.ui.HomePageAdapter;
import com.readystatesoftware.chuck.internal.ui.error.ErrorActivity;
import com.readystatesoftware.chuck.internal.ui.error.ErrorAdapter;
import com.readystatesoftware.chuck.internal.ui.transaction.TransactionActivity;
import com.readystatesoftware.chuck.internal.ui.transaction.TransactionListFragment;

public class MainActivity
extends BaseChuckActivity
implements TransactionListFragment.OnListFragmentInteractionListener,
ErrorAdapter.ErrorListListener {
    public static final String EXTRA_SCREEN = "EXTRA_SCREEN";
    private ViewPager viewPager;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.chuck_activity_main);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setSubtitle((CharSequence)this.getApplicationName());
        this.viewPager = (ViewPager)this.findViewById(R.id.viewPager);
        this.viewPager.setAdapter((PagerAdapter)new HomePageAdapter((Context)this, this.getSupportFragmentManager()));
        TabLayout tabLayout = (TabLayout)this.findViewById(R.id.tabLayout);
        tabLayout.setupWithViewPager(this.viewPager);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TabLayout.TabLayoutOnPageChangeListener(tabLayout){

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                if (position == 0) {
                    Chuck.dismissTransactionsNotification();
                } else {
                    Chuck.dismissErrorsNotification();
                }
            }
        });
        this.consumeIntent(this.getIntent());
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.consumeIntent(intent);
    }

    private void consumeIntent(Intent intent) {
        int screenToShow = intent.getIntExtra(EXTRA_SCREEN, 1);
        if (screenToShow == 1) {
            this.viewPager.setCurrentItem(0);
        } else {
            this.viewPager.setCurrentItem(1);
        }
    }

    @Override
    public void onListFragmentInteraction(HttpTransaction transaction) {
        TransactionActivity.start((Context)this, transaction.getId());
    }

    @Override
    public void onClick(RecordedThrowable throwable) {
        ErrorActivity.start((Context)this, throwable.getId());
    }

    private String getApplicationName() {
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : this.getString(stringId);
    }
}

