/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.support;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;

public class SQLiteUtils {
    public static void browseDatabase(Context context) {
        if (SQLiteUtils.isIntentResolvable(context, SQLiteUtils.getSQLiteDebuggerAppIntent("/"))) {
            String path = SQLiteUtils.extractDatabase(context);
            if (path != null) {
                Intent intent = SQLiteUtils.getSQLiteDebuggerAppIntent(path);
                context.startActivity(intent);
            } else {
                Toast.makeText((Context)context, (CharSequence)"Unable to extract database", (int)0).show();
            }
        } else {
            Toast.makeText((Context)context, (CharSequence)"Unable to resolve a SQLite Intent", (int)0).show();
        }
    }

    private static String extractDatabase(Context context) {
        try {
            File external = context.getExternalFilesDir(null);
            File data = Environment.getDataDirectory();
            if (external != null && external.canWrite()) {
                String dataDBPath = "data/" + context.getPackageName() + "/databases/chuck.db";
                String extractDBPath = "chuckdb.temp";
                File dataDB = new File(data, dataDBPath);
                File extractDB = new File(external, extractDBPath);
                if (dataDB.exists()) {
                    FileChannel in = new FileInputStream(dataDB).getChannel();
                    FileChannel out = new FileOutputStream(extractDB).getChannel();
                    out.transferFrom(in, 0L, in.size());
                    in.close();
                    out.close();
                    return extractDB.getAbsolutePath();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Intent getSQLiteDebuggerAppIntent(String path) {
        Intent intent = new Intent("android.intent.action.EDIT");
        intent.setData(Uri.parse((String)("sqlite:" + path)));
        return intent;
    }

    private static boolean isIntentResolvable(Context context, Intent intent) {
        return context.getPackageManager().resolveActivity(intent, 0) != null;
    }
}

