/*
 * Decompiled with CFR 0.152.
 */
package com.nareshchocha.filepickerlibrary.ui.activitys;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.Keep;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import com.nareshchocha.filepickerlibrary.R;
import com.nareshchocha.filepickerlibrary.models.DocumentFilePickerConfig;
import com.nareshchocha.filepickerlibrary.permission.PermissionUtils;
import com.nareshchocha.filepickerlibrary.picker.PickerUtils;
import com.nareshchocha.filepickerlibrary.utilities.FileUtils;
import com.nareshchocha.filepickerlibrary.utilities.extentions.ExtentionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u001c\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a*\u00020\rH\u0002J*\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0018j\b\u0012\u0004\u0012\u00020\u0005`\u001a*\b\u0012\u0004\u0012\u00020\u00190\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\r0\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/nareshchocha/filepickerlibrary/ui/activitys/DocumentFilePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "checkPermission", "Landroidx/activity/result/ActivityResultLauncher;", "", "mDocumentFilePickerConfig", "Lcom/nareshchocha/filepickerlibrary/models/DocumentFilePickerConfig;", "getMDocumentFilePickerConfig", "()Lcom/nareshchocha/filepickerlibrary/models/DocumentFilePickerConfig;", "mDocumentFilePickerConfig$delegate", "Lkotlin/Lazy;", "selectFile", "Landroid/content/Intent;", "settingCameraResultLauncher", "kotlin.jvm.PlatformType", "", "launchFilePicker", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "showAskDialog", "showGotoSettingDialog", "getClipDataUris", "Ljava/util/ArrayList;", "Landroid/net/Uri;", "Lkotlin/collections/ArrayList;", "getFilePathList", "", "context", "Landroid/content/Context;", "Companion", "filepickerlibrary_release"})
@SourceDebugExtension(value={"SMAP\nDocumentFilePickerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentFilePickerActivity.kt\ncom/nareshchocha/filepickerlibrary/ui/activitys/DocumentFilePickerActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1855#2,2:236\n*S KotlinDebug\n*F\n+ 1 DocumentFilePickerActivity.kt\ncom/nareshchocha/filepickerlibrary/ui/activitys/DocumentFilePickerActivity\n*L\n99#1:236,2\n*E\n"})
public final class DocumentFilePickerActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy mDocumentFilePickerConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DocumentFilePickerConfig>(this){
        final /* synthetic */ DocumentFilePickerActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @Nullable
        public final DocumentFilePickerConfig invoke() {
            return Build.VERSION.SDK_INT >= 33 ? (DocumentFilePickerConfig)this.this$0.getIntent().getParcelableExtra("PICK_DOCUMENT", DocumentFilePickerConfig.class) : (DocumentFilePickerConfig)this.this$0.getIntent().getParcelableExtra("PICK_DOCUMENT");
        }
    }));
    @NotNull
    private final ActivityResultLauncher<String> checkPermission = PermissionUtils.INSTANCE.checkPermission(this, (ActivityResultContract)new ActivityResultContracts.RequestPermission(), (Function1)new Function1<Boolean, Unit>(this){
        final /* synthetic */ DocumentFilePickerActivity this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(boolean it) {
            if (it) {
                DocumentFilePickerActivity.access$launchFilePicker(this.this$0);
            } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this.this$0), (String)com.nareshchocha.filepickerlibrary.ui.activitys.DocumentFilePickerActivity$Companion.access$getPermission(DocumentFilePickerActivity.Companion))) {
                DocumentFilePickerActivity.access$showAskDialog(this.this$0);
            } else {
                DocumentFilePickerActivity.access$showGotoSettingDialog(this.this$0);
            }
        }
    });
    @NotNull
    private final ActivityResultLauncher<Intent> selectFile = PickerUtils.INSTANCE.selectFile(this, (ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), (Function1)new Function1<ActivityResult, Unit>(this){
        final /* synthetic */ DocumentFilePickerActivity this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void invoke(@NotNull ActivityResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (result.getResultCode() == -1 && result.getData() != null) {
                String string2;
                Uri data;
                DocumentFilePickerConfig documentFilePickerConfig = DocumentFilePickerActivity.access$getMDocumentFilePickerConfig(this.this$0);
                if (documentFilePickerConfig != null ? Intrinsics.areEqual((Object)documentFilePickerConfig.getAllowMultiple(), (Object)true) : false) {
                    Intent intent = result.getData();
                    if ((intent != null ? intent.getClipData() : null) != null) {
                        Intent intent2 = result.getData();
                        ArrayList uris = intent2 != null ? DocumentFilePickerActivity.access$getClipDataUris(this.this$0, intent2) : null;
                        ArrayList filePaths = uris != null ? DocumentFilePickerActivity.access$getFilePathList(this.this$0, uris, (Context)this.this$0) : null;
                        Timber.Forest.tag("FILE_RESULT ::").v("File Uri ::: " + uris, new Object[0]);
                        Timber.Forest.tag("FILE_RESULT ::").v("filePath ::: " + filePaths, new Object[0]);
                        ExtentionsKt.setSuccessResult$default((Activity)this.this$0, uris, filePaths, false, 4, null);
                        return;
                    }
                }
                Intent intent = result.getData();
                if ((intent != null ? intent.getData() : null) == null) return;
                Intent intent3 = result.getData();
                Uri uri = data = intent3 != null ? intent3.getData() : null;
                if (uri != null) {
                    Uri uri2 = uri;
                    DocumentFilePickerActivity documentFilePickerActivity = this.this$0;
                    Uri it = uri2;
                    boolean bl = false;
                    string2 = FileUtils.INSTANCE.getRealPath((Context)documentFilePickerActivity, it);
                } else {
                    string2 = null;
                }
                String filePath = string2;
                Uri uri3 = data;
                Timber.Forest.tag("FILE_RESULT ::").v("File Uri ::: " + (uri3 != null ? uri3.toString() : null), new Object[0]);
                Timber.Forest.tag("FILE_RESULT ::").v("filePath ::: " + filePath, new Object[0]);
                ExtentionsKt.setSuccessResult$default((Activity)this.this$0, data, filePath, false, 4, null);
                return;
            }
            Timber.Forest.tag("FILE_PICKER_ERROR ::").v(this.this$0.getString(R.string.err_document_pick_error), new Object[0]);
            ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_document_pick_error));
        }
    });
    @NotNull
    private final ActivityResultLauncher<Intent> settingCameraResultLauncher;

    public DocumentFilePickerActivity() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> DocumentFilePickerActivity.settingCameraResultLauncher$lambda$3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.settingCameraResultLauncher = activityResultLauncher;
    }

    private final DocumentFilePickerConfig getMDocumentFilePickerConfig() {
        Lazy lazy = this.mDocumentFilePickerConfig$delegate;
        return (DocumentFilePickerConfig)lazy.getValue();
    }

    private final ArrayList<Uri> getClipDataUris(Intent $this$getClipDataUris) {
        LinkedHashSet<Uri> resultSet = new LinkedHashSet<Uri>();
        Uri uri = $this$getClipDataUris.getData();
        if (uri != null) {
            Uri data = uri;
            boolean bl = false;
            resultSet.add(data);
        }
        ClipData clipData = $this$getClipDataUris.getClipData();
        if (clipData == null && resultSet.isEmpty()) {
            return new ArrayList<Uri>();
        }
        if (clipData != null) {
            int n = clipData.getItemCount();
            for (int i = 0; i < n; ++i) {
                Uri uri2 = clipData.getItemAt(i).getUri();
                if (uri2 == null) continue;
                resultSet.add(uri2);
            }
        }
        return new ArrayList<Uri>((Collection)resultSet);
    }

    private final ArrayList<String> getFilePathList(List<? extends Uri> $this$getFilePathList, Context context) {
        ArrayList<String> filePathList = new ArrayList<String>();
        Iterable $this$forEach$iv = $this$getFilePathList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2;
            Uri uri = (Uri)element$iv;
            boolean bl = false;
            if (FileUtils.INSTANCE.getRealPath(context, uri) == null) continue;
            String filePath = string2;
            boolean bl2 = false;
            filePathList.add(filePath);
        }
        return filePathList;
    }

    private final void launchFilePicker() {
        if (this.getMDocumentFilePickerConfig() != null) {
            DocumentFilePickerConfig documentFilePickerConfig = this.getMDocumentFilePickerConfig();
            Intrinsics.checkNotNull((Object)documentFilePickerConfig);
            this.selectFile.launch((Object)ExtentionsKt.getDocumentFilePick(documentFilePickerConfig));
        } else {
            Object[] objectArray = new Object[]{new PropertyReference0Impl((Object)this){

                @Nullable
                public Object get() {
                    return DocumentFilePickerActivity.access$getMDocumentFilePickerConfig((DocumentFilePickerActivity)((Object)this.receiver));
                }
            }.getClass().getName()};
            ExtentionsKt.setCanceledResult((Activity)this, this.getString(R.string.err_config_null, objectArray));
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
        super.onCreate(savedInstanceState);
        this.setTitle("");
        if (Build.VERSION.SDK_INT >= 23) {
            this.checkPermission();
        } else {
            this.launchFilePicker();
        }
    }

    private final void showAskDialog() {
        Object object;
        Context context = (Context)this;
        Object object2 = this.getMDocumentFilePickerConfig();
        if (object2 == null || (object2 = ((DocumentFilePickerConfig)object2).getAskPermissionTitle()) == null) {
            String string2 = this.getString(R.string.err_permission_denied);
            object2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.err_permission_denied)");
        }
        if ((object = this.getMDocumentFilePickerConfig()) == null || (object = ((DocumentFilePickerConfig)object).getAskPermissionMessage()) == null) {
            Object[] objectArray = new Object[1];
            String[] stringArray = new String[]{"."};
            String string3 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)DocumentFilePickerActivity.Companion.getPermission(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (string3 == null) {
                string3 = "";
            }
            objectArray[0] = string3;
            String string4 = this.getString(R.string.err_write_storage_permission, objectArray);
            object = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(\n             \u2026ll() ?: \"\",\n            )");
        }
        ExtentionsKt.showMyDialog$default(context, (String)object2, (String)object, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DocumentFilePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_permission_result));
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DocumentFilePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DocumentFilePickerActivity.access$checkPermission(this.this$0);
            }
        }, 4, null);
    }

    private final void showGotoSettingDialog() {
        if (this.getMDocumentFilePickerConfig() != null) {
            Object object;
            Context context = (Context)this;
            Object object2 = this.getMDocumentFilePickerConfig();
            if (object2 == null || (object2 = ((DocumentFilePickerConfig)object2).getSettingPermissionTitle()) == null) {
                String string2 = this.getString(R.string.err_permission_denied);
                object2 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.err_permission_denied)");
            }
            if ((object = this.getMDocumentFilePickerConfig()) == null || (object = ((DocumentFilePickerConfig)object).getSettingPermissionMessage()) == null) {
                Object[] objectArray = new Object[1];
                String[] stringArray = new String[]{"."};
                String string3 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)DocumentFilePickerActivity.Companion.getPermission(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                if (string3 == null) {
                    string3 = "";
                }
                objectArray[0] = string3;
                String string4 = this.getString(R.string.err_write_storage_setting, objectArray);
                object = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(\n             \u2026 ?: \"\",\n                )");
            }
            ExtentionsKt.showMyDialog(context, (String)object2, (String)object, this.getString(R.string.str_go_to_setting), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DocumentFilePickerActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_permission_result));
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DocumentFilePickerActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    DocumentFilePickerActivity.access$getSettingCameraResultLauncher$p(this.this$0).launch((Object)ExtentionsKt.getSettingIntent((Context)this.this$0));
                }
            }));
        } else {
            Object[] objectArray = new Object[]{new PropertyReference0Impl((Object)this){

                @Nullable
                public Object get() {
                    return DocumentFilePickerActivity.access$getMDocumentFilePickerConfig((DocumentFilePickerActivity)((Object)this.receiver));
                }
            }.getClass().getName()};
            ExtentionsKt.setCanceledResult((Activity)this, this.getString(R.string.err_config_null, objectArray));
        }
    }

    private final void checkPermission() {
        if (this.getMDocumentFilePickerConfig() != null) {
            this.checkPermission.launch((Object)DocumentFilePickerActivity.Companion.getPermission());
        } else {
            Object[] objectArray = new Object[]{new PropertyReference0Impl((Object)this){

                @Nullable
                public Object get() {
                    return DocumentFilePickerActivity.access$getMDocumentFilePickerConfig((DocumentFilePickerActivity)((Object)this.receiver));
                }
            }.getClass().getName()};
            ExtentionsKt.setCanceledResult((Activity)this, this.getString(R.string.err_config_null, objectArray));
        }
    }

    private static final void settingCameraResultLauncher$lambda$3(DocumentFilePickerActivity this$0, ActivityResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.getMDocumentFilePickerConfig() != null) {
            if (ActivityCompat.checkSelfPermission((Context)((Context)this$0), (String)DocumentFilePickerActivity.Companion.getPermission()) == 0) {
                this$0.launchFilePicker();
            } else {
                ExtentionsKt.setCanceledResult((Activity)this$0, this$0.getString(R.string.err_permission_result));
            }
        } else {
            Object[] objectArray = new Object[]{new PropertyReference0Impl((Object)this$0){

                @Nullable
                public Object get() {
                    return DocumentFilePickerActivity.access$getMDocumentFilePickerConfig((DocumentFilePickerActivity)((Object)this.receiver));
                }
            }.getClass().getName()};
            ExtentionsKt.setCanceledResult((Activity)this$0, this$0.getString(R.string.err_config_null, objectArray));
        }
    }

    public static final /* synthetic */ DocumentFilePickerConfig access$getMDocumentFilePickerConfig(DocumentFilePickerActivity $this) {
        return $this.getMDocumentFilePickerConfig();
    }

    public static final /* synthetic */ void access$checkPermission(DocumentFilePickerActivity $this) {
        $this.checkPermission();
    }

    public static final /* synthetic */ ActivityResultLauncher access$getSettingCameraResultLauncher$p(DocumentFilePickerActivity $this) {
        return $this.settingCameraResultLauncher;
    }

    public static final /* synthetic */ void access$launchFilePicker(DocumentFilePickerActivity $this) {
        $this.launchFilePicker();
    }

    public static final /* synthetic */ void access$showAskDialog(DocumentFilePickerActivity $this) {
        $this.showAskDialog();
    }

    public static final /* synthetic */ void access$showGotoSettingDialog(DocumentFilePickerActivity $this) {
        $this.showGotoSettingDialog();
    }

    public static final /* synthetic */ ArrayList access$getClipDataUris(DocumentFilePickerActivity $this, Intent $receiver) {
        return $this.getClipDataUris($receiver);
    }

    public static final /* synthetic */ ArrayList access$getFilePathList(DocumentFilePickerActivity $this, List $receiver, Context context) {
        return $this.getFilePathList($receiver, context);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/nareshchocha/filepickerlibrary/ui/activitys/DocumentFilePickerActivity$Companion;", "", "()V", "getInstance", "Landroid/content/Intent;", "mContext", "Landroid/content/Context;", "mDocumentFilePickerConfig", "Lcom/nareshchocha/filepickerlibrary/models/DocumentFilePickerConfig;", "getPermission", "", "filepickerlibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String getPermission() {
            return Build.VERSION.SDK_INT >= 33 ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.READ_EXTERNAL_STORAGE";
        }

        @Keep
        @NotNull
        public final Intent getInstance(@NotNull Context mContext, @Nullable DocumentFilePickerConfig mDocumentFilePickerConfig2) {
            Intent filePickerIntent;
            block0: {
                Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
                filePickerIntent = new Intent(mContext, DocumentFilePickerActivity.class);
                DocumentFilePickerConfig documentFilePickerConfig = mDocumentFilePickerConfig2;
                if (documentFilePickerConfig == null) break block0;
                DocumentFilePickerConfig it = documentFilePickerConfig;
                boolean bl = false;
                filePickerIntent.putExtra("PICK_DOCUMENT", (Parcelable)it);
            }
            return filePickerIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

