/*
 * Decompiled with CFR 0.152.
 */
package com.nareshchocha.filepickerlibrary.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import coil.Coil;
import coil.ImageLoader;
import coil.request.ImageRequest;
import com.nareshchocha.filepickerlibrary.R;
import com.nareshchocha.filepickerlibrary.models.BaseConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018BU\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00126\u0010\b\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R>\u0010\b\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/nareshchocha/filepickerlibrary/ui/adapter/PopUpAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/nareshchocha/filepickerlibrary/ui/adapter/PopUpAdapter$ItemViewHolder;", "layoutID", "", "items", "", "Lcom/nareshchocha/filepickerlibrary/models/BaseConfig;", "itemClicked", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "item", "position", "", "(ILjava/util/List;Lkotlin/jvm/functions/Function2;)V", "bind", "holder", "getItemCount", "onBindViewHolder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "ItemViewHolder", "filepickerlibrary_release"})
@SourceDebugExtension(value={"SMAP\nPopUpAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PopUpAdapter.kt\ncom/nareshchocha/filepickerlibrary/ui/adapter/PopUpAdapter\n+ 2 Extensions.kt\ncoil/-SingletonExtensions\n+ 3 Extensions.kt\ncoil/-SingletonExtensions$load$1\n*L\n1#1,50:1\n54#2,3:51\n24#2:54\n57#2,6:55\n63#2,2:62\n57#3:61\n*S KotlinDebug\n*F\n+ 1 PopUpAdapter.kt\ncom/nareshchocha/filepickerlibrary/ui/adapter/PopUpAdapter\n*L\n39#1:51,3\n39#1:54\n39#1:55,6\n39#1:62,2\n39#1:61\n*E\n"})
public final class PopUpAdapter
extends RecyclerView.Adapter<ItemViewHolder> {
    private final int layoutID;
    @NotNull
    private List<? extends BaseConfig> items;
    @NotNull
    private final Function2<BaseConfig, Integer, Unit> itemClicked;

    public PopUpAdapter(@LayoutRes int layoutID, @NotNull List<? extends BaseConfig> items, @NotNull Function2<? super BaseConfig, ? super Integer, Unit> itemClicked) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(itemClicked, (String)"itemClicked");
        this.layoutID = layoutID;
        this.items = items;
        this.itemClicked = itemClicked;
    }

    @NotNull
    public ItemViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        ItemViewHolder itemViewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.layoutID, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"from(parent.context).inf\u2026     false,\n            )");
        ItemViewHolder it = itemViewHolder = new ItemViewHolder(view);
        boolean bl = false;
        it.getBinding().setOnClickListener(arg_0 -> PopUpAdapter.onCreateViewHolder$lambda$1$lambda$0(this, it, arg_0));
        return itemViewHolder;
    }

    public void onBindViewHolder(@NotNull ItemViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        this.bind(holder, position);
    }

    /*
     * WARNING - void declaration
     */
    private final void bind(ItemViewHolder holder, int position) {
        BaseConfig item = this.items.get(position);
        ImageView imageView = holder.getMImageView();
        if (imageView != null) {
            ImageRequest.Builder builder;
            void $this$load_u24default$iv;
            ImageView imageView2 = imageView;
            Integer data$iv = item.getPopUpIcon();
            Context $this$imageLoader$iv$iv = $this$load_u24default$iv.getContext();
            boolean $i$f$getImageLoader = false;
            ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
            boolean $i$f$load = false;
            ImageRequest.Builder builder2 = builder = new ImageRequest.Builder($this$load_u24default$iv.getContext()).data((Object)data$iv).target((ImageView)$this$load_u24default$iv);
            boolean bl = false;
            ImageRequest.Builder $this$null = builder2;
            ImageRequest request$iv = builder.build();
            imageLoader$iv.enqueue(request$iv);
        }
        TextView textView = holder.getMTextView();
        if (textView != null) {
            textView.setText((CharSequence)item.getPopUpText());
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    private static final void onCreateViewHolder$lambda$1$lambda$0(PopUpAdapter this$0, ItemViewHolder $it, View view) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$it), (String)"$it");
        this$0.itemClicked.invoke((Object)this$0.items.get($it.getAdapterPosition()), (Object)$it.getAdapterPosition());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/nareshchocha/filepickerlibrary/ui/adapter/PopUpAdapter$ItemViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Landroid/view/View;", "(Landroid/view/View;)V", "getBinding", "()Landroid/view/View;", "mImageView", "Landroid/widget/ImageView;", "getMImageView", "()Landroid/widget/ImageView;", "mTextView", "Landroid/widget/TextView;", "getMTextView", "()Landroid/widget/TextView;", "filepickerlibrary_release"})
    public static final class ItemViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final View binding;
        @Nullable
        private final ImageView mImageView;
        @Nullable
        private final TextView mTextView;

        public ItemViewHolder(@NotNull View binding2) {
            Intrinsics.checkNotNullParameter((Object)binding2, (String)"binding");
            super(binding2);
            this.binding = binding2;
            this.mImageView = (ImageView)this.binding.findViewById(R.id.sivLogo);
            this.mTextView = (TextView)this.binding.findViewById(R.id.mtvText);
        }

        @NotNull
        public final View getBinding() {
            return this.binding;
        }

        @Nullable
        public final ImageView getMImageView() {
            return this.mImageView;
        }

        @Nullable
        public final TextView getMTextView() {
            return this.mTextView;
        }
    }
}

