/*
 * Decompiled with CFR 0.152.
 */
package com.nareshchocha.filepickerlibrary.ui.activitys;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import com.nareshchocha.filepickerlibrary.R;
import com.nareshchocha.filepickerlibrary.models.PickMediaConfig;
import com.nareshchocha.filepickerlibrary.models.PickMediaType;
import com.nareshchocha.filepickerlibrary.permission.PermissionUtils;
import com.nareshchocha.filepickerlibrary.picker.PickerUtils;
import com.nareshchocha.filepickerlibrary.utilities.FileUtils;
import com.nareshchocha.filepickerlibrary.utilities.extentions.ExtentionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u001c\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a*\u00020\rH\u0002J*\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0018j\b\u0012\u0004\u0012\u00020\u0005`\u001a*\b\u0012\u0004\u0012\u00020\u00190\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\r0\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/nareshchocha/filepickerlibrary/ui/activitys/MediaFilePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "checkPermission", "Landroidx/activity/result/ActivityResultLauncher;", "", "mPickMediaConfig", "Lcom/nareshchocha/filepickerlibrary/models/PickMediaConfig;", "getMPickMediaConfig", "()Lcom/nareshchocha/filepickerlibrary/models/PickMediaConfig;", "mPickMediaConfig$delegate", "Lkotlin/Lazy;", "selectFile", "Landroid/content/Intent;", "settingCameraResultLauncher", "kotlin.jvm.PlatformType", "", "launchFilePicker", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "showAskDialog", "showGotoSettingDialog", "getClipDataUris", "Ljava/util/ArrayList;", "Landroid/net/Uri;", "Lkotlin/collections/ArrayList;", "getFilePathList", "", "context", "Landroid/content/Context;", "Companion", "filepickerlibrary_release"})
@SourceDebugExtension(value={"SMAP\nMediaFilePickerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaFilePickerActivity.kt\ncom/nareshchocha/filepickerlibrary/ui/activitys/MediaFilePickerActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1855#2,2:239\n*S KotlinDebug\n*F\n+ 1 MediaFilePickerActivity.kt\ncom/nareshchocha/filepickerlibrary/ui/activitys/MediaFilePickerActivity\n*L\n101#1:239,2\n*E\n"})
public final class MediaFilePickerActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy mPickMediaConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PickMediaConfig>(this){
        final /* synthetic */ MediaFilePickerActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @Nullable
        public final PickMediaConfig invoke() {
            return Build.VERSION.SDK_INT >= 33 ? (PickMediaConfig)this.this$0.getIntent().getParcelableExtra("PICK_MEDIA", PickMediaConfig.class) : (PickMediaConfig)this.this$0.getIntent().getParcelableExtra("PICK_MEDIA");
        }
    }));
    @NotNull
    private final ActivityResultLauncher<String> checkPermission = PermissionUtils.INSTANCE.checkPermission(this, (ActivityResultContract)new ActivityResultContracts.RequestPermission(), (Function1)new Function1<Boolean, Unit>(this){
        final /* synthetic */ MediaFilePickerActivity this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(boolean it) {
            if (it) {
                MediaFilePickerActivity.access$launchFilePicker(this.this$0);
            } else {
                Activity activity = (Activity)this.this$0;
                PickMediaConfig pickMediaConfig = MediaFilePickerActivity.access$getMPickMediaConfig(this.this$0);
                Intrinsics.checkNotNull((Object)pickMediaConfig);
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)com.nareshchocha.filepickerlibrary.ui.activitys.MediaFilePickerActivity$Companion.access$getPermission(MediaFilePickerActivity.Companion, pickMediaConfig))) {
                    MediaFilePickerActivity.access$showAskDialog(this.this$0);
                } else {
                    MediaFilePickerActivity.access$showGotoSettingDialog(this.this$0);
                }
            }
        }
    });
    @NotNull
    private final ActivityResultLauncher<Intent> selectFile = PickerUtils.INSTANCE.selectFile(this, (ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), (Function1)new Function1<ActivityResult, Unit>(this){
        final /* synthetic */ MediaFilePickerActivity this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void invoke(@NotNull ActivityResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (result.getResultCode() == -1 && result.getData() != null) {
                String string2;
                PickMediaConfig pickMediaConfig = MediaFilePickerActivity.access$getMPickMediaConfig(this.this$0);
                if (pickMediaConfig != null ? Intrinsics.areEqual((Object)pickMediaConfig.getAllowMultiple(), (Object)true) : false) {
                    Intent intent = result.getData();
                    if ((intent != null ? intent.getClipData() : null) != null) {
                        Intent intent2 = result.getData();
                        ArrayList uris = intent2 != null ? MediaFilePickerActivity.access$getClipDataUris(this.this$0, intent2) : null;
                        Timber.Forest.tag("FILE_RESULT ::").v("File Uri ::: " + uris, new Object[0]);
                        ArrayList filePaths = uris != null ? MediaFilePickerActivity.access$getFilePathList(this.this$0, uris, (Context)this.this$0) : null;
                        Timber.Forest.tag("FILE_RESULT ::").v("filePath ::: " + filePaths, new Object[0]);
                        ExtentionsKt.setSuccessResult$default((Activity)this.this$0, uris, filePaths, false, 4, null);
                        return;
                    }
                }
                Intent intent = result.getData();
                if ((intent != null ? intent.getData() : null) == null) return;
                Intent intent3 = result.getData();
                Uri data = intent3 != null ? intent3.getData() : null;
                Uri uri = data;
                Timber.Forest.tag("FILE_RESULT ::").v("File Uri ::: " + (uri != null ? uri.toString() : null), new Object[0]);
                Uri uri2 = data;
                if (uri2 != null) {
                    Uri uri3 = uri2;
                    MediaFilePickerActivity mediaFilePickerActivity = this.this$0;
                    Uri it = uri3;
                    boolean bl = false;
                    string2 = FileUtils.INSTANCE.getRealPath((Context)mediaFilePickerActivity, it);
                } else {
                    string2 = null;
                }
                String filePath = string2;
                Timber.Forest.tag("FILE_RESULT ::").v("filePath ::: " + filePath, new Object[0]);
                ExtentionsKt.setSuccessResult$default((Activity)this.this$0, data, filePath, false, 4, null);
                return;
            }
            Timber.Forest.tag("FILE_PICKER_ERROR ::").v(this.this$0.getString(R.string.err_media_pick_error), new Object[0]);
            ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_media_pick_error));
        }
    });
    @NotNull
    private final ActivityResultLauncher<Intent> settingCameraResultLauncher;

    public MediaFilePickerActivity() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> MediaFilePickerActivity.settingCameraResultLauncher$lambda$3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.settingCameraResultLauncher = activityResultLauncher;
    }

    private final PickMediaConfig getMPickMediaConfig() {
        Lazy lazy = this.mPickMediaConfig$delegate;
        return (PickMediaConfig)lazy.getValue();
    }

    private final ArrayList<Uri> getClipDataUris(Intent $this$getClipDataUris) {
        LinkedHashSet<Uri> resultSet = new LinkedHashSet<Uri>();
        Uri uri = $this$getClipDataUris.getData();
        if (uri != null) {
            Uri data = uri;
            boolean bl = false;
            resultSet.add(data);
        }
        ClipData clipData = $this$getClipDataUris.getClipData();
        if (clipData == null && resultSet.isEmpty()) {
            return new ArrayList<Uri>();
        }
        if (clipData != null) {
            int n = clipData.getItemCount();
            for (int i = 0; i < n; ++i) {
                Uri uri2 = clipData.getItemAt(i).getUri();
                if (uri2 == null) continue;
                resultSet.add(uri2);
            }
        }
        return new ArrayList<Uri>((Collection)resultSet);
    }

    private final ArrayList<String> getFilePathList(List<? extends Uri> $this$getFilePathList, Context context) {
        ArrayList<String> filePathList = new ArrayList<String>();
        Iterable $this$forEach$iv = $this$getFilePathList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2;
            Uri uri = (Uri)element$iv;
            boolean bl = false;
            if (FileUtils.INSTANCE.getRealPath(context, uri) == null) continue;
            String filePath = string2;
            boolean bl2 = false;
            filePathList.add(filePath);
        }
        return filePathList;
    }

    private final void launchFilePicker() {
        if (this.getMPickMediaConfig() != null) {
            Context context = (Context)this;
            PickMediaConfig pickMediaConfig = this.getMPickMediaConfig();
            Intrinsics.checkNotNull((Object)pickMediaConfig);
            this.selectFile.launch((Object)ExtentionsKt.getMediaIntent(context, pickMediaConfig));
        } else {
            Object[] objectArray = new Object[]{new PropertyReference0Impl((Object)this){

                @Nullable
                public Object get() {
                    return MediaFilePickerActivity.access$getMPickMediaConfig((MediaFilePickerActivity)((Object)this.receiver));
                }
            }.getClass().getName()};
            ExtentionsKt.setCanceledResult((Activity)this, this.getString(R.string.err_config_null, objectArray));
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
        super.onCreate(savedInstanceState);
        this.setTitle("");
        if (Build.VERSION.SDK_INT >= 23) {
            this.checkPermission();
        } else {
            this.launchFilePicker();
        }
    }

    private final void showAskDialog() {
        Object object;
        Context context = (Context)this;
        Object object2 = this.getMPickMediaConfig();
        if (object2 == null || (object2 = ((PickMediaConfig)object2).getAskPermissionTitle()) == null) {
            String string2 = this.getString(R.string.err_permission_denied);
            object2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.err_permission_denied)");
        }
        if ((object = this.getMPickMediaConfig()) == null || (object = ((PickMediaConfig)object).getAskPermissionMessage()) == null) {
            Object[] objectArray = new Object[1];
            PickMediaConfig pickMediaConfig = this.getMPickMediaConfig();
            Intrinsics.checkNotNull((Object)pickMediaConfig);
            String[] stringArray = new String[]{"."};
            String string3 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)MediaFilePickerActivity.Companion.getPermission(pickMediaConfig), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (string3 == null) {
                string3 = "";
            }
            objectArray[0] = string3;
            String string4 = this.getString(R.string.err_write_storage_permission, objectArray);
            object = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(\n             \u2026ll() ?: \"\",\n            )");
        }
        ExtentionsKt.showMyDialog$default(context, (String)object2, (String)object, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ MediaFilePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_permission_result));
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ MediaFilePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MediaFilePickerActivity.access$checkPermission(this.this$0);
            }
        }, 4, null);
    }

    private final void showGotoSettingDialog() {
        if (this.getMPickMediaConfig() != null) {
            Object object;
            Context context = (Context)this;
            Object object2 = this.getMPickMediaConfig();
            if (object2 == null || (object2 = ((PickMediaConfig)object2).getSettingPermissionTitle()) == null) {
                String string2 = this.getString(R.string.err_permission_denied);
                object2 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.err_permission_denied)");
            }
            if ((object = this.getMPickMediaConfig()) == null || (object = ((PickMediaConfig)object).getSettingPermissionMessage()) == null) {
                Object[] objectArray = new Object[1];
                PickMediaConfig pickMediaConfig = this.getMPickMediaConfig();
                Intrinsics.checkNotNull((Object)pickMediaConfig);
                String[] stringArray = new String[]{"."};
                String string3 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)MediaFilePickerActivity.Companion.getPermission(pickMediaConfig), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                if (string3 == null) {
                    string3 = "";
                }
                objectArray[0] = string3;
                String string4 = this.getString(R.string.err_write_storage_setting, objectArray);
                object = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(\n             \u2026 ?: \"\",\n                )");
            }
            ExtentionsKt.showMyDialog(context, (String)object2, (String)object, this.getString(R.string.str_go_to_setting), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MediaFilePickerActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_permission_result));
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MediaFilePickerActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MediaFilePickerActivity.access$getSettingCameraResultLauncher$p(this.this$0).launch((Object)ExtentionsKt.getSettingIntent((Context)this.this$0));
                }
            }));
        } else {
            Object[] objectArray = new Object[]{new PropertyReference0Impl((Object)this){

                @Nullable
                public Object get() {
                    return MediaFilePickerActivity.access$getMPickMediaConfig((MediaFilePickerActivity)((Object)this.receiver));
                }
            }.getClass().getName()};
            ExtentionsKt.setCanceledResult((Activity)this, this.getString(R.string.err_config_null, objectArray));
        }
    }

    private final void checkPermission() {
        if (this.getMPickMediaConfig() != null) {
            PickMediaConfig pickMediaConfig = this.getMPickMediaConfig();
            Intrinsics.checkNotNull((Object)pickMediaConfig);
            this.checkPermission.launch((Object)MediaFilePickerActivity.Companion.getPermission(pickMediaConfig));
        } else {
            Object[] objectArray = new Object[]{new PropertyReference0Impl((Object)this){

                @Nullable
                public Object get() {
                    return MediaFilePickerActivity.access$getMPickMediaConfig((MediaFilePickerActivity)((Object)this.receiver));
                }
            }.getClass().getName()};
            ExtentionsKt.setCanceledResult((Activity)this, this.getString(R.string.err_config_null, objectArray));
        }
    }

    private static final void settingCameraResultLauncher$lambda$3(MediaFilePickerActivity this$0, ActivityResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.getMPickMediaConfig() != null) {
            Context context = (Context)this$0;
            PickMediaConfig pickMediaConfig = this$0.getMPickMediaConfig();
            Intrinsics.checkNotNull((Object)pickMediaConfig);
            if (ActivityCompat.checkSelfPermission((Context)context, (String)MediaFilePickerActivity.Companion.getPermission(pickMediaConfig)) == 0) {
                this$0.launchFilePicker();
            } else {
                ExtentionsKt.setCanceledResult((Activity)this$0, this$0.getString(R.string.err_permission_result));
            }
        } else {
            Object[] objectArray = new Object[]{new PropertyReference0Impl((Object)this$0){

                @Nullable
                public Object get() {
                    return MediaFilePickerActivity.access$getMPickMediaConfig((MediaFilePickerActivity)((Object)this.receiver));
                }
            }.getClass().getName()};
            ExtentionsKt.setCanceledResult((Activity)this$0, this$0.getString(R.string.err_config_null, objectArray));
        }
    }

    public static final /* synthetic */ PickMediaConfig access$getMPickMediaConfig(MediaFilePickerActivity $this) {
        return $this.getMPickMediaConfig();
    }

    public static final /* synthetic */ void access$checkPermission(MediaFilePickerActivity $this) {
        $this.checkPermission();
    }

    public static final /* synthetic */ ActivityResultLauncher access$getSettingCameraResultLauncher$p(MediaFilePickerActivity $this) {
        return $this.settingCameraResultLauncher;
    }

    public static final /* synthetic */ void access$launchFilePicker(MediaFilePickerActivity $this) {
        $this.launchFilePicker();
    }

    public static final /* synthetic */ void access$showAskDialog(MediaFilePickerActivity $this) {
        $this.showAskDialog();
    }

    public static final /* synthetic */ void access$showGotoSettingDialog(MediaFilePickerActivity $this) {
        $this.showGotoSettingDialog();
    }

    public static final /* synthetic */ ArrayList access$getClipDataUris(MediaFilePickerActivity $this, Intent $receiver) {
        return $this.getClipDataUris($receiver);
    }

    public static final /* synthetic */ ArrayList access$getFilePathList(MediaFilePickerActivity $this, List $receiver, Context context) {
        return $this.getFilePathList($receiver, context);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/nareshchocha/filepickerlibrary/ui/activitys/MediaFilePickerActivity$Companion;", "", "()V", "getInstance", "Landroid/content/Intent;", "mContext", "Landroid/content/Context;", "mPickMediaConfig", "Lcom/nareshchocha/filepickerlibrary/models/PickMediaConfig;", "getPermission", "", "filepickerlibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String getPermission(PickMediaConfig mPickMediaConfig2) {
            return Build.VERSION.SDK_INT >= 33 ? (mPickMediaConfig2.getMPickMediaType() == PickMediaType.ImageOnly ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.READ_MEDIA_VIDEO") : "android.permission.READ_EXTERNAL_STORAGE";
        }

        @NotNull
        public final Intent getInstance(@NotNull Context mContext, @Nullable PickMediaConfig mPickMediaConfig2) {
            Intent filePickerIntent;
            block0: {
                Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
                filePickerIntent = new Intent(mContext, MediaFilePickerActivity.class);
                PickMediaConfig pickMediaConfig = mPickMediaConfig2;
                if (pickMediaConfig == null) break block0;
                PickMediaConfig it = pickMediaConfig;
                boolean bl = false;
                filePickerIntent.putExtra("PICK_MEDIA", (Parcelable)it);
            }
            return filePickerIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

