/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.core.util.FileUtil;
import com.core.util.ToastUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0007J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0007J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/core/util/PhotoUtil;", "", "()V", "CROP_IMAGE", "", "GET_IMAGE_BY_CAMERA", "GET_IMAGE_FROM_PHONE", "cropImageUri", "Landroid/net/Uri;", "imageUriFromCamera", "createImagePathUri", "context", "Landroid/content/Context;", "cropImage", "", "activity", "Landroid/app/Activity;", "srcUri", "fragment", "Landroidx/fragment/app/Fragment;", "getImageAbsolutePath", "", "imageUri", "getRealFilePath", "uri", "openCameraImage", "openLocalImage", "XUtils_release"})
public final class PhotoUtil {
    public static final int GET_IMAGE_BY_CAMERA = 5001;
    public static final int GET_IMAGE_FROM_PHONE = 5002;
    public static final int CROP_IMAGE = 5003;
    @JvmField
    @Nullable
    public static Uri imageUriFromCamera;
    @JvmField
    @Nullable
    public static Uri cropImageUri;
    @NotNull
    public static final PhotoUtil INSTANCE;

    @JvmStatic
    public static final void openCameraImage(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        imageUriFromCamera = PhotoUtil.createImagePathUri((Context)activity);
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)imageUriFromCamera);
        activity.startActivityForResult(intent, 5001);
    }

    @JvmStatic
    public static final void openCameraImage(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        imageUriFromCamera = PhotoUtil.createImagePathUri(fragment.getContext());
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)imageUriFromCamera);
        fragment.startActivityForResult(intent, 5001);
    }

    @JvmStatic
    public static final void openLocalImage(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        activity.startActivityForResult(intent, 5002);
    }

    @JvmStatic
    public static final void openLocalImage(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        fragment.startActivityForResult(intent, 5002);
    }

    @JvmStatic
    public static final void cropImage(@NotNull Activity activity, @Nullable Uri srcUri) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        cropImageUri = PhotoUtil.createImagePathUri((Context)activity);
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(srcUri, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", 300);
        intent.putExtra("outputY", 300);
        intent.putExtra("output", (Parcelable)cropImageUri);
        intent.putExtra("return-data", true);
        activity.startActivityForResult(intent, 5003);
    }

    @JvmStatic
    public static final void cropImage(@NotNull Fragment fragment, @Nullable Uri srcUri) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        cropImageUri = PhotoUtil.createImagePathUri(fragment.getContext());
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(srcUri, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", 300);
        intent.putExtra("outputY", 300);
        intent.putExtra("output", (Parcelable)cropImageUri);
        intent.putExtra("return-data", true);
        fragment.startActivityForResult(intent, 5003);
    }

    @JvmStatic
    @Nullable
    public static final Uri createImagePathUri(@Nullable Context context) {
        Uri[] imageFilePath = new Uri[]{null};
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        if (ContextCompat.checkSelfPermission((Context)context2, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
            imageFilePath[0] = Uri.parse((String)"");
            ToastUtil.error("\u8bf7\u5148\u83b7\u53d6\u5199\u5165SDCard\u6743\u9650");
        } else {
            String status = Environment.getExternalStorageState();
            SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA);
            long time = System.currentTimeMillis();
            String imageName = timeFormatter.format(new Date(time));
            ContentValues values = new ContentValues(3);
            values.put("_display_name", imageName);
            values.put("datetaken", Long.valueOf(time));
            values.put("mime_type", "image/jpeg");
            imageFilePath[0] = Intrinsics.areEqual((Object)status, (Object)"mounted") ? context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values) : context.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
        }
        Log.i((String)"", (String)("\u751f\u6210\u7684\u7167\u7247\u8f93\u51fa\u8def\u5f84\uff1a" + String.valueOf(imageFilePath[0])));
        return imageFilePath[0];
    }

    @JvmStatic
    @Nullable
    public static final String getRealFilePath(@NotNull Context context, @Nullable Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if (Intrinsics.areEqual((Object)"file", (Object)scheme)) {
            data = uri.getPath();
        } else if (Intrinsics.areEqual((Object)"content", (Object)scheme)) {
            String[] projection = new String[]{"_data"};
            Cursor cursor = context.getContentResolver().query(uri, projection, null, null, null);
            if (cursor != null) {
                int index;
                if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                    data = cursor.getString(index);
                }
                cursor.close();
            }
        }
        return data;
    }

    @JvmStatic
    @TargetApi(value=19)
    @Nullable
    public static final String getImageAbsolutePath(@Nullable Context context, @Nullable Uri imageUri) {
        if (context == null || imageUri == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)imageUri)) {
            if (FileUtil.isExternalStorageDocument(imageUri)) {
                String docId;
                String string = docId = DocumentsContract.getDocumentId((Uri)imageUri);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                    return Environment.getExternalStorageDirectory().toString() + "/" + split[1];
                }
            } else {
                if (FileUtil.isDownloadsDocument(imageUri)) {
                    String id = DocumentsContract.getDocumentId((Uri)imageUri);
                    Uri uri = Uri.parse((String)"content://downloads/public_downloads");
                    Long l = Long.valueOf(id);
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(id)");
                    Uri uri2 = ContentUris.withAppendedId((Uri)uri, (long)l);
                    Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"ContentUris.withAppended\u2026va.lang.Long.valueOf(id))");
                    Uri contentUri = uri2;
                    return FileUtil.getDataColumn(context, contentUri, null, null);
                }
                if (FileUtil.isMediaDocument(imageUri)) {
                    String docId;
                    String string = docId = DocumentsContract.getDocumentId((Uri)imageUri);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] split = stringArray;
                    String type = split[0];
                    Uri contentUri = null;
                    if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtil.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if (StringsKt.equals((String)"content", (String)imageUri.getScheme(), (boolean)true)) {
                return FileUtil.isGooglePhotosUri(imageUri) ? imageUri.getLastPathSegment() : FileUtil.getDataColumn(context, imageUri, null, null);
            }
            if (StringsKt.equals((String)"file", (String)imageUri.getScheme(), (boolean)true)) {
                return imageUri.getPath();
            }
        }
        return null;
    }

    private PhotoUtil() {
    }

    static {
        PhotoUtil photoUtil;
        INSTANCE = photoUtil = new PhotoUtil();
    }
}

