/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.app.Activity;
import android.os.Build;
import android.view.DisplayCutout;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import com.core.util.OSUtil;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/core/util/NotchUtil;", "", "()V", "KEY_EMUI", "", "KEY_MIUI", "KEY_OPPO", "KEY_VIVO", "hasNotchEMUI", "", "activity", "Landroid/app/Activity;", "hasNotchInScreen", "hasNotchMIUI", "hasNotchOPPO", "hasNotchVIVO", "mask", "", "XUtils_release"})
public final class NotchUtil {
    private static final String KEY_OPPO = "com.oppo.feature.screen.heteromorphism";
    private static final String KEY_VIVO = "android.util.FtFeature";
    private static final String KEY_MIUI = "android.os.SystemProperties";
    private static final String KEY_EMUI = "com.huawei.android.util.HwNotchSizeUtil";
    @NotNull
    public static final NotchUtil INSTANCE;

    public final boolean hasNotchInScreen(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 28) {
            DisplayCutout displayCutout;
            Window window = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
            WindowInsets windowInsets = view.getRootWindowInsets();
            Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"activity.window.decorView.rootWindowInsets");
            DisplayCutout displayCutout2 = displayCutout = windowInsets.getDisplayCutout();
            if (displayCutout2 != null) {
                DisplayCutout displayCutout3 = displayCutout2;
                boolean bl = false;
                boolean bl2 = false;
                DisplayCutout it = displayCutout3;
                boolean bl3 = false;
                return true;
            }
        } else {
            if (OSUtil.INSTANCE.isEmui()) {
                return this.hasNotchEMUI(activity);
            }
            if (OSUtil.INSTANCE.isMiui()) {
                return this.hasNotchMIUI();
            }
            if (OSUtil.INSTANCE.isOppo()) {
                return this.hasNotchOPPO(activity);
            }
            if (OSUtil.INSTANCE.isVivo()) {
                return this.hasNotchVIVO(32);
            }
        }
        return false;
    }

    private final boolean hasNotchVIVO(int mask) {
        try {
            Class<?> clazz = Class.forName(KEY_VIVO);
            Method method = clazz.getMethod("isFeatureSupport", IntCompanionObject.INSTANCE.getClass());
            Object result = method.invoke(clazz, mask);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private final boolean hasNotchOPPO(Activity activity) {
        return activity.getPackageManager().hasSystemFeature(KEY_OPPO);
    }

    private final boolean hasNotchMIUI() {
        try {
            Class<?> clazz = Class.forName(KEY_MIUI);
            Method method = clazz.getMethod("getInt", StringCompanionObject.INSTANCE.getClass(), IntCompanionObject.INSTANCE.getClass());
            Object result = method.invoke(clazz, "ro.miui.notch", 0);
            if (result instanceof Integer) {
                return Intrinsics.areEqual((Object)result, (Object)1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private final boolean hasNotchEMUI(Activity activity) {
        try {
            ClassLoader classLoader = activity.getClassLoader();
            Class<?> clazz = classLoader.loadClass(KEY_EMUI);
            Method method = clazz.getMethod("hasNotchInScreen", new Class[0]);
            Object result = method.invoke(clazz, new Object[0]);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private NotchUtil() {
    }

    static {
        NotchUtil notchUtil;
        INSTANCE = notchUtil = new NotchUtil();
    }
}

