/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.content.Context;
import android.content.res.Resources;
import com.core.XUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Lcom/core/util/DensityUtil;", "", "()V", "dp2px", "", "context", "Landroid/content/Context;", "dpValue", "", "getScreenHeight", "getScreenWidth", "px2dp", "pxValue", "px2sp", "sp2px", "spValue", "XUtils_release"})
public final class DensityUtil {
    @NotNull
    public static final DensityUtil INSTANCE;

    public final int dp2px(float dpValue) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        return (int)(dpValue * resources.getDisplayMetrics().density + 0.5f);
    }

    public final int dp2px(@NotNull Context context, float dpValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return (int)(dpValue * resources.getDisplayMetrics().density + 0.5f);
    }

    public final int px2dp(float pxValue) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        return (int)(pxValue / resources.getDisplayMetrics().density + 0.5f);
    }

    public final int px2dp(@NotNull Context context, float pxValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return (int)(pxValue / resources.getDisplayMetrics().density + 0.5f);
    }

    public final int sp2px(float spValue) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public final int sp2px(@NotNull Context context, float spValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public final int px2sp(float pxValue) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public final int px2sp(@NotNull Context context, float pxValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public final int getScreenWidth() {
        Resources resources = XUtil.INSTANCE.getApp().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"XUtil.getApp().resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    public final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    public final int getScreenHeight() {
        Resources resources = XUtil.INSTANCE.getApp().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"XUtil.getApp().resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    private DensityUtil() {
    }

    static {
        DensityUtil densityUtil;
        INSTANCE = densityUtil = new DensityUtil();
    }
}

