/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glview.texture.GLMultiTexConsumerView;
import com.chillingvan.canvasgl.glview.texture.GLTexture;
import com.chillingvan.canvasgl.util.Loggers;
import java.util.ArrayList;
import java.util.List;

public abstract class GLMultiTexProducerView
extends GLMultiTexConsumerView {
    private static final String TAG = "GLMultiTexProducerView";
    private int producedTextureTarget = 36197;
    private List<GLTexture> producedTextureList = new ArrayList<GLTexture>();
    private SurfaceTextureCreatedListener surfaceTextureCreatedListener;

    public GLMultiTexProducerView(Context context) {
        super(context);
    }

    public GLMultiTexProducerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GLMultiTexProducerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected final void onGLDraw(ICanvasGL canvas, List<GLTexture> consumedTextures) {
        this.onGLDraw(canvas, this.producedTextureList, consumedTextures);
    }

    @Override
    protected int getRenderMode() {
        return 0;
    }

    protected int getInitialTexCount() {
        return 1;
    }

    public void setProducedTextureTarget(int producedTextureTarget) {
        this.producedTextureTarget = producedTextureTarget;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureAvailable(surface, width, height);
    }

    public GLTexture addProducedGLTexture(int width, int height, boolean opaque, int target) {
        GLTexture glTexture = GLTexture.createRaw(width, height, opaque, target, this.mCanvas);
        this.producedTextureList.add(glTexture);
        return glTexture;
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        super.onSurfaceChanged(width, height);
        Loggers.d(TAG, "onSurfaceChanged: " + width + ", " + height);
        if (this.producedTextureList.isEmpty()) {
            for (int i = 0; i < this.getInitialTexCount(); ++i) {
                this.producedTextureList.add(GLTexture.createRaw(width, height, false, this.producedTextureTarget, this.mCanvas));
            }
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (!GLMultiTexProducerView.this.producedTextureList.isEmpty() && GLMultiTexProducerView.this.surfaceTextureCreatedListener != null) {
                        GLMultiTexProducerView.this.surfaceTextureCreatedListener.onCreated(GLMultiTexProducerView.this.producedTextureList);
                    }
                }
            });
        } else {
            for (GLTexture glTexture : this.producedTextureList) {
                glTexture.getRawTexture().setSize(width, height);
            }
        }
    }

    @Override
    public void onDrawFrame() {
        if (this.producedTextureTarget != 3553) {
            for (GLTexture glTexture : this.producedTextureList) {
                glTexture.getSurfaceTexture().updateTexImage();
            }
        }
        super.onDrawFrame();
    }

    @Override
    public void onPause() {
        super.onPause();
        Loggers.d(TAG, "onPause");
        this.recycleProduceTexture();
        if (this.mGLThread == null) {
            Log.w((String)TAG, (String)"!!!!!! You may not call setShareEglContext !!!");
        }
    }

    @Override
    protected void surfaceDestroyed() {
        super.surfaceDestroyed();
        this.recycleProduceTexture();
    }

    private void recycleProduceTexture() {
        for (GLTexture glTexture : this.producedTextureList) {
            if (!glTexture.getRawTexture().isRecycled()) {
                glTexture.getRawTexture().recycle();
            }
            if (Build.VERSION.SDK_INT >= 26) {
                if (glTexture.getSurfaceTexture().isReleased()) continue;
                glTexture.getSurfaceTexture().release();
                continue;
            }
            glTexture.getSurfaceTexture().release();
        }
        this.producedTextureList.clear();
    }

    public void setSurfaceTextureCreatedListener(SurfaceTextureCreatedListener surfaceTextureCreatedListener) {
        this.surfaceTextureCreatedListener = surfaceTextureCreatedListener;
    }

    protected abstract void onGLDraw(ICanvasGL var1, List<GLTexture> var2, List<GLTexture> var3);

    public static interface SurfaceTextureCreatedListener {
        public void onCreated(List<GLTexture> var1);
    }
}

