/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.util;

import android.text.TextUtils;
import java.io.File;
import java.io.FileWriter;

public class FileUtil {
    public static synchronized File createFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        File file = new File(path);
        if (file.isFile()) {
            return file;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && (parentFile.isDirectory() || parentFile.mkdirs())) {
            try {
                if (file.createNewFile()) {
                    return file;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static synchronized boolean delete(File path) {
        File[] files;
        if (null == path) {
            return true;
        }
        if (path.isDirectory() && null != (files = path.listFiles())) {
            for (File file : files) {
                if (FileUtil.delete(file)) continue;
                return false;
            }
        }
        return !path.exists() || path.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String content, String filePath) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(filePath, true);
            fileWriter.write(content);
            fileWriter.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

