/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.os.Handler;
import android.support.annotation.Nullable;
import com.chillingvan.canvasgl.CanvasGL;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glview.GLView;
import com.chillingvan.canvasgl.glview.texture.GLSurfaceTextureProducerView;
import com.chillingvan.canvasgl.glview.texture.GLViewRenderer;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLSurface;

public abstract class OffScreenCanvas
implements GLViewRenderer {
    protected final GLThread mGLThread;
    private int width;
    private int height;
    protected ICanvasGL mCanvas;
    private BasicTexture outsideSharedTexture;
    private SurfaceTexture outsideSharedSurfaceTexture;
    private GLSurfaceTextureProducerView.OnSurfaceTextureSet onSurfaceTextureSet;
    private SurfaceTexture producedSurfaceTexture;
    private RawTexture producedRawTexture;
    private Handler handler;
    private boolean isStart;
    private int producedTextureTarget = 3553;
    private int backgroundColor = 0;

    public OffScreenCanvas() {
        this(0, 0, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER);
    }

    public OffScreenCanvas(int width, int height) {
        this(width, height, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER);
    }

    public OffScreenCanvas(Object surface) {
        this(0, 0, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER, surface);
    }

    public OffScreenCanvas(int width, int height, Object surface) {
        this(width, height, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER, surface);
    }

    public OffScreenCanvas(int width, int height, EglContextWrapper sharedEglContext, Object surface) {
        this.width = width;
        this.height = height;
        this.mGLThread = new GLThread.Builder().setRenderMode(this.getRenderMode()).setSharedEglContext(sharedEglContext).setSurface(surface).setRenderer(this).createGLThread();
        this.handler = new Handler();
    }

    public OffScreenCanvas(int width, int height, EglContextWrapper sharedEglContext) {
        this.width = width;
        this.height = height;
        this.mGLThread = new GLThread.Builder().setRenderMode(this.getRenderMode()).setSharedEglContext(sharedEglContext).setEglWindowSurfaceFactory(new SurfaceFactory()).setRenderer(this).createGLThread();
        this.handler = new Handler();
    }

    public void setProducedTextureTarget(int producedTextureTarget) {
        this.producedTextureTarget = producedTextureTarget;
    }

    public void setOnCreateGLContextListener(GLThread.OnCreateGLContextListener onCreateGLContextListener) {
        this.mGLThread.setOnCreateGLContextListener(onCreateGLContextListener);
    }

    public void setOnSurfaceTextureSet(GLSurfaceTextureProducerView.OnSurfaceTextureSet onSurfaceTextureSet) {
        this.onSurfaceTextureSet = onSurfaceTextureSet;
    }

    public void setSharedTexture(BasicTexture outsideTexture, @Nullable SurfaceTexture outsideSurfaceTexture) {
        this.outsideSharedTexture = outsideTexture;
        this.outsideSharedSurfaceTexture = outsideSurfaceTexture;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.isStart) {
            this.mGLThread.onWindowResize(width, height);
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void start() {
        this.mGLThread.start();
        this.mGLThread.surfaceCreated();
        this.mGLThread.onWindowResize(this.width, this.height);
        this.isStart = true;
    }

    public void onResume() {
        if (this.mGLThread != null) {
            this.mGLThread.onResume();
        }
    }

    public void onPause() {
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
        }
    }

    public void end() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        if (this.producedRawTexture != null) {
            this.producedRawTexture.recycle();
            this.producedRawTexture = null;
        }
        if (this.producedSurfaceTexture != null) {
            this.producedSurfaceTexture.release();
            this.producedSurfaceTexture = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.end();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void onSurfaceCreated() {
        Loggers.d("OffScreenCanvas", "onSurfaceCreated: ");
        this.mCanvas = new CanvasGL();
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        Loggers.d("OffScreenCanvas", "onSurfaceChanged: ");
        this.mCanvas.setSize(width, height);
        if (this.producedRawTexture == null) {
            this.producedRawTexture = new RawTexture(width, height, false, this.producedTextureTarget);
            if (!this.producedRawTexture.isLoaded()) {
                this.producedRawTexture.prepare(this.mCanvas.getGlCanvas());
            }
            this.producedSurfaceTexture = new SurfaceTexture(this.producedRawTexture.getId());
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (OffScreenCanvas.this.onSurfaceTextureSet != null) {
                        OffScreenCanvas.this.onSurfaceTextureSet.onSet(OffScreenCanvas.this.producedSurfaceTexture, OffScreenCanvas.this.producedRawTexture);
                    }
                }
            });
        } else {
            this.producedRawTexture.setSize(width, height);
        }
    }

    @Override
    public void onDrawFrame() {
        this.mCanvas.clearBuffer(this.backgroundColor);
        if (this.producedTextureTarget != 3553) {
            this.producedSurfaceTexture.updateTexImage();
        }
        this.onGLDraw(this.mCanvas, this.producedSurfaceTexture, this.producedRawTexture, this.outsideSharedSurfaceTexture, this.outsideSharedTexture);
    }

    protected int getRenderMode() {
        return 0;
    }

    protected abstract void onGLDraw(ICanvasGL var1, SurfaceTexture var2, RawTexture var3, @Nullable SurfaceTexture var4, @Nullable BasicTexture var5);

    public void queueEvent(Runnable r) {
        if (this.mGLThread == null) {
            return;
        }
        this.mGLThread.queueEvent(r);
    }

    public void requestRender() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    public void requestRenderAndWait() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    public void getDrawingBitmap(final Rect rect, final GLView.GetDrawingCacheCallback getDrawingCacheCallback) {
        final Handler handler = new Handler();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                OffScreenCanvas.this.onDrawFrame();
                OffScreenCanvas.this.onDrawFrame();
                final Bitmap bitmapFromGLSurface = OpenGLUtil.createBitmapFromGLSurface(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, OffScreenCanvas.this.height);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        getDrawingCacheCallback.onFetch(bitmapFromGLSurface);
                    }
                });
            }
        });
        this.requestRender();
    }

    private class SurfaceFactory
    implements GLThread.EGLWindowSurfaceFactory {
        private SurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLConfig config, Object nativeWindow) {
            int[] attribList = new int[]{12375, OffScreenCanvas.this.width, 12374, OffScreenCanvas.this.height, 12344};
            return egl.eglCreatePbufferSurface(display, config, attribList);
        }

        @Override
        public void destroySurface(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }

        @Override
        @TargetApi(value=17)
        public android.opengl.EGLSurface createWindowSurface(EGLDisplay display, android.opengl.EGLConfig config, Object nativeWindow) {
            int[] attribList = new int[]{12375, OffScreenCanvas.this.width, 12374, OffScreenCanvas.this.height, 12344};
            return EGL14.eglCreatePbufferSurface((EGLDisplay)display, (android.opengl.EGLConfig)config, (int[])attribList, (int)0);
        }

        @Override
        @TargetApi(value=17)
        public void destroySurface(EGLDisplay display, android.opengl.EGLSurface surface) {
            EGL14.eglDestroySurface((EGLDisplay)display, (android.opengl.EGLSurface)surface);
        }
    }
}

