/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.graphics.Bitmap;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.NonNull;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.BitmapTexture;
import com.chillingvan.canvasgl.glcanvas.GLES20Canvas;
import com.chillingvan.canvasgl.glcanvas.TextureMatrixTransformer;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import java.util.Arrays;

public abstract class TwoTextureFilter
extends BasicTextureFilter {
    public static final String VARYING_TEXTURE_COORD2 = "vTextureCoord2";
    public static final String UNIFORM_TEXTURE_SAMPLER2 = "uTextureSampler2";
    protected final float[] mTempTextureMatrix = new float[16];
    protected Bitmap secondBitmap;
    private RectF a = new RectF();

    public TwoTextureFilter(@NonNull Bitmap secondBitmap) {
        this.secondBitmap = secondBitmap;
    }

    public void setBitmap(@NonNull Bitmap secondBitmap) {
        this.secondBitmap = secondBitmap;
    }

    @Override
    public String getVertexShader() {
        return " \nattribute vec2 aPosition;\nvarying vec2 vTextureCoord;\nvarying vec2 vTextureCoord2;\nuniform mat4 uMatrix;\nuniform mat4 uTextureMatrix;\nuniform mat4 uTextureMatrix2;\n \nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n    gl_Position = uMatrix * pos;\n    vTextureCoord = (uTextureMatrix * pos).xy;\n    vTextureCoord2 = (uTextureMatrix2 * pos).xy;\n}";
    }

    private void a() {
        Arrays.fill(this.mTempTextureMatrix, 0.0f);
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        BitmapTexture bitmapTexture = canvas.bindBitmapToTexture(33987, this.secondBitmap);
        this.a();
        Matrix.setIdentityM((float[])this.mTempTextureMatrix, (int)0);
        TextureMatrixTransformer.copyTextureCoordinates(bitmapTexture, this.a);
        TextureMatrixTransformer.convertCoordinate(this.a, bitmapTexture);
        TextureMatrixTransformer.setTextureMatrix(this.a, this.mTempTextureMatrix);
        GLES20Canvas.printMatrix("two tex matrix", this.mTempTextureMatrix, 0);
        int n = GLES20.glGetUniformLocation((int)program, (String)"uTextureMatrix2");
        GLES20.glUniformMatrix4fv((int)n, (int)1, (boolean)false, (float[])this.mTempTextureMatrix, (int)0);
        int n2 = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_TEXTURE_SAMPLER2);
        GLES20Canvas.checkError();
        GLES20.glUniform1i((int)n2, (int)3);
        GLES20Canvas.checkError();
    }
}

