/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture.gles;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.EglHelper;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import com.chillingvan.canvasgl.glview.texture.gles.IEglHelper;

@RequiresApi(value=17)
public class EglHelperAPI17
implements IEglHelper {
    private GLThread.EGLConfigChooser a;
    private GLThread.EGLContextFactory b;
    private GLThread.EGLWindowSurfaceFactory c;
    private EGLDisplay d;
    private EGLConfig e;
    private EGLContext f;
    private EGLSurface g;

    public EglHelperAPI17(GLThread.EGLConfigChooser configChooser, GLThread.EGLContextFactory eglContextFactory, GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
        this.a = configChooser;
        this.b = eglContextFactory;
        this.c = eglWindowSurfaceFactory;
    }

    @Override
    public EglContextWrapper start(EglContextWrapper eglContext) {
        Loggers.w("EglHelper", "start() tid=" + Thread.currentThread().getId());
        this.d = EGL14.eglGetDisplay((int)0);
        if (this.d == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] nArray = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.d, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
            this.d = null;
            throw new RuntimeException("eglInitialize failed");
        }
        this.e = this.a.chooseConfig(this.d, false);
        this.f = this.b.createContextAPI17(this.d, this.e, eglContext.getEglContext());
        if (this.f == null || this.f == EGL14.EGL_NO_CONTEXT) {
            this.f = null;
            this.a("createContext");
        }
        Loggers.w("EglHelper", "createContext " + this.f + " tid=" + Thread.currentThread().getId());
        this.g = null;
        EglContextWrapper eglContextWrapper = new EglContextWrapper();
        eglContextWrapper.setEglContext(this.f);
        return eglContextWrapper;
    }

    @Override
    public boolean createSurface(Object surface) {
        Loggers.w("EglHelper", "createSurface()  tid=" + Thread.currentThread().getId());
        if (this.d == null) {
            throw new RuntimeException("eglDisplay not initialized");
        }
        if (this.e == null) {
            throw new RuntimeException("mEglConfig not initialized");
        }
        this.a();
        this.g = this.c.createWindowSurface(this.d, this.e, surface);
        if (this.g == null || this.g == EGL14.EGL_NO_SURFACE) {
            int n = EGL14.eglGetError();
            if (n == 12299) {
                Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.d, (EGLSurface)this.g, (EGLSurface)this.g, (EGLContext)this.f)) {
            EglHelperAPI17.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", EGL14.eglGetError());
            return false;
        }
        return true;
    }

    @Override
    public int swap() {
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.d, (EGLSurface)this.g)) {
            Loggers.w("EglHelperAPI17", String.format("swap: start get error", new Object[0]));
            return EGL14.eglGetError();
        }
        return 12288;
    }

    @Override
    public void destroySurface() {
        this.a();
    }

    private void a() {
        if (this.g != null && this.g != EGL14.EGL_NO_SURFACE) {
            EGL14.eglMakeCurrent((EGLDisplay)this.d, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            this.c.destroySurface(this.d, this.g);
            this.g = null;
        }
    }

    @Override
    public void finish() {
        if (this.f != null) {
            this.b.destroyContext(this.d, this.f);
            this.f = null;
        }
        if (this.d != null) {
            EGL14.eglTerminate((EGLDisplay)this.d);
            this.d = null;
        }
    }

    @Override
    public void setPresentationTime(long nsecs) {
        if (Build.VERSION.SDK_INT >= 18 && nsecs != 0L) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.d, (EGLSurface)this.g, (long)nsecs);
        }
    }

    public static void logEglErrorAsWarning(String tag, String function, int error) {
        Log.w((String)tag, (String)EglHelper.formatEglError(function, error));
    }

    private void a(String string) {
        EglHelperAPI17.throwEglException(string, EGL14.eglGetError());
    }

    public static void throwEglException(String function, int error) {
        String string = EglHelper.formatEglError(function, error);
        Loggers.e("EglHelper", "throwEglException tid=" + Thread.currentThread().getId() + " " + string);
        throw new RuntimeException(string);
    }
}

