/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture.gles;

import android.util.Log;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.glview.texture.gles.EGLLogWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import com.chillingvan.canvasgl.glview.texture.gles.IEglHelper;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EglHelper
implements IEglHelper {
    private GLThread.EGLConfigChooser a;
    private GLThread.EGLContextFactory b;
    private GLThread.EGLWindowSurfaceFactory c;
    private EGL10 d;
    private EGLDisplay e;
    private EGLSurface f;
    private EGLConfig g;
    private EGLContext h;

    public EglHelper(GLThread.EGLConfigChooser configChooser, GLThread.EGLContextFactory eglContextFactory, GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
        this.a = configChooser;
        this.b = eglContextFactory;
        this.c = eglWindowSurfaceFactory;
    }

    @Override
    public EglContextWrapper start(EglContextWrapper eglContext) {
        this.d = (EGL10)EGLContext.getEGL();
        this.e = this.d.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.e == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] nArray = new int[2];
        if (!this.d.eglInitialize(this.e, nArray)) {
            throw new RuntimeException("eglInitialize failed");
        }
        this.g = this.a.chooseConfig(this.d, this.e);
        this.h = this.b.createContext(this.d, this.e, this.g, eglContext.getEglContextOld());
        if (this.h == null || this.h == EGL10.EGL_NO_CONTEXT) {
            this.h = null;
            this.a("createContext");
        }
        this.f = null;
        EglContextWrapper eglContextWrapper = new EglContextWrapper();
        eglContextWrapper.setEglContextOld(this.h);
        return eglContextWrapper;
    }

    @Override
    public boolean createSurface(Object surface) {
        Loggers.w("EglHelper", "createSurface()  tid=" + Thread.currentThread().getId());
        if (this.d == null) {
            throw new RuntimeException("egl not initialized");
        }
        if (this.e == null) {
            throw new RuntimeException("eglDisplay not initialized");
        }
        if (this.g == null) {
            throw new RuntimeException("mEglConfig not initialized");
        }
        this.a();
        this.f = this.c.createWindowSurface(this.d, this.e, this.g, surface);
        if (this.f == null || this.f == EGL10.EGL_NO_SURFACE) {
            int n = this.d.eglGetError();
            if (n == 12299) {
                Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        if (!this.d.eglMakeCurrent(this.e, this.f, this.f, this.h)) {
            EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.d.eglGetError());
            return false;
        }
        return true;
    }

    @Override
    public int swap() {
        if (!this.d.eglSwapBuffers(this.e, this.f)) {
            return this.d.eglGetError();
        }
        return 12288;
    }

    @Override
    public void destroySurface() {
        this.a();
    }

    private void a() {
        if (this.f != null && this.f != EGL10.EGL_NO_SURFACE) {
            this.d.eglMakeCurrent(this.e, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.c.destroySurface(this.d, this.e, this.f);
            this.f = null;
        }
    }

    @Override
    public void finish() {
        if (this.h != null) {
            this.b.destroyContext(this.d, this.e, this.h);
            this.h = null;
        }
        if (this.e != null) {
            this.d.eglTerminate(this.e);
            this.e = null;
        }
    }

    @Override
    public void setPresentationTime(long nsecs) {
    }

    private void a(String string) {
        EglHelper.throwEglException(string, this.d.eglGetError());
    }

    public static void throwEglException(String function, int error) {
        String string = EglHelper.formatEglError(function, error);
        throw new RuntimeException(string);
    }

    public static void logEglErrorAsWarning(String tag, String function, int error) {
        Log.w((String)tag, (String)EglHelper.formatEglError(function, error));
    }

    public static String formatEglError(String function, int error) {
        return function + " failed: " + EGLLogWrapper.getErrorString(error);
    }
}

