/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.TextureView;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.glview.texture.GLViewRenderer;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import java.util.ArrayList;
import java.util.List;

abstract class BaseGLTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    protected GLThread mGLThread;
    protected GLThread.Builder glThreadBuilder;
    private List<Runnable> a = new ArrayList<Runnable>();
    private TextureView.SurfaceTextureListener b;
    private GLThread.OnCreateGLContextListener c;
    private boolean d = false;
    private boolean e = false;
    private GLViewRenderer f;

    public BaseGLTextureView(Context context) {
        super(context);
        this.init();
    }

    public BaseGLTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BaseGLTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Loggers.d("BaseGLTextureView", "onSizeChanged: ");
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mGLThread != null) {
            this.mGLThread.onWindowResize(w, h);
        }
    }

    public void onPause() {
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
        }
    }

    public void onResume() {
        if (this.mGLThread != null) {
            this.mGLThread.onResume();
        }
    }

    public void queueEvent(Runnable r) {
        if (this.mGLThread == null) {
            this.a.add(r);
            return;
        }
        this.mGLThread.queueEvent(r);
    }

    public void requestRender() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    public void requestRenderAndWait() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    protected void surfaceCreated() {
        this.mGLThread.surfaceCreated();
    }

    protected void surfaceDestroyed() {
        this.mGLThread.surfaceDestroyed();
        this.mGLThread.requestExitAndWait();
        this.d = false;
        this.e = false;
        this.mGLThread = null;
    }

    protected void surfaceChanged(int w, int h) {
        this.mGLThread.onWindowResize(w, h);
    }

    protected void surfaceRedrawNeeded() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    protected void onDetachedFromWindow() {
        Loggers.d("BaseGLTextureView", "onDetachedFromWindow: ");
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        super.onDetachedFromWindow();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void init() {
        super.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    @Nullable
    public EglContextWrapper getCurrentEglContext() {
        return this.mGLThread == null ? null : this.mGLThread.getEglContext();
    }

    public void setOnCreateGLContextListener(GLThread.OnCreateGLContextListener onCreateGLContextListener) {
        this.c = onCreateGLContextListener;
    }

    public void setSurfaceTextureListener(TextureView.SurfaceTextureListener surfaceTextureListener) {
        this.b = surfaceTextureListener;
    }

    protected int getRenderMode() {
        return 0;
    }

    protected abstract void onGLDraw(ICanvasGL var1);

    public void setRenderer(GLViewRenderer renderer) {
        this.f = renderer;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Loggers.d("BaseGLTextureView", "onSurfaceTextureAvailable: ");
        this.e = true;
        this.glThreadBuilder = new GLThread.Builder();
        if (this.mGLThread == null) {
            this.glThreadBuilder.setRenderMode(this.getRenderMode()).setSurface(surface).setRenderer(this.f);
            if (this.d) {
                this.createGLThread();
            }
        } else {
            this.mGLThread.setSurface(surface);
            this.a(width, height);
        }
        if (this.b != null) {
            this.b.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    protected void createGLThread() {
        Loggers.d("BaseGLTextureView", "createGLThread: ");
        this.d = true;
        if (!this.e) {
            return;
        }
        this.mGLThread = this.glThreadBuilder.createGLThread();
        this.mGLThread.setOnCreateGLContextListener(new GLThread.OnCreateGLContextListener(){

            @Override
            public void onCreate(final EglContextWrapper eglContext) {
                BaseGLTextureView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BaseGLTextureView.this.c != null) {
                            BaseGLTextureView.this.c.onCreate(eglContext);
                        }
                    }
                });
            }
        });
        this.mGLThread.start();
        this.a(this.getWidth(), this.getHeight());
        for (Runnable runnable : this.a) {
            this.mGLThread.queueEvent(runnable);
        }
        this.a.clear();
    }

    private void a(int n, int n2) {
        this.surfaceCreated();
        this.surfaceChanged(n, n2);
        this.surfaceRedrawNeeded();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Loggers.d("BaseGLTextureView", "onSurfaceTextureSizeChanged: ");
        this.surfaceChanged(width, height);
        this.surfaceRedrawNeeded();
        if (this.b != null) {
            this.b.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        Loggers.d("BaseGLTextureView", "onSurfaceTextureDestroyed: ");
        this.surfaceDestroyed();
        if (this.b != null) {
            this.b.onSurfaceTextureDestroyed(surface);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.b != null) {
            this.b.onSurfaceTextureUpdated(surface);
        }
    }
}

