/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glcanvas;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.GLES11Ext;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import android.util.Log;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLES20IdImpl;
import com.chillingvan.canvasgl.glcanvas.GLId;
import com.chillingvan.canvasgl.glcanvas.GLPaint;
import com.chillingvan.canvasgl.glcanvas.IntArray;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glcanvas.TextureMatrixTransformer;
import com.chillingvan.canvasgl.shapeFilter.DrawShapeFilter;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GLES20Canvas
implements GLCanvas {
    private static final String e = GLES20Canvas.class.getSimpleName();
    private static final float[] f = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] g = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    public static final String POSITION_ATTRIBUTE = "aPosition";
    public static final String COLOR_UNIFORM = "uColor";
    public static final String MATRIX_UNIFORM = "uMatrix";
    public static final String TEXTURE_MATRIX_UNIFORM = "uTextureMatrix";
    public static final String TEXTURE_SAMPLER_UNIFORM = "uTextureSampler";
    public static final String ALPHA_UNIFORM = "uAlpha";
    public static final String TEXTURE_COORD_ATTRIBUTE = "aTextureCoordinate";
    public static final String MESH_VERTEX_SHADER = "uniform mat4 uMatrix;\nattribute vec2 aPosition;\nattribute vec2 aTextureCoordinate;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n  gl_Position = uMatrix * pos;\n  vTextureCoord = aTextureCoordinate;\n}\n";
    private Map<DrawShapeFilter, Integer> h = new HashMap<DrawShapeFilter, Integer>();
    private Map<TextureFilter, Integer> i = new HashMap<TextureFilter, Integer>();
    private Map<TextureFilter, Integer> j = new HashMap<TextureFilter, Integer>();
    private float[] k = new float[128];
    private float[] l = new float[8];
    private IntArray m = new IntArray();
    private int n = 0;
    private int o = 0;
    private int p;
    private int q;
    private float[] r = new float[16];
    private int s;
    private int t;
    private int u;
    private int v;
    private int w;
    private int x;
    private int y;
    private TextureFilter z;
    private DrawShapeFilter A;
    private GLCanvas.OnPreDrawTextureListener B;
    private GLCanvas.OnPreDrawShapeListener C;
    b[] a = new b[]{new a("aPosition"), new c("uMatrix"), new c("uColor")};
    b[] b = new b[]{new a("aPosition"), new c("uMatrix"), new c("uTextureMatrix"), new c("uTextureSampler"), new c("uAlpha")};
    b[] c = new b[]{new a("aPosition"), new c("uMatrix"), new c("uTextureMatrix"), new c("uTextureSampler"), new c("uAlpha")};
    b[] d = new b[]{new a("aPosition"), new c("uMatrix"), new a("aTextureCoordinate"), new c("uTextureSampler"), new c("uAlpha")};
    private final IntArray D = new IntArray();
    private final IntArray E = new IntArray();
    private int F = 0;
    private int G = 0;
    private int H = 0;
    private int I = 0;
    private int[] J = new int[1];
    private ArrayList<RawTexture> K = new ArrayList();
    private final float[] L = new float[32];
    private final float[] M = new float[4];
    private final RectF N = new RectF();
    private final RectF O = new RectF();
    private final float[] P = new float[16];
    private final int[] Q = new int[1];
    private static final GLId R = new GLES20IdImpl();

    public GLES20Canvas() {
        Matrix.setIdentityM((float[])this.P, (int)0);
        Matrix.setIdentityM((float[])this.k, (int)this.o);
        this.l[this.n] = 1.0f;
        this.K.add(null);
        FloatBuffer floatBuffer = GLES20Canvas.a(f);
        this.y = this.uploadBuffer(floatBuffer);
        this.u = GLES20Canvas.a(GLES20Canvas.a(35633, "uniform mat4 uMatrix;\nattribute vec2 aPosition;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n  gl_Position = uMatrix * pos;\n}\n"), GLES20Canvas.a(35632, "precision mediump float;\nuniform vec4 uColor;\nvoid main() {\n  gl_FragColor = uColor;\n}\n"), this.a, this.Q);
        int n = GLES20Canvas.a(35632, "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform sampler2D uTextureSampler;\nvoid main() {\n  gl_FragColor = texture2D(uTextureSampler, vTextureCoord);\n  gl_FragColor *= uAlpha;\n}\n");
        int n2 = GLES20Canvas.a(35633, MESH_VERTEX_SHADER);
        this.a(n2, n);
        GLES20.glBlendFunc((int)1, (int)771);
        GLES20Canvas.checkError();
    }

    private void a(int n, int n2) {
        this.x = GLES20Canvas.a(n, n2, this.d, this.Q);
    }

    private static FloatBuffer a(float[] fArray) {
        int n = fArray.length * 4;
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray, 0, fArray.length).position(0);
        return floatBuffer;
    }

    private static int a(int n, int n2, b[] bArray, int[] nArray) {
        int n3 = GLES20.glCreateProgram();
        GLES20Canvas.checkError();
        if (n3 == 0) {
            throw new RuntimeException("Cannot create GL program: " + GLES20.glGetError());
        }
        GLES20.glAttachShader((int)n3, (int)n);
        GLES20Canvas.checkError();
        GLES20.glAttachShader((int)n3, (int)n2);
        GLES20Canvas.checkError();
        GLES20.glLinkProgram((int)n3);
        GLES20Canvas.checkError();
        GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            Log.e((String)e, (String)"Could not link program: ");
            Log.e((String)e, (String)GLES20.glGetProgramInfoLog((int)n3));
            GLES20.glDeleteProgram((int)n3);
            n3 = 0;
        }
        GLES20Canvas.a(bArray, n3);
        return n3;
    }

    private static void a(b[] bArray, int n) {
        for (int i = 0; i < bArray.length; ++i) {
            bArray[i].a(n);
        }
    }

    private static int a(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        GLES20.glShaderSource((int)n2, (String)string);
        GLES20Canvas.checkError();
        GLES20.glCompileShader((int)n2);
        GLES20Canvas.checkError();
        return n2;
    }

    @Override
    public void setSize(int width, int height) {
        this.p = width;
        this.q = height;
        GLES20.glViewport((int)0, (int)0, (int)this.p, (int)this.q);
        GLES20Canvas.checkError();
        Matrix.setIdentityM((float[])this.k, (int)this.o);
        Matrix.orthoM((float[])this.r, (int)0, (float)0.0f, (float)width, (float)0.0f, (float)height, (float)-1.0f, (float)1.0f);
        if (this.a() == null) {
            this.s = width;
            this.t = height;
            Matrix.translateM((float[])this.k, (int)this.o, (float)0.0f, (float)height, (float)0.0f);
            Matrix.scaleM((float[])this.k, (int)this.o, (float)1.0f, (float)-1.0f, (float)1.0f);
        }
    }

    @Override
    public void clearBuffer() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20Canvas.checkError();
        GLES20.glClear((int)16384);
        GLES20Canvas.checkError();
    }

    @Override
    public void clearBuffer(float[] argb) {
        GLES20.glClearColor((float)argb[1], (float)argb[2], (float)argb[3], (float)argb[0]);
        GLES20Canvas.checkError();
        GLES20.glClear((int)16384);
        GLES20Canvas.checkError();
    }

    @Override
    public float getAlpha() {
        return this.l[this.n];
    }

    @Override
    public void setAlpha(float alpha) {
        this.l[this.n] = alpha;
    }

    @Override
    public void multiplyAlpha(float alpha) {
        this.setAlpha(this.getAlpha() * alpha);
    }

    @Override
    public void translate(float x, float y, float z) {
        Matrix.translateM((float[])this.k, (int)this.o, (float)x, (float)y, (float)z);
    }

    @Override
    public void setMatrix(float[] mt) {
        int n = this.o;
        for (int i = 0; i < mt.length - 4; ++i) {
            this.k[n + i] = mt[i];
        }
        int n2 = n + 12;
        this.k[n2] = this.k[n2] + mt[12];
        int n3 = n + 13;
        this.k[n3] = this.k[n3] + mt[13];
        int n4 = n + 14;
        this.k[n4] = this.k[n4] + mt[14];
        this.k[n + 15] = mt[15];
    }

    @Override
    public void translate(float x, float y) {
        int n = this.o;
        float[] fArray = this.k;
        int n2 = n + 12;
        fArray[n2] = fArray[n2] + (fArray[n + 0] * x + fArray[n + 4] * y);
        int n3 = n + 13;
        fArray[n3] = fArray[n3] + (fArray[n + 1] * x + fArray[n + 5] * y);
        int n4 = n + 14;
        fArray[n4] = fArray[n4] + (fArray[n + 2] * x + fArray[n + 6] * y);
        int n5 = n + 15;
        fArray[n5] = fArray[n5] + (fArray[n + 3] * x + fArray[n + 7] * y);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        Matrix.scaleM((float[])this.k, (int)this.o, (float)sx, (float)sy, (float)sz);
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        if (angle == 0.0f) {
            return;
        }
        float[] fArray = this.L;
        Matrix.setRotateM((float[])fArray, (int)0, (float)angle, (float)x, (float)y, (float)z);
        float[] fArray2 = this.k;
        int n = this.o;
        Matrix.multiplyMM((float[])fArray, (int)16, (float[])fArray2, (int)n, (float[])fArray, (int)0);
        System.arraycopy(fArray, 16, fArray2, n, 16);
    }

    @Override
    public void multiplyMatrix(float[] matrix, int offset) {
        float[] fArray = this.L;
        float[] fArray2 = this.k;
        int n = this.o;
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)n, (float[])matrix, (int)offset);
        System.arraycopy(fArray, 0, fArray2, n, 16);
    }

    @Override
    public void save() {
        this.save(-1);
    }

    @Override
    public void save(int saveFlags) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = (saveFlags & 1) == 1;
        if (bl2) {
            float f = this.getAlpha();
            ++this.n;
            if (this.l.length <= this.n) {
                this.l = Arrays.copyOf(this.l, this.l.length * 2);
            }
            this.l[this.n] = f;
        }
        boolean bl4 = bl = (saveFlags & 2) == 2;
        if (bl) {
            int n = this.o;
            this.o += 16;
            if (this.k.length <= this.o) {
                this.k = Arrays.copyOf(this.k, this.k.length * 2);
            }
            System.arraycopy(this.k, n, this.k, this.o, 16);
        }
        this.m.add(saveFlags);
    }

    @Override
    public void restore() {
        boolean bl;
        boolean bl2;
        int n = this.m.removeLast();
        boolean bl3 = bl2 = (n & 1) == 1;
        if (bl2) {
            --this.n;
        }
        boolean bl4 = bl = (n & 2) == 2;
        if (bl) {
            this.o -= 16;
        }
    }

    @Override
    public void drawCircle(float x, float y, float radius, GLPaint paint, DrawShapeFilter drawShapeFilter) {
        this.a(drawShapeFilter);
        this.a(5, 0, 4, x, y, 2.0f * radius, 2.0f * radius, paint.getColor(), 0.0f);
    }

    @Override
    public void drawLine(float x1, float y1, float x2, float y2, GLPaint paint, DrawShapeFilter drawShapeFilter) {
        this.a(drawShapeFilter);
        this.a(3, 4, 2, x1, y1, x2 - x1, y2 - y1, paint);
        ++this.I;
    }

    @Override
    public void drawRect(float x, float y, float width, float height, GLPaint paint, DrawShapeFilter drawShapeFilter) {
        this.a(drawShapeFilter);
        this.a(2, 6, 4, x, y, width, height, paint);
        ++this.I;
    }

    private void a(int n, int n2, int n3, float f, float f2, float f3, float f4, GLPaint gLPaint) {
        this.a(n, n2, n3, f, f2, f3, f4, gLPaint.getColor(), gLPaint.getLineWidth());
    }

    private void a(int n, int n2, int n3, float f, float f2, float f3, float f4, int n4, float f5) {
        this.a(n2, n4, f5);
        if (this.C != null) {
            this.C.onPreDraw(this.u, this.A);
        }
        this.a(this.a, n, n3, f, f2, f3, f4);
    }

    private void a(int n, int n2, float f) {
        GLES20.glUseProgram((int)this.u);
        GLES20Canvas.checkError();
        if (f > 0.0f) {
            GLES20.glLineWidth((float)f);
            GLES20Canvas.checkError();
        }
        float[] fArray = this.a(n2);
        GLES20Canvas.a(true);
        GLES20.glBlendColor((float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3]);
        GLES20Canvas.checkError();
        GLES20.glUniform4fv((int)this.a[2].a, (int)1, (float[])fArray, (int)0);
        this.b(this.a, n);
        GLES20Canvas.checkError();
    }

    private float[] a(int n) {
        float f = (float)(n >>> 24 & 0xFF) / 255.0f * this.getAlpha();
        float f2 = (float)(n >>> 16 & 0xFF) / 255.0f * f;
        float f3 = (float)(n >>> 8 & 0xFF) / 255.0f * f;
        float f4 = (float)(n & 0xFF) / 255.0f * f;
        this.M[0] = f2;
        this.M[1] = f3;
        this.M[2] = f4;
        this.M[3] = f;
        return this.M;
    }

    private static void a(boolean bl) {
        if (bl) {
            GLES20.glEnable((int)3042);
            GLES20Canvas.checkError();
        } else {
            GLES20.glDisable((int)3042);
            GLES20Canvas.checkError();
        }
    }

    private void b(b[] bArray, int n) {
        GLES20.glBindBuffer((int)34962, (int)this.y);
        GLES20Canvas.checkError();
        GLES20.glVertexAttribPointer((int)bArray[0].a, (int)2, (int)5126, (boolean)false, (int)8, (int)(n * 8));
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20Canvas.checkError();
    }

    private void a(b[] bArray, int n, int n2, float f, float f2, float f3, float f4) {
        this.a(bArray, f, f2, f3, f4);
        int n3 = bArray[0].a;
        GLES20.glEnableVertexAttribArray((int)n3);
        GLES20Canvas.checkError();
        GLES20.glDrawArrays((int)n, (int)0, (int)n2);
        GLES20Canvas.checkError();
        GLES20.glDisableVertexAttribArray((int)n3);
        GLES20Canvas.checkError();
    }

    private void a(b[] bArray, float f, float f2, float f3, float f4) {
        Matrix.translateM((float[])this.L, (int)0, (float[])this.k, (int)this.o, (float)f, (float)f2, (float)0.0f);
        Matrix.scaleM((float[])this.L, (int)0, (float)f3, (float)f4, (float)1.0f);
        Matrix.multiplyMM((float[])this.L, (int)16, (float[])this.r, (int)0, (float[])this.L, (int)0);
        GLES20.glUniformMatrix4fv((int)bArray[1].a, (int)1, (boolean)false, (float[])this.L, (int)16);
        GLES20Canvas.checkError();
    }

    @Override
    public void fillRect(float x, float y, float width, float height, int color, DrawShapeFilter drawShapeFilter) {
        this.a(drawShapeFilter);
        this.a(5, 0, 4, x, y, width, height, color, 0.0f);
        ++this.H;
    }

    @Override
    public void drawTexture(BasicTexture texture, int x, int y, int width, int height, TextureFilter textureFilter) {
        if (width <= 0 || height <= 0) {
            return;
        }
        this.a(texture.getTarget(), textureFilter);
        TextureMatrixTransformer.copyTextureCoordinates(texture, this.N);
        this.O.set((float)x, (float)y, (float)(x + width), (float)(y + height));
        TextureMatrixTransformer.convertCoordinate(this.N, texture);
        GLES20Canvas.a(this.N, this.O, texture);
        this.a(texture, this.N, this.O);
    }

    @Override
    public void drawTexture(BasicTexture texture, RectF source, RectF target, TextureFilter textureFilter) {
        if (target.width() <= 0.0f || target.height() <= 0.0f) {
            return;
        }
        this.a(texture.getTarget(), textureFilter);
        this.N.set(source);
        this.O.set(target);
        TextureMatrixTransformer.convertCoordinate(this.N, texture);
        GLES20Canvas.a(this.N, this.O, texture);
        this.a(texture, this.N, this.O);
    }

    @Override
    public void drawTexture(BasicTexture texture, float[] textureTransform, int x, int y, int w, int h, TextureFilter textureFilter) {
        if (w <= 0 || h <= 0) {
            return;
        }
        this.a(texture.getTarget(), textureFilter);
        this.O.set((float)x, (float)y, (float)(x + w), (float)(y + h));
        this.a(texture, textureTransform, this.O);
    }

    private void a(BasicTexture basicTexture, RectF rectF, RectF rectF2) {
        TextureMatrixTransformer.setTextureMatrix(rectF, this.P);
        this.a(basicTexture, this.P, rectF2);
    }

    private static void a(RectF rectF, RectF rectF2, BasicTexture basicTexture) {
        float f = (float)basicTexture.getHeight() / (float)basicTexture.getTextureHeight();
        float f2 = (float)basicTexture.getWidth() / (float)basicTexture.getTextureWidth();
        if (rectF.right > f2) {
            rectF2.right = rectF2.left + rectF2.width() * (f2 - rectF.left) / rectF.width();
        }
        if (rectF.bottom > f) {
            rectF2.bottom = rectF2.top + rectF2.height() * (f - rectF.top) / rectF.height();
        }
    }

    private void a(BasicTexture basicTexture, float[] fArray, RectF rectF) {
        b[] bArray = this.a(basicTexture);
        this.b(bArray, 0);
        GLES20.glUniformMatrix4fv((int)bArray[2].a, (int)1, (boolean)false, (float[])fArray, (int)0);
        if (this.B != null) {
            this.B.onPreDraw(basicTexture.getTarget() == 3553 ? this.v : this.w, basicTexture, this.z);
        }
        GLES20Canvas.checkError();
        if (basicTexture.isFlippedVertically()) {
            this.save(2);
            this.translate(0.0f, rectF.centerY());
            this.scale(1.0f, -1.0f, 1.0f);
            this.translate(0.0f, -rectF.centerY());
        }
        this.a(bArray, 5, 4, rectF.left, rectF.top, rectF.width(), rectF.height());
        if (basicTexture.isFlippedVertically()) {
            this.restore();
        }
        ++this.G;
    }

    private b[] a(BasicTexture basicTexture) {
        int n;
        b[] bArray;
        if (basicTexture.getTarget() == 3553) {
            bArray = this.b;
            n = this.v;
        } else {
            bArray = this.c;
            n = this.w;
        }
        this.a(basicTexture, n, bArray);
        return bArray;
    }

    private void a(BasicTexture basicTexture, int n, b[] bArray) {
        GLES20.glUseProgram((int)n);
        GLES20Canvas.checkError();
        GLES20Canvas.a(!basicTexture.isOpaque() || this.getAlpha() < 0.95f);
        GLES20.glActiveTexture((int)33984);
        GLES20Canvas.checkError();
        basicTexture.onBind(this);
        GLES20.glBindTexture((int)basicTexture.getTarget(), (int)basicTexture.getId());
        GLES20Canvas.checkError();
        GLES20.glUniform1i((int)bArray[3].a, (int)0);
        GLES20Canvas.checkError();
        GLES20.glUniform1f((int)bArray[4].a, (float)this.getAlpha());
        GLES20Canvas.checkError();
    }

    @Override
    public void drawMesh(BasicTexture texture, int x, int y, int xyBuffer, int uvBuffer, int indexBuffer, int indexCount, int mode) {
        this.a(texture, this.x, this.d);
        GLES20.glBindBuffer((int)34963, (int)indexBuffer);
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34962, (int)xyBuffer);
        GLES20Canvas.checkError();
        int n = this.d[0].a;
        GLES20.glVertexAttribPointer((int)n, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34962, (int)uvBuffer);
        GLES20Canvas.checkError();
        int n2 = this.d[2].a;
        GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20Canvas.checkError();
        GLES20.glEnableVertexAttribArray((int)n);
        GLES20Canvas.checkError();
        GLES20.glEnableVertexAttribArray((int)n2);
        GLES20Canvas.checkError();
        this.a(this.d, x, y, 1.0f, 1.0f);
        GLES20.glDrawElements((int)mode, (int)indexCount, (int)5121, (int)0);
        GLES20Canvas.checkError();
        GLES20.glDisableVertexAttribArray((int)n);
        GLES20Canvas.checkError();
        GLES20.glDisableVertexAttribArray((int)n2);
        GLES20Canvas.checkError();
        GLES20.glBindBuffer((int)34963, (int)0);
        GLES20Canvas.checkError();
        ++this.F;
    }

    @Override
    public void drawMixed(BasicTexture texture, int toColor, float ratio, int x, int y, int w, int h, DrawShapeFilter drawShapeFilter) {
        TextureMatrixTransformer.copyTextureCoordinates(texture, this.N);
        this.O.set((float)x, (float)y, (float)(x + w), (float)(y + h));
        this.drawMixed(texture, toColor, ratio, this.N, this.O, drawShapeFilter);
    }

    @Override
    public void drawMixed(BasicTexture texture, int toColor, float ratio, RectF source, RectF target, DrawShapeFilter drawShapeFilter) {
        if (target.width() <= 0.0f || target.height() <= 0.0f) {
            return;
        }
        this.save(1);
        float f = this.getAlpha();
        float f2 = Math.min(1.0f, Math.max(0.0f, ratio));
        float f3 = (1.0f - f2) * f;
        this.setAlpha(f3);
        this.drawTexture(texture, source, target, new BasicTextureFilter());
        float f4 = f2 * f;
        this.setAlpha(f4);
        this.fillRect(target.left, target.top, target.width(), target.height(), toColor, drawShapeFilter);
        this.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unloadTexture(BasicTexture texture) {
        boolean bl = texture.isLoaded();
        if (bl) {
            IntArray intArray = this.D;
            synchronized (intArray) {
                this.D.add(texture.getId());
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBuffer(int bufferId) {
        IntArray intArray = this.D;
        synchronized (intArray) {
            this.E.add(bufferId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecycledResources() {
        IntArray intArray = this.D;
        synchronized (intArray) {
            IntArray intArray2 = this.D;
            if (this.D.size() > 0) {
                R.glDeleteTextures(intArray2.size(), intArray2.getInternalArray(), 0);
                intArray2.clear();
            }
            if ((intArray2 = this.E).size() > 0) {
                R.glDeleteBuffers(intArray2.size(), intArray2.getInternalArray(), 0);
                intArray2.clear();
            }
        }
    }

    @Override
    public void dumpStatisticsAndClear() {
        String string = String.format("MESH:%d, TEX_RECT:%d, FILL_RECT:%d, LINE:%d", this.F, this.G, this.H, this.I);
        this.F = 0;
        this.G = 0;
        this.H = 0;
        this.I = 0;
        Log.d((String)e, (String)string);
    }

    @Override
    public void endRenderTarget() {
        RawTexture rawTexture = this.K.remove(this.K.size() - 1);
        RawTexture rawTexture2 = this.a();
        this.a(rawTexture, rawTexture2);
        this.restore();
    }

    @Override
    public void beginRenderTarget(RawTexture texture) {
        this.save();
        RawTexture rawTexture = this.a();
        this.K.add(texture);
        this.a(rawTexture, texture);
    }

    private RawTexture a() {
        return this.K.get(this.K.size() - 1);
    }

    private void a(BasicTexture basicTexture, RawTexture rawTexture) {
        if (basicTexture == null && rawTexture != null) {
            if (rawTexture.getTarget() == 3553) {
                GLES20.glGenFramebuffers((int)1, (int[])this.J, (int)0);
                GLES20Canvas.checkError();
                GLES20.glBindFramebuffer((int)36160, (int)this.J[0]);
                GLES20Canvas.checkError();
            } else {
                GLES11Ext.glGenFramebuffersOES((int)1, (int[])this.J, (int)0);
                GLES20Canvas.checkError();
                GLES11Ext.glBindFramebufferOES((int)36160, (int)this.J[0]);
                GLES20Canvas.checkError();
            }
        } else if (basicTexture != null && rawTexture == null) {
            if (basicTexture.getTarget() == 3553) {
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GLES20Canvas.checkError();
                GLES20.glDeleteFramebuffers((int)1, (int[])this.J, (int)0);
                GLES20Canvas.checkError();
            } else {
                GLES11Ext.glBindFramebufferOES((int)36160, (int)0);
                GLES20Canvas.checkError();
                GLES11Ext.glDeleteFramebuffersOES((int)1, (int[])this.J, (int)0);
                GLES20Canvas.checkError();
            }
        }
        if (rawTexture == null) {
            this.setSize(this.s, this.t);
        } else {
            this.setSize(rawTexture.getWidth(), rawTexture.getHeight());
            if (!rawTexture.isLoaded()) {
                rawTexture.prepare(this);
            }
            if (rawTexture.getTarget() == 3553) {
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)rawTexture.getTarget(), (int)rawTexture.getId(), (int)0);
                GLES20Canvas.checkError();
                GLES20Canvas.b();
            } else {
                GLES11Ext.glFramebufferTexture2DOES((int)36160, (int)36064, (int)rawTexture.getTarget(), (int)rawTexture.getId(), (int)0);
                GLES20Canvas.checkError();
                GLES20Canvas.c();
            }
        }
    }

    private static void b() {
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            String string = "";
            switch (n) {
                case 36054: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                    break;
                }
                case 36057: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                    break;
                }
                case 36055: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                    break;
                }
                case 36061: {
                    string = "GL_FRAMEBUFFER_UNSUPPORTED";
                }
            }
            throw new RuntimeException(string + ":" + Integer.toHexString(n));
        }
    }

    private static void c() {
        int n = GLES11Ext.glCheckFramebufferStatusOES((int)36160);
        if (n != 36053) {
            String string = "";
            switch (n) {
                case 36054: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                    break;
                }
                case 36057: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                    break;
                }
                case 36055: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                    break;
                }
                case 36061: {
                    string = "GL_FRAMEBUFFER_UNSUPPORTED";
                }
            }
            throw new RuntimeException(string + ":" + Integer.toHexString(n));
        }
    }

    @Override
    public void setTextureParameters(BasicTexture texture) {
        int n = texture.getTarget();
        GLES20.glBindTexture((int)n, (int)texture.getId());
        GLES20Canvas.checkError();
        GLES20.glTexParameteri((int)n, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)n, (int)10243, (int)33071);
        GLES20.glTexParameterf((int)n, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10240, (float)9729.0f);
    }

    @Override
    public void initializeTextureSize(BasicTexture texture, int format, int type) {
        int n = texture.getTarget();
        GLES20.glBindTexture((int)n, (int)texture.getId());
        GLES20Canvas.checkError();
        int n2 = texture.getTextureWidth();
        int n3 = texture.getTextureHeight();
        GLES20.glTexImage2D((int)n, (int)0, (int)format, (int)n2, (int)n3, (int)0, (int)format, (int)type, null);
    }

    @Override
    public void initializeTexture(BasicTexture texture, Bitmap bitmap) {
        int n = texture.getTarget();
        GLES20.glBindTexture((int)n, (int)texture.getId());
        GLES20Canvas.checkError();
        GLUtils.texImage2D((int)n, (int)0, (Bitmap)bitmap, (int)0);
    }

    @Override
    public void texSubImage2D(BasicTexture texture, int xOffset, int yOffset, Bitmap bitmap, int format, int type) {
        int n = texture.getTarget();
        GLES20.glBindTexture((int)n, (int)texture.getId());
        GLES20Canvas.checkError();
        GLUtils.texSubImage2D((int)n, (int)0, (int)xOffset, (int)yOffset, (Bitmap)bitmap, (int)format, (int)type);
    }

    @Override
    public int uploadBuffer(FloatBuffer buf) {
        return this.a(buf, 4);
    }

    @Override
    public int uploadBuffer(ByteBuffer buf) {
        return this.a(buf, 1);
    }

    private int a(Buffer buffer, int n) {
        R.glGenBuffers(1, this.Q, 0);
        GLES20Canvas.checkError();
        int n2 = this.Q[0];
        GLES20.glBindBuffer((int)34962, (int)n2);
        GLES20Canvas.checkError();
        GLES20.glBufferData((int)34962, (int)(buffer.capacity() * n), (Buffer)buffer, (int)35044);
        GLES20Canvas.checkError();
        return n2;
    }

    public static void checkError() {
        int n = GLES20.glGetError();
        if (n != 0) {
            Throwable throwable = new Throwable();
            Log.e((String)e, (String)("GL error: " + n), (Throwable)throwable);
        }
    }

    public static void printMatrix(String message, float[] m, int offset) {
        StringBuilder stringBuilder = new StringBuilder(message);
        for (int i = 0; i < 16; ++i) {
            stringBuilder.append(' ');
            if (i % 4 == 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(m[offset + i]);
        }
        Loggers.v(e, stringBuilder.toString());
    }

    @Override
    public void recoverFromLightCycle() {
        GLES20.glViewport((int)0, (int)0, (int)this.p, (int)this.q);
        GLES20.glDisable((int)2929);
        GLES20.glBlendFunc((int)1, (int)771);
        GLES20Canvas.checkError();
    }

    @Override
    public void getBounds(Rect bounds, int x, int y, int width, int height) {
        Matrix.translateM((float[])this.L, (int)0, (float[])this.k, (int)this.o, (float)x, (float)y, (float)0.0f);
        Matrix.scaleM((float[])this.L, (int)0, (float)width, (float)height, (float)1.0f);
        Matrix.multiplyMV((float[])this.L, (int)16, (float[])this.L, (int)0, (float[])g, (int)0);
        Matrix.multiplyMV((float[])this.L, (int)20, (float[])this.L, (int)0, (float[])g, (int)4);
        bounds.left = Math.round(this.L[16]);
        bounds.right = Math.round(this.L[20]);
        bounds.top = Math.round(this.L[17]);
        bounds.bottom = Math.round(this.L[21]);
        bounds.sort();
    }

    @Override
    public GLId getGLId() {
        return R;
    }

    private void a(DrawShapeFilter drawShapeFilter) {
        if (drawShapeFilter == null) {
            throw new NullPointerException("draw shape filter is null.");
        }
        this.A = drawShapeFilter;
        if (this.h.containsKey(drawShapeFilter)) {
            this.u = this.h.get(drawShapeFilter);
            GLES20Canvas.a(this.a, this.u);
            return;
        }
        this.u = this.a(this.a, drawShapeFilter.getVertexShader(), drawShapeFilter.getFragmentShader());
        this.h.put(drawShapeFilter, this.u);
    }

    private void a(int n, TextureFilter textureFilter) {
        if (textureFilter == null) {
            throw new NullPointerException("Texture filter is null.");
        }
        this.z = textureFilter;
        if (n == 3553) {
            if (this.i.containsKey(textureFilter)) {
                this.v = this.i.get(textureFilter);
                GLES20Canvas.a(this.b, this.v);
                return;
            }
            this.v = this.a(this.b, textureFilter.getVertexShader(), textureFilter.getFragmentShader());
            this.i.put(textureFilter, this.v);
        } else {
            if (this.j.containsKey(textureFilter)) {
                this.w = this.j.get(textureFilter);
                GLES20Canvas.a(this.c, this.w);
                return;
            }
            this.w = this.a(this.c, textureFilter.getVertexShader(), textureFilter.getOesFragmentProgram());
            this.j.put(textureFilter, this.w);
        }
    }

    private int a(b[] bArray, String string, String string2) {
        int n = GLES20Canvas.a(35633, string);
        int n2 = GLES20Canvas.a(35632, string2);
        return GLES20Canvas.a(n, n2, bArray, this.Q);
    }

    @Override
    public void setOnPreDrawTextureListener(GLCanvas.OnPreDrawTextureListener l) {
        this.B = l;
    }

    @Override
    public void setOnPreDrawShapeListener(GLCanvas.OnPreDrawShapeListener l) {
        this.C = l;
    }

    static class a
    extends b {
        public a(String string) {
            super(string);
        }

        @Override
        public void a(int n) {
            this.a = GLES20.glGetAttribLocation((int)n, (String)this.b);
            GLES20Canvas.checkError();
        }
    }

    static class c
    extends b {
        public c(String string) {
            super(string);
        }

        @Override
        public void a(int n) {
            this.a = GLES20.glGetUniformLocation((int)n, (String)this.b);
            GLES20Canvas.checkError();
        }
    }

    static abstract class b {
        public int a;
        protected final String b;

        public b(String string) {
            this.b = string;
        }

        public abstract void a(int var1);
    }
}

