/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.Bitmap;
import android.opengl.GLES11;
import android.opengl.GLES20;
import android.opengl.GLException;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class OpenGLUtil {
    public static void setUniformMatrix4f(int location, float[] matrix) {
        GLES20.glUniformMatrix4fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
    }

    public static void setFloat(int location, float floatValue) {
        GLES20.glUniform1f((int)location, (float)floatValue);
    }

    public static Bitmap createBitmapFromGLSurface(int x, int y, int w, int h, int glHeight) throws OutOfMemoryError {
        int[] nArray = new int[w * h];
        int[] nArray2 = new int[w * h];
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        intBuffer.position(0);
        try {
            GLES11.glReadPixels((int)x, (int)(glHeight - h - y), (int)w, (int)h, (int)6408, (int)5121, (Buffer)intBuffer);
            for (int i = 0; i < h; ++i) {
                int n = i * w;
                int n2 = (h - i - 1) * w;
                for (int j = 0; j < w; ++j) {
                    int n3;
                    int n4 = nArray[n + j];
                    int n5 = n4 >> 16 & 0xFF;
                    int n6 = n4 << 16 & 0xFF0000;
                    nArray2[n2 + j] = n3 = n4 & 0xFF00FF00 | n6 | n5;
                }
            }
        }
        catch (GLException gLException) {
            return null;
        }
        return Bitmap.createBitmap((int[])nArray2, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }
}

