/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Build;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.BitmapTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLES20Canvas;
import com.chillingvan.canvasgl.glcanvas.GLPaint;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.shapeFilter.BasicDrawShapeFilter;
import com.chillingvan.canvasgl.shapeFilter.DrawCircleFilter;
import com.chillingvan.canvasgl.shapeFilter.DrawShapeFilter;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.FilterGroup;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;
import java.util.Map;
import java.util.WeakHashMap;

public class CanvasGL
implements ICanvasGL {
    private Map<Bitmap, BasicTexture> a = new WeakHashMap<Bitmap, BasicTexture>();
    protected final GLCanvas glCanvas;
    protected final BasicTextureFilter basicTextureFilter;
    private float[] b;
    private float[] c = new float[16];
    private int d;
    private int e;
    private BasicDrawShapeFilter f;
    private DrawCircleFilter g = new DrawCircleFilter();

    public CanvasGL() {
        this(new GLES20Canvas());
    }

    public CanvasGL(GLCanvas glCanvas) {
        this.glCanvas = glCanvas;
        glCanvas.setOnPreDrawShapeListener(new GLCanvas.OnPreDrawShapeListener(){

            @Override
            public void onPreDraw(int program, DrawShapeFilter drawShapeFilter) {
                drawShapeFilter.onPreDraw(program, CanvasGL.this);
            }
        });
        glCanvas.setOnPreDrawTextureListener(new GLCanvas.OnPreDrawTextureListener(){

            @Override
            public void onPreDraw(int textureProgram, BasicTexture texture, TextureFilter textureFilter) {
                textureFilter.onPreDraw(textureProgram, texture, CanvasGL.this);
            }
        });
        this.basicTextureFilter = new BasicTextureFilter();
        this.f = new BasicDrawShapeFilter();
        this.b = new float[4];
    }

    @Override
    public BitmapTexture bindBitmapToTexture(int whichTexture, Bitmap bitmap) {
        GLES20.glActiveTexture((int)whichTexture);
        GLES20Canvas.checkError();
        BitmapTexture bitmapTexture = (BitmapTexture)this.getTexture(bitmap, null);
        bitmapTexture.onBind(this.glCanvas);
        GLES20.glBindTexture((int)bitmapTexture.getTarget(), (int)bitmapTexture.getId());
        GLES20Canvas.checkError();
        return bitmapTexture;
    }

    @Override
    public void beginRenderTarget(RawTexture texture) {
        this.glCanvas.beginRenderTarget(texture);
    }

    @Override
    public void endRenderTarget() {
        this.glCanvas.endRenderTarget();
    }

    @Override
    public GLCanvas getGlCanvas() {
        return this.glCanvas;
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, SurfaceTexture surfaceTexture, int left, int top, int right, int bottom) {
        this.drawSurfaceTexture(texture, surfaceTexture, left, top, right, bottom, this.basicTextureFilter);
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, SurfaceTexture surfaceTexture, int left, int top, int right, int bottom, TextureFilter basicTextureFilter) {
        if (surfaceTexture == null) {
            this.glCanvas.drawTexture(texture, left, top, right - left, bottom - top, basicTextureFilter);
        } else {
            surfaceTexture.getTransformMatrix(this.c);
            this.glCanvas.drawTexture(texture, this.c, left, top, right - left, bottom - top, basicTextureFilter);
        }
    }

    @Override
    public void drawBitmap(Bitmap bitmap, BitmapMatrix matrix) {
        this.drawBitmap(bitmap, matrix, this.basicTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, BitmapMatrix matrix, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.save();
        this.glCanvas.setMatrix(matrix.obtainResultMatrix());
        this.glCanvas.drawTexture(basicTexture, 0, 0, bitmap.getWidth(), bitmap.getHeight(), textureFilter);
        this.restore();
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst) {
        this.drawBitmap(bitmap, new RectF(src), dst, (TextureFilter)this.basicTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top) {
        this.drawBitmap(bitmap, left, top, (TextureFilter)this.basicTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, left, top, bitmap.getWidth(), bitmap.getHeight(), textureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst) {
        this.drawBitmap(bitmap, src, new RectF(dst));
    }

    @Override
    public void drawBitmap(Bitmap bitmap, RectF src, RectF dst, TextureFilter textureFilter) {
        if (dst == null) {
            throw new NullPointerException();
        }
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, src, dst, textureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, int width, int height) {
        this.drawBitmap(bitmap, left, top, width, height, this.basicTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, int width, int height, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, left, top, width, height, textureFilter);
    }

    protected BasicTexture getTexture(Bitmap bitmap, @Nullable TextureFilter textureFilter) {
        BasicTexture basicTexture;
        this.throwIfCannotDraw(bitmap);
        if (this.a.containsKey(bitmap)) {
            basicTexture = this.a.get(bitmap);
        } else {
            basicTexture = new BitmapTexture(bitmap);
            this.a.put(bitmap, basicTexture);
        }
        if (textureFilter instanceof FilterGroup) {
            FilterGroup filterGroup = (FilterGroup)textureFilter;
            basicTexture = filterGroup.draw(basicTexture, this.glCanvas);
        }
        return basicTexture;
    }

    @Override
    public void drawCircle(float x, float y, float radius, GLPaint paint) {
        if (paint.getStyle() == Paint.Style.FILL) {
            this.g.setLineWidth(0.5f);
        } else {
            this.g.setLineWidth(paint.getLineWidth() / (2.0f * radius));
        }
        this.glCanvas.drawCircle(x - radius, y - radius, radius, paint, this.g);
    }

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, GLPaint paint) {
        this.glCanvas.drawLine(startX, startY, stopX, stopY, paint, this.f);
    }

    @Override
    public void drawRect(@NonNull RectF rect, GLPaint paint) {
        this.drawRect(rect.left, rect.top, rect.right, rect.bottom, paint);
    }

    @Override
    public void drawRect(@NonNull Rect r, GLPaint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, GLPaint paint) {
        if (paint.getStyle() == Paint.Style.STROKE) {
            this.glCanvas.drawRect(left, top, right - left, bottom - top, paint, this.f);
        } else {
            this.glCanvas.fillRect(left, top, right - left, bottom - top, paint.getColor(), this.f);
        }
    }

    @Override
    public void save() {
        this.glCanvas.save();
    }

    @Override
    public void save(int saveFlags) {
        this.glCanvas.save(saveFlags);
    }

    @Override
    public void restore() {
        this.glCanvas.restore();
    }

    @Override
    public void rotate(float degrees) {
        this.glCanvas.rotate(degrees, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float degrees, float px, float py) {
        this.glCanvas.translate(px, py);
        this.rotate(degrees);
        this.glCanvas.translate(-px, -py);
    }

    @Override
    public void scale(float sx, float sy) {
        this.glCanvas.scale(sx, sy, 1.0f);
    }

    @Override
    public void scale(float sx, float sy, float px, float py) {
        this.glCanvas.translate(px, py);
        this.scale(sx, sy);
        this.glCanvas.translate(-px, -py);
    }

    @Override
    public void translate(float dx, float dy) {
        this.glCanvas.translate(dx, dy);
    }

    @Override
    public void clearBuffer() {
        this.glCanvas.clearBuffer();
    }

    @Override
    public void clearBuffer(int color) {
        this.b[1] = (float)Color.red((int)color) / 255.0f;
        this.b[2] = (float)Color.green((int)color) / 255.0f;
        this.b[3] = (float)Color.blue((int)color) / 255.0f;
        this.b[0] = (float)Color.alpha((int)color) / 255.0f;
        this.glCanvas.clearBuffer(this.b);
    }

    @Override
    public void setSize(int width, int height) {
        this.d = width;
        this.e = height;
        this.glCanvas.setSize(width, height);
    }

    @Override
    public int getWidth() {
        return this.d;
    }

    @Override
    public int getHeight() {
        return this.e;
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.glCanvas.setAlpha((float)alpha / 255.0f);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (BasicTexture basicTexture : this.a.values()) {
            basicTexture.recycle();
        }
    }

    protected void throwIfCannotDraw(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
        if (Build.VERSION.SDK_INT >= 17 && !bitmap.isPremultiplied() && bitmap.getConfig() == Bitmap.Config.ARGB_8888 && bitmap.hasAlpha()) {
            throw new RuntimeException("Canvas: trying to use a non-premultiplied bitmap " + bitmap);
        }
    }

    public static class BitmapMatrix {
        public static final int TRANSLATE_X = 3;
        public static final int TRANSLATE_Y = 7;
        public static final int SCALE_X = 0;
        public static final int SCALE_Y = 5;
        public static final int MATRIX_SIZE = 16;
        public static final int SKEW_X = 4;
        public static final int SKEW_Y = 1;
        private float[] a = new float[16];
        private float[] b = new float[16];

        public BitmapMatrix() {
            this.reset();
        }

        public void reset() {
            Matrix.setIdentityM((float[])this.a, (int)0);
            Matrix.setIdentityM((float[])this.b, (int)0);
            Matrix.scaleM((float[])this.b, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
        }

        public void postTranslate(float dx, float dy) {
            Matrix.setIdentityM((float[])this.a, (int)0);
            this.a[3] = dx;
            this.a[7] = -dy;
            this.b = this.a(this.a, this.b);
        }

        public void postScale(float sx, float sy, float px, float py) {
            Matrix.setIdentityM((float[])this.a, (int)0);
            this.a[0] = sx;
            this.a[5] = sy;
            this.a[3] = px - sx * px;
            this.a[7] = -(py - sy * py);
            this.b = this.a(this.a, this.b);
        }

        public void postScale(float sx, float sy) {
            this.postScale(sx, sy, 0.0f, 0.0f);
        }

        public void postRotate(float degrees, float px, float py) {
            float f;
            Matrix.setIdentityM((float[])this.a, (int)0);
            float f2 = (float)Math.sin(Math.toRadians(degrees));
            this.a[0] = f = (float)Math.cos(Math.toRadians(degrees));
            this.a[4] = -f2;
            this.a[1] = f2;
            this.a[5] = f;
            this.a[3] = py * f2 + px * (1.0f - f);
            this.a[7] = -(py * (1.0f - f) - px * f2);
            this.b = this.a(this.a, this.b);
        }

        public void postRotate(float degrees) {
            this.postRotate(degrees, 0.0f, 0.0f);
        }

        private float[] a(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[16];
            for (int i = 0; i < 4; ++i) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                for (int j = 0; j < 4; ++j) {
                    float f5 = BitmapMatrix.a(fArray, i, j);
                    f += BitmapMatrix.a(fArray2, j, 0) * f5;
                    f2 += BitmapMatrix.a(fArray2, j, 1) * f5;
                    f3 += BitmapMatrix.a(fArray2, j, 2) * f5;
                    f4 += BitmapMatrix.a(fArray2, j, 3) * f5;
                }
                BitmapMatrix.a(fArray3, i, 0, f);
                BitmapMatrix.a(fArray3, i, 1, f2);
                BitmapMatrix.a(fArray3, i, 2, f3);
                BitmapMatrix.a(fArray3, i, 3, f4);
            }
            return fArray3;
        }

        private static void a(float[] fArray, int n, int n2, float f) {
            fArray[4 * n + n2] = f;
        }

        private static float a(float[] fArray, int n, int n2) {
            return fArray[4 * n + n2];
        }

        public float[] obtainResultMatrix() {
            float[] fArray = new float[16];
            Matrix.transposeM((float[])fArray, (int)0, (float[])this.b, (int)0);
            return fArray;
        }
    }
}

