/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glview.texture.GLTextureView;
import javax.microedition.khronos.opengles.GL10;

public abstract class GLSurfaceTextureProducerView
extends GLTextureView {
    private SurfaceTexture inputSurfaceTexture;
    private OnSurfaceTextureSet onSurfaceTextureSet;
    private RawTexture surfaceTextureHolderTexture;

    public GLSurfaceTextureProducerView(Context context) {
        super(context);
    }

    public GLSurfaceTextureProducerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GLSurfaceTextureProducerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected final void onGLDraw(ICanvasGL canvas) {
        this.onGLDraw(canvas, this.inputSurfaceTexture, this.surfaceTextureHolderTexture);
    }

    protected abstract void onGLDraw(ICanvasGL var1, SurfaceTexture var2, RawTexture var3);

    public void setOnSurfaceTextureSet(OnSurfaceTextureSet onSurfaceTextureSet) {
        this.onSurfaceTextureSet = onSurfaceTextureSet;
    }

    @Override
    protected final int getRenderMode() {
        return 0;
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        super.onSurfaceChanged(gl, width, height);
        if (this.surfaceTextureHolderTexture == null) {
            this.surfaceTextureHolderTexture = new RawTexture(width, height, false, 36197);
            if (!this.surfaceTextureHolderTexture.isLoaded()) {
                this.surfaceTextureHolderTexture.prepare(this.mCanvas.getGlCanvas());
            }
            this.inputSurfaceTexture = new SurfaceTexture(this.surfaceTextureHolderTexture.getId());
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (GLSurfaceTextureProducerView.this.onSurfaceTextureSet != null) {
                        GLSurfaceTextureProducerView.this.onSurfaceTextureSet.onSet(GLSurfaceTextureProducerView.this.inputSurfaceTexture, GLSurfaceTextureProducerView.this.surfaceTextureHolderTexture);
                    }
                }
            });
        } else {
            this.surfaceTextureHolderTexture.setSize(width, height);
        }
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        this.inputSurfaceTexture.updateTexImage();
        super.onDrawFrame(gl);
    }

    @Override
    protected void surfaceDestroyed() {
        super.surfaceDestroyed();
        if (this.surfaceTextureHolderTexture != null) {
            this.surfaceTextureHolderTexture.recycle();
            this.surfaceTextureHolderTexture = null;
        }
        if (this.inputSurfaceTexture != null) {
            this.inputSurfaceTexture.release();
            this.inputSurfaceTexture = null;
        }
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    public static interface OnSurfaceTextureSet {
        public void onSet(SurfaceTexture var1, RawTexture var2);
    }
}

