/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import com.chillingvan.canvasgl.CanvasGL;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glview.GLView;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

public abstract class OffScreenCanvas
implements GLSurfaceView.Renderer {
    protected final GLThread mGLThread;
    private int width;
    private int height;
    protected ICanvasGL mCanvas;
    public GL10 mGL;

    public OffScreenCanvas() {
        this(0, 0);
    }

    public OffScreenCanvas(int width, int height) {
        this.width = width;
        this.height = height;
        this.mGLThread = new GLThread.Builder().setRenderMode(this.getRenderMode()).setEglWindowSurfaceFactory(new SurfaceFactory()).setRenderer(this).createGLThread();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void start() {
        this.mGLThread.start();
        this.mGLThread.surfaceCreated();
        this.mGLThread.onWindowResize(this.width, this.height);
        this.mGLThread.requestRender();
    }

    public void end() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Loggers.d("BaseGLTextureView", "onSurfaceCreated: ");
        this.mCanvas = new CanvasGL();
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Loggers.d("BaseGLTextureView", "onSurfaceChanged: ");
        this.mCanvas.setSize(width, height);
    }

    public void onDrawFrame(GL10 gl) {
        this.mGL = gl;
        this.onGLDraw(this.mCanvas);
    }

    protected int getRenderMode() {
        return 0;
    }

    protected abstract void onGLDraw(ICanvasGL var1);

    public void getDrawingBitmap(final Rect rect, final GLView.GetDrawingCacheCallback getDrawingCacheCallback) {
        final Handler handler = new Handler();
        this.mGLThread.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (OffScreenCanvas.this.mGL == null) {
                    return;
                }
                OffScreenCanvas.this.onDrawFrame(OffScreenCanvas.this.mGL);
                OffScreenCanvas.this.onDrawFrame(OffScreenCanvas.this.mGL);
                final Bitmap bitmapFromGLSurface = OpenGLUtil.createBitmapFromGLSurface(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, OffScreenCanvas.this.mGL, OffScreenCanvas.this.height);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        getDrawingCacheCallback.onFetch(bitmapFromGLSurface);
                    }
                });
            }
        });
        this.mGLThread.requestRender();
    }

    private class SurfaceFactory
    implements GLThread.EGLWindowSurfaceFactory {
        private SurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            int[] attribList = new int[]{12375, OffScreenCanvas.this.width, 12374, OffScreenCanvas.this.height, 12344};
            return egl.eglCreatePbufferSurface(display, config, attribList);
        }

        @Override
        public void destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }
    }
}

