/*
 * Decompiled with CFR 0.152.
 */
package com.danikula.videocache;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.danikula.videocache.HttpProxyCacheDebuger;
import com.danikula.videocache.InterruptedProxyCacheException;
import com.danikula.videocache.Preconditions;
import com.danikula.videocache.ProxyCacheException;
import com.danikula.videocache.ProxyCacheUtils;
import com.danikula.videocache.Source;
import com.danikula.videocache.SourceInfo;
import com.danikula.videocache.headers.EmptyHeadersInjector;
import com.danikula.videocache.headers.HeaderInjector;
import com.danikula.videocache.sourcestorage.SourceInfoStorage;
import com.danikula.videocache.sourcestorage.SourceInfoStorageFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HttpUrlSource
implements Source {
    private static final int MAX_REDIRECTS = 5;
    private final SourceInfoStorage sourceInfoStorage;
    private final HeaderInjector headerInjector;
    private final HostnameVerifier v;
    private final TrustManager[] trustAllCerts;
    private SourceInfo sourceInfo;
    private HttpURLConnection connection;
    private InputStream inputStream;

    public HttpUrlSource(String url, HostnameVerifier v, TrustManager[] trustAllCerts) {
        this(url, SourceInfoStorageFactory.newEmptySourceInfoStorage(), v, trustAllCerts);
    }

    public HttpUrlSource(String url, SourceInfoStorage sourceInfoStorage, HostnameVerifier v, TrustManager[] trustAllCerts) {
        this(url, sourceInfoStorage, new EmptyHeadersInjector(), v, trustAllCerts);
    }

    public HttpUrlSource(String url, SourceInfoStorage sourceInfoStorage, HeaderInjector headerInjector, HostnameVerifier v, TrustManager[] trustAllCerts) {
        this.sourceInfoStorage = Preconditions.checkNotNull(sourceInfoStorage);
        this.headerInjector = Preconditions.checkNotNull(headerInjector);
        this.v = v;
        this.trustAllCerts = trustAllCerts;
        SourceInfo sourceInfo = sourceInfoStorage.get(url);
        this.sourceInfo = sourceInfo != null ? sourceInfo : new SourceInfo(url, Integer.MIN_VALUE, ProxyCacheUtils.getSupposablyMime(url));
    }

    public HttpUrlSource(HttpUrlSource source) {
        this.sourceInfo = source.sourceInfo;
        this.sourceInfoStorage = source.sourceInfoStorage;
        this.headerInjector = source.headerInjector;
        this.trustAllCerts = source.trustAllCerts;
        this.v = source.v;
    }

    @Override
    public synchronized long length() throws ProxyCacheException {
        if (this.sourceInfo.length == Integer.MIN_VALUE) {
            this.fetchContentInfo();
        }
        return this.sourceInfo.length;
    }

    @Override
    public void open(long offset) throws ProxyCacheException {
        try {
            this.connection = this.openConnection(offset, -1);
            String mime = this.connection.getContentType();
            this.inputStream = new BufferedInputStream(this.connection.getInputStream(), 8192);
            long length = this.readSourceAvailableBytes(this.connection, offset, this.connection.getResponseCode());
            this.sourceInfo = new SourceInfo(this.sourceInfo.url, length, mime);
            this.sourceInfoStorage.put(this.sourceInfo.url, this.sourceInfo);
        }
        catch (IOException e) {
            throw new ProxyCacheException("Error opening connection for " + this.sourceInfo.url + " with offset " + offset, e);
        }
    }

    private long readSourceAvailableBytes(HttpURLConnection connection, long offset, int responseCode) throws IOException {
        long contentLength = this.getContentLength(connection);
        return responseCode == 200 ? contentLength : (responseCode == 206 ? contentLength + offset : this.sourceInfo.length);
    }

    private long getContentLength(HttpURLConnection connection) {
        String contentLengthValue = connection.getHeaderField("Content-Length");
        return contentLengthValue == null ? -1L : Long.parseLong(contentLengthValue);
    }

    @Override
    public void close() throws ProxyCacheException {
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String message = "Wait... but why? WTF!? Really shouldn't happen any more after fixing https://github.com/danikula/AndroidVideoCache/issues/43. If you read it on your device log, please, notify me https://github.com/danikula or create issue here https://github.com/danikula/AndroidVideoCache/issues.";
                throw new RuntimeException(message, e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                HttpProxyCacheDebuger.printfError("Error closing connection correctly. Should happen only on Android L. If anybody know how to fix it, please visit https://github.com/danikula/AndroidVideoCache/issues/88. Until good solution is not know, just ignore this issue :(", e);
            }
        }
    }

    @Override
    public int read(byte[] buffer) throws ProxyCacheException {
        if (this.inputStream == null) {
            throw new ProxyCacheException("Error reading data from " + this.sourceInfo.url + ": connection is absent!");
        }
        try {
            return this.inputStream.read(buffer, 0, buffer.length);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedProxyCacheException("Reading source " + this.sourceInfo.url + " is interrupted", e);
        }
        catch (IOException e) {
            throw new ProxyCacheException("Error reading data from " + this.sourceInfo.url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchContentInfo() throws ProxyCacheException {
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        try {
            urlConnection = this.openConnection(0L, 10000);
            long length = this.getContentLength(urlConnection);
            String mime = urlConnection.getContentType();
            inputStream = urlConnection.getInputStream();
            this.sourceInfo = new SourceInfo(this.sourceInfo.url, length, mime);
            this.sourceInfoStorage.put(this.sourceInfo.url, this.sourceInfo);
        }
        catch (IOException e) {
            try {
                HttpProxyCacheDebuger.printfError("Error fetching info from " + this.sourceInfo.url, e);
            }
            catch (Throwable throwable) {
                ProxyCacheUtils.close(inputStream);
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                throw throwable;
            }
            ProxyCacheUtils.close(inputStream);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        ProxyCacheUtils.close(inputStream);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
    }

    private HttpURLConnection openConnection(long offset, int timeout) throws IOException, ProxyCacheException {
        HttpURLConnection connection;
        boolean redirected;
        int redirectCount = 0;
        String url = this.sourceInfo.url;
        do {
            int code;
            if (url.startsWith("https") && this.v != null && this.trustAllCerts != null) {
                connection = (HttpURLConnection)new URL(url).openConnection();
                ((HttpsURLConnection)connection).setHostnameVerifier(this.v);
                try {
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, this.trustAllCerts, new SecureRandom());
                    SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                    ((HttpsURLConnection)connection).setSSLSocketFactory(sslSocketFactory);
                    ((HttpsURLConnection)connection).setHostnameVerifier(this.v);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            } else {
                connection = (HttpURLConnection)new URL(url).openConnection();
            }
            this.injectCustomHeaders(connection, url);
            if (offset > 0L) {
                if (offset > Integer.MAX_VALUE) {
                    String ofs = String.valueOf(offset);
                    long ofr = offset;
                    if (ofs.contains(".")) {
                        ofr = Long.valueOf(ofs.substring(0, ofs.indexOf(".")));
                    }
                    connection.setRequestProperty("Range", "bytes=" + ofr + "-");
                } else {
                    connection.setRequestProperty("Range", "bytes=" + (int)offset + "-");
                }
            }
            if (timeout > 0) {
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
            }
            boolean bl = redirected = (code = connection.getResponseCode()) == 301 || code == 302 || code == 303;
            if (redirected) {
                url = connection.getHeaderField("Location");
                ++redirectCount;
                connection.disconnect();
            }
            if (redirectCount <= 5) continue;
            throw new ProxyCacheException("Too many redirects: " + redirectCount);
        } while (redirected);
        return connection;
    }

    private void injectCustomHeaders(HttpURLConnection connection, String url) {
        Map<String, String> extraHeaders = this.headerInjector.addHeaders(url);
        if (extraHeaders == null) {
            return;
        }
        HttpProxyCacheDebuger.printfError("****** injectCustomHeaders ****** :" + extraHeaders.size());
        for (Map.Entry<String, String> header : extraHeaders.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    public synchronized String getMime() throws ProxyCacheException {
        if (TextUtils.isEmpty((CharSequence)this.sourceInfo.mime)) {
            this.fetchContentInfo();
        }
        return this.sourceInfo.mime;
    }

    public String getUrl() {
        return this.sourceInfo.url;
    }

    @NonNull
    public String toString() {
        return "HttpUrlSource{sourceInfo='" + this.sourceInfo + "}";
    }
}

