/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import android.view.OrientationEventListener;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.OrientationOption;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;

public class OrientationUtils {
    private static final int LAND_TYPE_NULL = 0;
    private static final int LAND_TYPE_NORMAL = 1;
    private static final int LAND_TYPE_REVERSE = 2;
    private Activity mActivity;
    private GSYBaseVideoPlayer mVideoPlayer;
    private OrientationEventListener mOrientationEventListener;
    private OrientationOption mOrientationOption;
    private int mScreenType = 1;
    private int mIsLand = 0;
    private boolean mClick = false;
    private boolean mClickLand = false;
    private boolean mClickPort;
    private boolean mEnable = true;
    private boolean mRotateWithSystem = true;
    private boolean mIsPause = false;
    private boolean mIsOnlyRotateLand = false;

    public OrientationUtils(Activity activity, GSYBaseVideoPlayer gsyVideoPlayer) {
        this(activity, gsyVideoPlayer, null);
    }

    public OrientationUtils(Activity activity, GSYBaseVideoPlayer gsyVideoPlayer, OrientationOption orientationOption) {
        this.mActivity = activity;
        this.mVideoPlayer = gsyVideoPlayer;
        this.mOrientationOption = orientationOption == null ? new OrientationOption() : orientationOption;
        this.initGravity(activity);
        this.init();
    }

    protected void init() {
        this.mOrientationEventListener = new OrientationEventListener(this.mActivity.getApplicationContext()){

            @SuppressLint(value={"SourceLockedOrientationActivity"})
            public void onOrientationChanged(int rotation) {
                boolean autoRotateOn;
                boolean bl = autoRotateOn = Settings.System.getInt((ContentResolver)OrientationUtils.this.mActivity.getContentResolver(), (String)"accelerometer_rotation", (int)0) == 1;
                if (!(autoRotateOn || !OrientationUtils.this.mRotateWithSystem || OrientationUtils.this.mIsOnlyRotateLand && OrientationUtils.this.getIsLand() != 0)) {
                    return;
                }
                if (OrientationUtils.this.mVideoPlayer != null && OrientationUtils.this.mVideoPlayer.isVerticalFullByVideoSize()) {
                    return;
                }
                if (OrientationUtils.this.mIsPause) {
                    return;
                }
                if (rotation >= 0 && rotation <= OrientationUtils.this.mOrientationOption.getNormalPortraitAngleStart() || rotation >= OrientationUtils.this.mOrientationOption.getNormalPortraitAngleEnd()) {
                    if (OrientationUtils.this.mClick) {
                        if (OrientationUtils.this.mIsLand > 0 && !OrientationUtils.this.mClickLand) {
                            return;
                        }
                        OrientationUtils.this.mClickPort = true;
                        OrientationUtils.this.mClick = false;
                        OrientationUtils.this.mIsLand = 0;
                    } else if (OrientationUtils.this.mIsLand > 0) {
                        if (!OrientationUtils.this.mIsOnlyRotateLand) {
                            OrientationUtils.this.mScreenType = 1;
                            OrientationUtils.this.setRequestedOrientation(1);
                            if (OrientationUtils.this.mVideoPlayer.getFullscreenButton() != null) {
                                if (OrientationUtils.this.mVideoPlayer.isIfCurrentIsFullscreen()) {
                                    OrientationUtils.this.mVideoPlayer.getFullscreenButton().setImageResource(OrientationUtils.this.mVideoPlayer.getShrinkImageRes());
                                } else {
                                    OrientationUtils.this.mVideoPlayer.getFullscreenButton().setImageResource(OrientationUtils.this.mVideoPlayer.getEnlargeImageRes());
                                }
                            }
                            OrientationUtils.this.mIsLand = 0;
                        }
                        OrientationUtils.this.mClick = false;
                    }
                } else if (rotation >= OrientationUtils.this.mOrientationOption.getNormalLandAngleStart() && rotation <= OrientationUtils.this.mOrientationOption.getNormalLandAngleEnd()) {
                    if (OrientationUtils.this.mClick) {
                        if (OrientationUtils.this.mIsLand != 1 && !OrientationUtils.this.mClickPort) {
                            return;
                        }
                        OrientationUtils.this.mClickLand = true;
                        OrientationUtils.this.mClick = false;
                        OrientationUtils.this.mIsLand = 1;
                    } else if (OrientationUtils.this.mIsLand != 1) {
                        OrientationUtils.this.mScreenType = 0;
                        OrientationUtils.this.setRequestedOrientation(0);
                        if (OrientationUtils.this.mVideoPlayer.getFullscreenButton() != null) {
                            OrientationUtils.this.mVideoPlayer.getFullscreenButton().setImageResource(OrientationUtils.this.mVideoPlayer.getShrinkImageRes());
                        }
                        OrientationUtils.this.mIsLand = 1;
                        OrientationUtils.this.mClick = false;
                    }
                } else if (rotation > OrientationUtils.this.mOrientationOption.getReverseLandAngleStart() && rotation < OrientationUtils.this.mOrientationOption.getReverseLandAngleEnd()) {
                    if (OrientationUtils.this.mClick) {
                        if (OrientationUtils.this.mIsLand != 2 && !OrientationUtils.this.mClickPort) {
                            return;
                        }
                        OrientationUtils.this.mClickLand = true;
                        OrientationUtils.this.mClick = false;
                        OrientationUtils.this.mIsLand = 2;
                    } else if (OrientationUtils.this.mIsLand != 2) {
                        OrientationUtils.this.mScreenType = 0;
                        OrientationUtils.this.setRequestedOrientation(8);
                        if (OrientationUtils.this.mVideoPlayer.getFullscreenButton() != null) {
                            OrientationUtils.this.mVideoPlayer.getFullscreenButton().setImageResource(OrientationUtils.this.mVideoPlayer.getShrinkImageRes());
                        }
                        OrientationUtils.this.mIsLand = 2;
                        OrientationUtils.this.mClick = false;
                    }
                }
            }
        };
        this.mOrientationEventListener.enable();
    }

    private void initGravity(Activity activity) {
        if (this.mIsLand == 0) {
            int defaultRotation = activity.getWindowManager().getDefaultDisplay().getRotation();
            if (defaultRotation == 0) {
                this.mIsLand = 0;
                this.mScreenType = 1;
            } else if (defaultRotation == 3) {
                this.mIsLand = 2;
                this.mScreenType = 8;
            } else {
                this.mIsLand = 1;
                this.mScreenType = 0;
            }
        }
    }

    private void setRequestedOrientation(int requestedOrientation) {
        try {
            this.mActivity.setRequestedOrientation(requestedOrientation);
        }
        catch (IllegalStateException exception) {
            if (Build.VERSION.SDK_INT == 26 || Build.VERSION.SDK_INT == 27) {
                Debuger.printfError("OrientationUtils", exception);
            }
            exception.printStackTrace();
        }
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void resolveByClick() {
        if (this.mIsLand == 0 && this.mVideoPlayer != null && this.mVideoPlayer.isVerticalFullByVideoSize()) {
            return;
        }
        this.mClick = true;
        if (this.mIsLand == 0) {
            int request = this.mActivity.getRequestedOrientation();
            this.mScreenType = request == 8 ? 8 : 0;
            this.setRequestedOrientation(this.mScreenType);
            if (this.mVideoPlayer.getFullscreenButton() != null) {
                this.mVideoPlayer.getFullscreenButton().setImageResource(this.mVideoPlayer.getShrinkImageRes());
            }
            this.mIsLand = 1;
            this.mClickLand = false;
        } else {
            this.mScreenType = 1;
            this.setRequestedOrientation(1);
            if (this.mVideoPlayer.getFullscreenButton() != null) {
                if (this.mVideoPlayer.isIfCurrentIsFullscreen()) {
                    this.mVideoPlayer.getFullscreenButton().setImageResource(this.mVideoPlayer.getShrinkImageRes());
                } else {
                    this.mVideoPlayer.getFullscreenButton().setImageResource(this.mVideoPlayer.getEnlargeImageRes());
                }
            }
            this.mIsLand = 0;
            this.mClickPort = false;
        }
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public int backToProtVideo() {
        if (this.mIsLand > 0) {
            this.mClick = true;
            this.setRequestedOrientation(1);
            if (this.mVideoPlayer != null && this.mVideoPlayer.getFullscreenButton() != null) {
                this.mVideoPlayer.getFullscreenButton().setImageResource(this.mVideoPlayer.getEnlargeImageRes());
            }
            this.mIsLand = 0;
            this.mClickPort = false;
            return 500;
        }
        return 0;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean enable) {
        this.mEnable = enable;
        if (this.mEnable) {
            this.mOrientationEventListener.enable();
        } else {
            this.mOrientationEventListener.disable();
        }
    }

    public void releaseListener() {
        if (this.mOrientationEventListener != null) {
            this.mOrientationEventListener.disable();
        }
    }

    public boolean isClick() {
        return this.mClick;
    }

    public void setClick(boolean click) {
        this.mClick = click;
    }

    public boolean isClickLand() {
        return this.mClickLand;
    }

    public void setClickLand(boolean ClickLand) {
        this.mClickLand = ClickLand;
    }

    public int getIsLand() {
        return this.mIsLand;
    }

    public void setIsLand(int IsLand) {
        this.mIsLand = IsLand;
    }

    public boolean isClickPort() {
        return this.mClickPort;
    }

    public void setClickPort(boolean ClickPort) {
        this.mClickPort = ClickPort;
    }

    public int getScreenType() {
        return this.mScreenType;
    }

    public void setScreenType(int mScreenType) {
        this.mScreenType = mScreenType;
    }

    public boolean isRotateWithSystem() {
        return this.mRotateWithSystem;
    }

    public boolean isOnlyRotateLand() {
        return this.mIsOnlyRotateLand;
    }

    public void setOnlyRotateLand(boolean onlyRotateLand) {
        this.mIsOnlyRotateLand = onlyRotateLand;
    }

    public void setRotateWithSystem(boolean rotateWithSystem) {
        this.mRotateWithSystem = rotateWithSystem;
    }

    public boolean isPause() {
        return this.mIsPause;
    }

    public void setIsPause(boolean isPause) {
        this.mIsPause = isPause;
    }

    public OrientationOption getOrientationOption() {
        return this.mOrientationOption;
    }

    public void setOrientationOption(OrientationOption orientationOption) {
        this.mOrientationOption = orientationOption;
    }
}

