/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.shuyu.gsyvideoplayer.GSYRenderView;
import com.shuyu.gsyvideoplayer.GSYVideoGLView;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.effect.NoEffect;
import com.shuyu.gsyvideoplayer.render.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;

public abstract class GSYTextureRenderView
extends FrameLayout
implements TextureView.SurfaceTextureListener,
SurfaceHolder.Callback2,
GSYVideoGLView.onGSYSurfaceListener {
    protected Surface mSurface;
    protected GSYRenderView mTextureView;
    protected ViewGroup mTextureViewContainer;
    protected Bitmap mFullPauseBitmap;
    protected GSYVideoGLView.ShaderInterface mEffectFilter = new NoEffect();
    protected float[] mMatrixGL = null;
    protected int mRotate;
    protected GSYVideoGLViewBaseRender mRenderer;

    public GSYTextureRenderView(@NonNull Context context) {
        super(context);
    }

    public GSYTextureRenderView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GSYTextureRenderView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Surface newSurface = new Surface(surface);
        this.pauseLogic(newSurface, true);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        GSYVideoManager.instance().setDisplay(null);
        surface.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.releasePauseCover();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.pauseLogic(holder.getSurface(), false);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        GSYVideoManager.instance().setDisplay(null);
        holder.getSurface().release();
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
    }

    @Override
    public void onSurfaceAvailable(Surface surface) {
        this.pauseLogic(surface, false);
    }

    protected void pauseLogic(Surface surface, boolean pauseLogic) {
        this.mSurface = surface;
        if (pauseLogic) {
            this.showPauseCover();
        }
        GSYVideoManager.instance().setDisplay(this.mSurface);
    }

    protected void addTextureView() {
        this.mTextureView = new GSYRenderView();
        if (GSYVideoType.getRenderType() == 1) {
            this.mTextureView.addSurfaceView(this.getContext(), this.mTextureViewContainer, this.mRotate, this);
            return;
        }
        if (GSYVideoType.getRenderType() == 2) {
            this.mTextureView.addGLView(this.getContext(), this.mTextureViewContainer, this.mRotate, this, this.mEffectFilter, this.mMatrixGL, this.mRenderer);
            return;
        }
        this.mTextureView.addTextureView(this.getContext(), this.mTextureViewContainer, this.mRotate, this);
    }

    protected int getTextureParams() {
        boolean typeChanged = GSYVideoType.getShowType() != 0;
        return typeChanged ? -2 : -1;
    }

    protected void changeTextureViewShowType() {
        int params = this.getTextureParams();
        ViewGroup.LayoutParams layoutParams = this.mTextureView.getLayoutParams();
        layoutParams.width = params;
        layoutParams.height = params;
        this.mTextureView.setLayoutParams(layoutParams);
    }

    protected void initCover() {
        this.mFullPauseBitmap = this.mTextureView.initCover();
    }

    protected void setSmallVideoTextureView(View.OnTouchListener onTouchListener) {
        this.mTextureViewContainer.setOnTouchListener(onTouchListener);
        this.mTextureViewContainer.setOnClickListener(null);
        this.setSmallVideoTextureView();
    }

    protected GSYVideoGLView getGSYVideoGLSView() {
        if (this.mTextureView.getShowView() instanceof GSYVideoGLView) {
            return (GSYVideoGLView)this.mTextureView.getShowView();
        }
        return null;
    }

    protected abstract void showPauseCover();

    protected abstract void releasePauseCover();

    protected abstract void setSmallVideoTextureView();

    public GSYVideoGLView.ShaderInterface getEffectFilter() {
        return this.mEffectFilter;
    }

    public GSYRenderView getRenderProxy() {
        return this.mTextureView;
    }

    public void setEffectFilter(GSYVideoGLView.ShaderInterface effectFilter) {
        this.mEffectFilter = effectFilter;
        if (this.mTextureView != null && this.mTextureView.getShowView() instanceof GSYVideoGLView) {
            GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mTextureView.getShowView();
            gsyVideoGLView.setEffect(effectFilter);
        }
    }

    public void setMatrixGL(float[] matrixGL) {
        this.mMatrixGL = matrixGL;
        if (this.mTextureView != null && this.mTextureView.getShowView() instanceof GSYVideoGLView && this.mMatrixGL != null && this.mMatrixGL.length == 16) {
            GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mTextureView.getShowView();
            gsyVideoGLView.setMVPMatrix(this.mMatrixGL);
        }
    }

    public void setCustomGLRenderer(GSYVideoGLViewBaseRender renderer) {
        this.mRenderer = renderer;
        if (this.mTextureView != null && this.mRenderer != null && this.mTextureView.getShowView() instanceof GSYVideoGLView) {
            GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mTextureView.getShowView();
            gsyVideoGLView.setCustomRenderer(this.mRenderer);
        }
    }
}

