/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.net.ConnectivityManagerCompat;

public class NetInfoModule {
    private static final String CONNECTION_TYPE_NONE = "NONE";
    private static final String CONNECTION_TYPE_UNKNOWN = "UNKNOWN";
    private static final String MISSING_PERMISSION_MESSAGE = "To use NetInfo on Android, add the following to your AndroidManifest.xml:\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />";
    private static final String ERROR_MISSING_PERMISSION = "E_MISSING_PERMISSION";
    private final ConnectivityManager mConnectivityManager;
    private final ConnectivityBroadcastReceiver mConnectivityBroadcastReceiver;
    private NetChangeListener mNetChangeListener;
    private String mConnectivity = "";
    private Context mContext;
    private boolean mNoNetworkPermission = false;

    public NetInfoModule(Context context, NetChangeListener netChangeListener) {
        this.mContext = context;
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.mConnectivityBroadcastReceiver = new ConnectivityBroadcastReceiver();
        this.mNetChangeListener = netChangeListener;
    }

    public void onHostResume() {
        this.registerReceiver();
    }

    public void onHostPause() {
        this.unregisterReceiver();
    }

    public void onHostDestroy() {
    }

    public String getCurrentConnectivity() {
        if (this.mNoNetworkPermission) {
            return ERROR_MISSING_PERMISSION;
        }
        return this.mConnectivity;
    }

    public boolean isConnectionMetered() {
        if (this.mNoNetworkPermission) {
            return false;
        }
        return ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)this.mConnectivityManager);
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver((BroadcastReceiver)this.mConnectivityBroadcastReceiver, filter);
        this.mConnectivityBroadcastReceiver.setRegistered(true);
    }

    private void unregisterReceiver() {
        if (this.mConnectivityBroadcastReceiver.isRegistered()) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mConnectivityBroadcastReceiver);
            this.mConnectivityBroadcastReceiver.setRegistered(false);
        }
    }

    private void updateAndSendConnectionType() {
        String currentConnectivity = this.getCurrentConnectionType();
        if (!currentConnectivity.equalsIgnoreCase(this.mConnectivity)) {
            this.mConnectivity = currentConnectivity;
            this.sendConnectivityChangedEvent();
        }
    }

    public String getCurrentConnectionType() {
        try {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                return CONNECTION_TYPE_NONE;
            }
            if (ConnectivityManager.isNetworkTypeValid((int)networkInfo.getType())) {
                return networkInfo.getTypeName().toUpperCase();
            }
            return CONNECTION_TYPE_UNKNOWN;
        }
        catch (SecurityException e) {
            this.mNoNetworkPermission = true;
            return CONNECTION_TYPE_UNKNOWN;
        }
    }

    private void sendConnectivityChangedEvent() {
        if (this.mNetChangeListener != null) {
            this.mNetChangeListener.changed(this.mConnectivity);
        }
    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private ConnectivityBroadcastReceiver() {
        }

        public void setRegistered(boolean registered) {
            this.isRegistered = registered;
        }

        public boolean isRegistered() {
            return this.isRegistered;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                NetInfoModule.this.updateAndSendConnectionType();
            }
        }
    }

    public static interface NetChangeListener {
        public void changed(String var1);
    }
}

