/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotSaveListener;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.view.GSYSurfaceView;
import com.shuyu.gsyvideoplayer.render.view.GSYTextureView;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;
import com.shuyu.gsyvideoplayer.render.view.IGSYRenderView;
import com.shuyu.gsyvideoplayer.render.view.listener.IGSYSurfaceListener;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;
import java.io.File;

public class GSYRenderView {
    protected IGSYRenderView mShowView;

    public void requestLayout() {
        if (this.mShowView != null) {
            this.mShowView.getRenderView().requestLayout();
        }
    }

    public float getRotation() {
        return this.mShowView.getRenderView().getRotation();
    }

    public void setRotation(float rotation) {
        if (this.mShowView != null) {
            this.mShowView.getRenderView().setRotation(rotation);
        }
    }

    public void invalidate() {
        if (this.mShowView != null) {
            this.mShowView.getRenderView().invalidate();
        }
    }

    public int getWidth() {
        return this.mShowView != null ? this.mShowView.getRenderView().getWidth() : 0;
    }

    public int getHeight() {
        return this.mShowView != null ? this.mShowView.getRenderView().getHeight() : 0;
    }

    public View getShowView() {
        if (this.mShowView != null) {
            return this.mShowView.getRenderView();
        }
        return null;
    }

    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mShowView.getRenderView().getLayoutParams();
    }

    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (this.mShowView != null) {
            this.mShowView.getRenderView().setLayoutParams(layoutParams);
        }
    }

    public void addView(Context context, ViewGroup textureViewContainer, int rotate, IGSYSurfaceListener gsySurfaceListener, MeasureHelper.MeasureFormVideoParamsListener videoParamsListener, GSYVideoGLView.ShaderInterface effect, float[] transform, GSYVideoGLViewBaseRender customRender, int mode) {
        this.mShowView = GSYVideoType.getRenderType() == 1 ? GSYSurfaceView.addSurfaceView(context, textureViewContainer, rotate, gsySurfaceListener, videoParamsListener) : (GSYVideoType.getRenderType() == 2 ? GSYVideoGLView.addGLView(context, textureViewContainer, rotate, gsySurfaceListener, videoParamsListener, effect, transform, customRender, mode) : GSYTextureView.addTextureView(context, textureViewContainer, rotate, gsySurfaceListener, videoParamsListener));
    }

    public void setTransform(Matrix transform) {
        if (this.mShowView != null) {
            this.mShowView.setRenderTransform(transform);
        }
    }

    public Bitmap initCover() {
        if (this.mShowView != null) {
            return this.mShowView.initCover();
        }
        return null;
    }

    public Bitmap initCoverHigh() {
        if (this.mShowView != null) {
            return this.mShowView.initCoverHigh();
        }
        return null;
    }

    public void taskShotPic(GSYVideoShotListener gsyVideoShotListener) {
        this.taskShotPic(gsyVideoShotListener, false);
    }

    public void taskShotPic(GSYVideoShotListener gsyVideoShotListener, boolean shotHigh) {
        if (this.mShowView != null) {
            this.mShowView.taskShotPic(gsyVideoShotListener, shotHigh);
        }
    }

    public void saveFrame(File file, GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        this.saveFrame(file, false, gsyVideoShotSaveListener);
    }

    public void saveFrame(File file, boolean high, GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        if (this.mShowView != null) {
            this.mShowView.saveFrame(file, high, gsyVideoShotSaveListener);
        }
    }

    public void onResume() {
        if (this.mShowView != null) {
            this.mShowView.onRenderResume();
        }
    }

    public void onPause() {
        if (this.mShowView != null) {
            this.mShowView.onRenderPause();
        }
    }

    public void releaseAll() {
        if (this.mShowView != null) {
            this.mShowView.releaseRenderAll();
        }
    }

    public void setGLRenderMode(int mode) {
        if (this.mShowView != null) {
            this.mShowView.setRenderMode(mode);
        }
    }

    public void setGLRenderer(GSYVideoGLViewBaseRender renderer) {
        if (this.mShowView != null) {
            this.mShowView.setGLRenderer(renderer);
        }
    }

    public void setMatrixGL(float[] matrixGL) {
        if (this.mShowView != null) {
            this.mShowView.setGLMVPMatrix(matrixGL);
        }
    }

    public void setEffectFilter(GSYVideoGLView.ShaderInterface effectFilter) {
        if (this.mShowView != null) {
            this.mShowView.setGLEffectFilter(effectFilter);
        }
    }

    public static void addToParent(ViewGroup textureViewContainer, View render) {
        int params = GSYRenderView.getTextureParams();
        if (textureViewContainer instanceof RelativeLayout) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(params, params);
            layoutParams.addRule(13);
            textureViewContainer.addView(render, (ViewGroup.LayoutParams)layoutParams);
        } else if (textureViewContainer instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(params, params);
            layoutParams.gravity = 17;
            textureViewContainer.addView(render, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static int getTextureParams() {
        boolean typeChanged = GSYVideoType.getShowType() != 0;
        return typeChanged ? -2 : -1;
    }
}

