/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render.glrender;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.view.Surface;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.render.effect.NoEffect;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@SuppressLint(value={"ViewConstructor"})
public class GSYVideoGLViewSimpleRender
extends GSYVideoGLViewBaseRender {
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
    private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
    private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
    protected static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    private final float[] mTriangleVerticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private final String mVertexShader = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
    private int mProgram;
    private int[] mTextureID = new int[2];
    private int muMVPMatrixHandle;
    private int muSTMatrixHandle;
    private int maPositionHandle;
    private int maTextureHandle;
    private boolean mUpdateSurface = false;
    private boolean mTakeShotPic = false;
    private FloatBuffer mTriangleVertices;
    private SurfaceTexture mSurface;
    private GSYVideoShotListener mGSYVideoShotListener;
    private GSYVideoGLView.ShaderInterface mEffect = new NoEffect();

    public GSYVideoGLViewSimpleRender() {
        this.mTriangleVertices = ByteBuffer.allocateDirect(this.mTriangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mTriangleVertices.put(this.mTriangleVerticesData).position(0);
        Matrix.setIdentityM((float[])this.mSTMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 glUnused) {
        GSYVideoGLViewSimpleRender gSYVideoGLViewSimpleRender = this;
        synchronized (gSYVideoGLViewSimpleRender) {
            if (this.mUpdateSurface) {
                this.mSurface.updateTexImage();
                this.mSurface.getTransformMatrix(this.mSTMatrix);
                this.mUpdateSurface = false;
            }
        }
        this.initDrawFrame();
        this.bindDrawFrameTexture();
        this.initPointerAndDraw();
        this.takeBitmap(glUnused);
        GLES20.glFinish();
    }

    public void onSurfaceChanged(GL10 glUnused, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    public void onSurfaceCreated(GL10 glUnused, EGLConfig config) {
        this.mProgram = this.createProgram(this.getVertexShader(), this.getFragmentShader());
        if (this.mProgram == 0) {
            return;
        }
        this.maPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        this.checkGlError("glGetAttribLocation aPosition");
        if (this.maPositionHandle == -1) {
            throw new RuntimeException("Could not get attrib location for aPosition");
        }
        this.maTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTextureCoord");
        this.checkGlError("glGetAttribLocation aTextureCoord");
        if (this.maTextureHandle == -1) {
            throw new RuntimeException("Could not get attrib location for aTextureCoord");
        }
        this.muMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMVPMatrix");
        this.checkGlError("glGetUniformLocation uMVPMatrix");
        if (this.muMVPMatrixHandle == -1) {
            throw new RuntimeException("Could not get attrib location for uMVPMatrix");
        }
        this.muSTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uSTMatrix");
        this.checkGlError("glGetUniformLocation uSTMatrix");
        if (this.muSTMatrixHandle == -1) {
            throw new RuntimeException("Could not get attrib location for uSTMatrix");
        }
        GLES20.glGenTextures((int)2, (int[])this.mTextureID, (int)0);
        GLES20.glBindTexture((int)36197, (int)this.mTextureID[0]);
        this.checkGlError("glBindTexture mTextureID");
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        this.mSurface = new SurfaceTexture(this.mTextureID[0]);
        this.mSurface.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        Surface surface = new Surface(this.mSurface);
        this.sendSurfaceForPlayer(surface);
    }

    public synchronized void onFrameAvailable(SurfaceTexture surface) {
        this.mUpdateSurface = true;
    }

    @Override
    public void releaseAll() {
    }

    @Override
    public void setEffect(GSYVideoGLView.ShaderInterface shaderEffect) {
        if (shaderEffect != null) {
            this.mEffect = shaderEffect;
        }
        this.mChangeProgram = true;
        this.mChangeProgramSupportError = true;
    }

    @Override
    public GSYVideoGLView.ShaderInterface getEffect() {
        return this.mEffect;
    }

    protected void initDrawFrame() {
        if (this.mChangeProgram) {
            this.mProgram = this.createProgram(this.getVertexShader(), this.getFragmentShader());
            this.mChangeProgram = false;
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.mProgram);
        this.checkGlError("glUseProgram");
    }

    protected void bindDrawFrameTexture() {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.mTextureID[0]);
    }

    protected void takeBitmap(GL10 glUnused) {
        if (this.mTakeShotPic) {
            this.mTakeShotPic = false;
            if (this.mGSYVideoShotListener != null) {
                Bitmap bitmap = this.createBitmapFromGLSurface(0, 0, this.mSurfaceView.getWidth(), this.mSurfaceView.getHeight(), glUnused);
                this.mGSYVideoShotListener.getBitmap(bitmap);
            }
        }
    }

    protected void initPointerAndDraw() {
        this.mTriangleVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
        this.checkGlError("glVertexAttribPointer maPosition");
        GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
        this.checkGlError("glEnableVertexAttribArray maPositionHandle");
        this.mTriangleVertices.position(3);
        GLES20.glVertexAttribPointer((int)this.maTextureHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
        this.checkGlError("glVertexAttribPointer maTextureHandle");
        GLES20.glEnableVertexAttribArray((int)this.maTextureHandle);
        this.checkGlError("glEnableVertexAttribArray maTextureHandle");
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muSTMatrixHandle, (int)1, (boolean)false, (float[])this.mSTMatrix, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.checkGlError("glDrawArrays");
    }

    public int getProgram() {
        return this.mProgram;
    }

    public int getMuMVPMatrixHandle() {
        return this.muMVPMatrixHandle;
    }

    public int getMuSTMatrixHandle() {
        return this.muSTMatrixHandle;
    }

    public int getMaPositionHandle() {
        return this.maPositionHandle;
    }

    public int getMaTextureHandle() {
        return this.maTextureHandle;
    }

    public float[] getSTMatrix() {
        return this.mSTMatrix;
    }

    public int[] getTextureID() {
        return this.mTextureID;
    }

    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
    }

    protected String getFragmentShader() {
        return this.mEffect.getShader(this.mSurfaceView);
    }

    @Override
    public void takeShotPic() {
        this.mTakeShotPic = true;
    }

    @Override
    public void setGSYVideoShotListener(GSYVideoShotListener listener, boolean high) {
        this.mGSYVideoShotListener = listener;
        this.mHighShot = high;
    }
}

