/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.model.GSYVideoModel;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.video.ListGSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GSYSampleADVideoPlayer
extends ListGSYVideoPlayer {
    protected View mJumpAd;
    protected ViewGroup mWidgetContainer;
    protected TextView mADTime;
    protected boolean isAdModel = false;
    protected boolean isFirstPrepared = false;

    public GSYSampleADVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    public GSYSampleADVideoPlayer(Context context) {
        super(context);
    }

    public GSYSampleADVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.mJumpAd = this.findViewById(R.id.jump_ad);
        this.mADTime = (TextView)this.findViewById(R.id.ad_time);
        this.mWidgetContainer = (ViewGroup)this.findViewById(R.id.widget_container);
        if (this.mJumpAd != null) {
            this.mJumpAd.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GSYSampleADVideoPlayer.this.playNext();
                }
            });
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.video_layout_sample_ad;
    }

    @Override
    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position) {
        return this.setUp(url, cacheWithPlay, position, null);
    }

    @Override
    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, File cachePath) {
        return this.setUp(url, cacheWithPlay, position, cachePath, new HashMap<String, String>());
    }

    @Override
    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, File cachePath, Map<String, String> mapHeadData) {
        return this.setUp(url, cacheWithPlay, position, cachePath, mapHeadData, true);
    }

    @Override
    protected boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, File cachePath, Map<String, String> mapHeadData, boolean changeState) {
        GSYVideoModel gsyVideoModel = url.get(position);
        if (gsyVideoModel instanceof GSYADVideoModel) {
            GSYADVideoModel gsyadVideoModel = (GSYADVideoModel)gsyVideoModel;
            if (gsyadVideoModel.isSkip() && position < url.size() - 1) {
                return this.setUp(url, cacheWithPlay, position + 1, cachePath, mapHeadData, changeState);
            }
            this.isAdModel = gsyadVideoModel.getType() == GSYADVideoModel.TYPE_AD;
        }
        this.changeAdUIState();
        return super.setUp(url, cacheWithPlay, position, cachePath, mapHeadData, changeState);
    }

    @Override
    public void onPrepared() {
        super.onPrepared();
        this.isFirstPrepared = true;
        this.changeAdUIState();
    }

    @Override
    protected void updateStartImage() {
        if (this.mStartButton != null && this.mStartButton instanceof ImageView) {
            ImageView imageView = (ImageView)this.mStartButton;
            if (this.mCurrentState == 2) {
                imageView.setImageResource(R.drawable.video_click_pause_selector);
            } else if (this.mCurrentState == 7) {
                imageView.setImageResource(R.drawable.video_click_play_selector);
            } else {
                imageView.setImageResource(R.drawable.video_click_play_selector);
            }
        }
    }

    @Override
    protected void touchDoubleUp() {
        if (this.isAdModel) {
            return;
        }
        super.touchDoubleUp();
    }

    @Override
    protected void touchSurfaceMove(float deltaX, float deltaY, float y) {
        if (this.mChangePosition && this.isAdModel) {
            return;
        }
        super.touchSurfaceMove(deltaX, deltaY, y);
    }

    @Override
    protected void touchSurfaceMoveFullLogic(float absDeltaX, float absDeltaY) {
        if (absDeltaX > (float)this.mThreshold || absDeltaY > (float)this.mThreshold) {
            int screenWidth = CommonUtil.getScreenWidth(this.getContext());
            if (this.isAdModel && absDeltaX >= (float)this.mThreshold && Math.abs((float)screenWidth - this.mDownX) > (float)this.mSeekEndOffset) {
                this.mChangePosition = true;
                this.mDownPosition = this.getCurrentPositionWhenPlaying();
            } else {
                super.touchSurfaceMoveFullLogic(absDeltaX, absDeltaY);
            }
        }
    }

    @Override
    protected void touchSurfaceUp() {
        if (this.mChangePosition && this.isAdModel) {
            return;
        }
        super.touchSurfaceUp();
    }

    @Override
    protected void hideAllWidget() {
        if (this.isFirstPrepared && this.isAdModel) {
            return;
        }
        super.hideAllWidget();
    }

    @Override
    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        super.setProgressAndTime(progress, secProgress, currentTime, totalTime);
        if (this.mADTime != null && currentTime > 0) {
            int totalSeconds = totalTime / 1000;
            int currentSeconds = currentTime / 1000;
            this.mADTime.setText((CharSequence)("" + (totalSeconds - currentSeconds)));
        }
    }

    @Override
    protected void cloneParams(GSYBaseVideoPlayer from, GSYBaseVideoPlayer to) {
        super.cloneParams(from, to);
        GSYSampleADVideoPlayer sf = (GSYSampleADVideoPlayer)from;
        GSYSampleADVideoPlayer st = (GSYSampleADVideoPlayer)to;
        st.isAdModel = sf.isAdModel;
        st.isFirstPrepared = sf.isFirstPrepared;
        st.changeAdUIState();
    }

    protected void changeAdUIState() {
        if (this.mJumpAd != null) {
            this.mJumpAd.setVisibility(this.isFirstPrepared && this.isAdModel ? 0 : 8);
        }
        if (this.mADTime != null) {
            this.mADTime.setVisibility(this.isFirstPrepared && this.isAdModel ? 0 : 8);
        }
        if (this.mWidgetContainer != null) {
            this.mWidgetContainer.setVisibility(this.isFirstPrepared && this.isAdModel ? 8 : 0);
        }
        if (this.mBottomContainer != null) {
            int color2 = this.isFirstPrepared && this.isAdModel ? 0 : this.getContext().getResources().getColor(R.color.bottom_container_bg);
            this.mBottomContainer.setBackgroundColor(color2);
        }
        if (this.mCurrentTimeTextView != null) {
            this.mCurrentTimeTextView.setVisibility(this.isFirstPrepared && this.isAdModel ? 4 : 0);
        }
        if (this.mTotalTimeTextView != null) {
            this.mTotalTimeTextView.setVisibility(this.isFirstPrepared && this.isAdModel ? 4 : 0);
        }
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(this.isFirstPrepared && this.isAdModel ? 4 : 0);
            this.mProgressBar.setEnabled(!this.isFirstPrepared || !this.isAdModel);
        }
    }

    public boolean setAdUp(ArrayList<GSYADVideoModel> url, boolean cacheWithPlay, int position) {
        return this.setUp((ArrayList)url.clone(), cacheWithPlay, position);
    }

    public boolean setAdUp(ArrayList<GSYADVideoModel> url, boolean cacheWithPlay, int position, File cachePath) {
        return this.setUp((ArrayList)url.clone(), cacheWithPlay, position, cachePath);
    }

    public boolean setAdUp(ArrayList<GSYADVideoModel> url, boolean cacheWithPlay, int position, File cachePath, Map<String, String> mapHeadData) {
        return this.setUp((ArrayList)url.clone(), cacheWithPlay, position, cachePath, mapHeadData);
    }

    public static class GSYADVideoModel
    extends GSYVideoModel {
        public static int TYPE_NORMAL = 0;
        public static int TYPE_AD = 1;
        private int mType = TYPE_NORMAL;
        private boolean isSkip;

        public GSYADVideoModel(String url, String title, int type) {
            this(url, title, type, false);
        }

        public GSYADVideoModel(String url, String title, int type, boolean isSkip) {
            super(url, title);
            this.mType = type;
            this.isSkip = isSkip;
        }

        public int getType() {
            return this.mType;
        }

        public void setType(int type) {
            this.mType = type;
        }

        public boolean isSkip() {
            return this.isSkip;
        }

        public void setSkip(boolean skip) {
            this.isSkip = skip;
        }
    }
}

