/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.shuyu.gsyvideoplayer.builder.GSYVideoOptionBuilder;
import com.shuyu.gsyvideoplayer.listener.GSYVideoProgressListener;
import com.shuyu.gsyvideoplayer.listener.LockClickListener;
import com.shuyu.gsyvideoplayer.listener.VideoAllCallBack;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.OrientationUtils;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoPlayer;
import com.transitionseverywhere.TransitionManager;
import java.io.File;
import java.util.Map;

public class GSYVideoHelper {
    private String TAG = "NULL";
    private StandardGSYVideoPlayer mGsyVideoPlayer;
    private ViewGroup mFullViewContainer;
    private ViewGroup mWindowViewContainer;
    private ViewGroup mParent;
    private ViewGroup.LayoutParams mNormalParams;
    private OrientationUtils mOrientationUtils;
    private GSYVideoHelperBuilder mVideoOptionBuilder;
    private Context mContext;
    private int mPlayPosition = -1;
    private int mSystemUiVisibility;
    private boolean isFull;
    private boolean isSmall;
    private int[] mNormalItemRect;
    private int[] mNormalItemSize;
    private Handler mHandler = new Handler();

    public GSYVideoHelper(Context context) {
        this(context, new StandardGSYVideoPlayer(context));
    }

    public GSYVideoHelper(Context context, StandardGSYVideoPlayer player) {
        this.mGsyVideoPlayer = player;
        this.mContext = context;
        this.mWindowViewContainer = (ViewGroup)CommonUtil.scanForActivity(context).findViewById(0x1020002);
    }

    private void resolveToFull() {
        this.mSystemUiVisibility = ((Activity)this.mContext).getWindow().getDecorView().getSystemUiVisibility();
        CommonUtil.hideSupportActionBar(this.mContext, this.mVideoOptionBuilder.isHideActionBar(), this.mVideoOptionBuilder.isHideStatusBar());
        if (this.mVideoOptionBuilder.isHideKey()) {
            CommonUtil.hideNavKey(this.mContext);
        }
        this.isFull = true;
        ViewGroup viewGroup = (ViewGroup)this.mGsyVideoPlayer.getParent();
        this.mNormalParams = this.mGsyVideoPlayer.getLayoutParams();
        if (viewGroup != null) {
            this.mParent = viewGroup;
            viewGroup.removeView((View)this.mGsyVideoPlayer);
        }
        this.mGsyVideoPlayer.setIfCurrentIsFullscreen(true);
        this.mGsyVideoPlayer.getFullscreenButton().setImageResource(this.mGsyVideoPlayer.getShrinkImageRes());
        this.mGsyVideoPlayer.getBackButton().setVisibility(0);
        this.mOrientationUtils = new OrientationUtils((Activity)this.mContext, this.mGsyVideoPlayer);
        this.mOrientationUtils.setEnable(this.mVideoOptionBuilder.isRotateViewAuto());
        this.mGsyVideoPlayer.getBackButton().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GSYVideoHelper.this.resolveMaterialToNormal(GSYVideoHelper.this.mGsyVideoPlayer);
            }
        });
        if (this.mVideoOptionBuilder.isShowFullAnimation()) {
            if (this.mFullViewContainer instanceof FrameLayout) {
                this.resolveMaterialAnimation();
            } else {
                this.resolveFullAdd();
            }
        } else {
            this.resolveFullAdd();
        }
    }

    private void resolveFullAdd() {
        if (this.mVideoOptionBuilder.isShowFullAnimation() && this.mFullViewContainer != null) {
            this.mFullViewContainer.setBackgroundColor(-16777216);
        }
        this.resolveChangeFirstLogic(0);
        if (this.mFullViewContainer != null) {
            this.mFullViewContainer.addView((View)this.mGsyVideoPlayer);
        } else {
            this.mWindowViewContainer.addView((View)this.mGsyVideoPlayer);
        }
    }

    private void resolveMaterialAnimation() {
        this.mNormalItemRect = new int[2];
        this.mNormalItemSize = new int[2];
        this.saveLocationStatus(this.mContext, this.mVideoOptionBuilder.isHideActionBar(), this.mVideoOptionBuilder.isHideStatusBar());
        FrameLayout.LayoutParams lpParent = new FrameLayout.LayoutParams(-1, -1);
        FrameLayout frameLayout = new FrameLayout(this.mContext);
        frameLayout.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.mNormalItemSize[0], this.mNormalItemSize[1]);
        lp.setMargins(this.mNormalItemRect[0], this.mNormalItemRect[1], 0, 0);
        frameLayout.addView((View)this.mGsyVideoPlayer, (ViewGroup.LayoutParams)lp);
        if (this.mFullViewContainer != null) {
            this.mFullViewContainer.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
        } else {
            this.mWindowViewContainer.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoHelper.this.mFullViewContainer != null) {
                    TransitionManager.beginDelayedTransition((ViewGroup)GSYVideoHelper.this.mFullViewContainer);
                } else {
                    TransitionManager.beginDelayedTransition((ViewGroup)GSYVideoHelper.this.mWindowViewContainer);
                }
                GSYVideoHelper.this.resolveMaterialFullVideoShow(GSYVideoHelper.this.mGsyVideoPlayer);
                GSYVideoHelper.this.resolveChangeFirstLogic(600);
            }
        }, 300L);
    }

    private void resolveMaterialFullVideoShow(GSYBaseVideoPlayer gsyVideoPlayer) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)gsyVideoPlayer.getLayoutParams();
        lp.setMargins(0, 0, 0, 0);
        lp.height = -1;
        lp.width = -1;
        lp.gravity = 17;
        gsyVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
        gsyVideoPlayer.setIfCurrentIsFullscreen(true);
    }

    private void resolveToNormal() {
        int delay = this.mOrientationUtils.backToProtVideo();
        if (!this.mVideoOptionBuilder.isShowFullAnimation()) {
            delay = 0;
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                GSYVideoHelper.this.isFull = false;
                GSYVideoHelper.this.removeWindowContainer();
                if (GSYVideoHelper.this.mFullViewContainer != null) {
                    GSYVideoHelper.this.mFullViewContainer.removeAllViews();
                }
                if (GSYVideoHelper.this.mGsyVideoPlayer.getParent() != null) {
                    ((ViewGroup)GSYVideoHelper.this.mGsyVideoPlayer.getParent()).removeView((View)GSYVideoHelper.this.mGsyVideoPlayer);
                }
                GSYVideoHelper.this.mOrientationUtils.setEnable(false);
                GSYVideoHelper.this.mGsyVideoPlayer.setIfCurrentIsFullscreen(false);
                if (GSYVideoHelper.this.mFullViewContainer != null) {
                    GSYVideoHelper.this.mFullViewContainer.setBackgroundColor(0);
                }
                GSYVideoHelper.this.mParent.addView((View)GSYVideoHelper.this.mGsyVideoPlayer, GSYVideoHelper.this.mNormalParams);
                GSYVideoHelper.this.mGsyVideoPlayer.getFullscreenButton().setImageResource(GSYVideoHelper.this.mGsyVideoPlayer.getEnlargeImageRes());
                GSYVideoHelper.this.mGsyVideoPlayer.getBackButton().setVisibility(8);
                GSYVideoHelper.this.mGsyVideoPlayer.setIfCurrentIsFullscreen(false);
                GSYVideoHelper.this.mGsyVideoPlayer.restartTimerTask();
                if (GSYVideoHelper.this.mVideoOptionBuilder.getVideoAllCallBack() != null) {
                    Debuger.printfLog("onQuitFullscreen");
                    GSYVideoHelper.this.mVideoOptionBuilder.getVideoAllCallBack().onQuitFullscreen(GSYVideoHelper.this.mVideoOptionBuilder.getUrl(), GSYVideoHelper.this.mVideoOptionBuilder.getVideoTitle(), GSYVideoHelper.this.mGsyVideoPlayer);
                }
                if (GSYVideoHelper.this.mVideoOptionBuilder.isHideKey()) {
                    CommonUtil.showNavKey(GSYVideoHelper.this.mContext, GSYVideoHelper.this.mSystemUiVisibility);
                }
                CommonUtil.showSupportActionBar(GSYVideoHelper.this.mContext, GSYVideoHelper.this.mVideoOptionBuilder.isHideActionBar(), GSYVideoHelper.this.mVideoOptionBuilder.isHideStatusBar());
            }
        }, (long)delay);
    }

    private void resolveMaterialToNormal(final GSYVideoPlayer gsyVideoPlayer) {
        if (this.mVideoOptionBuilder.isShowFullAnimation() && this.mFullViewContainer instanceof FrameLayout) {
            int delay = this.mOrientationUtils.backToProtVideo();
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    TransitionManager.beginDelayedTransition((ViewGroup)GSYVideoHelper.this.mFullViewContainer);
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)gsyVideoPlayer.getLayoutParams();
                    lp.setMargins(GSYVideoHelper.this.mNormalItemRect[0], GSYVideoHelper.this.mNormalItemRect[1], 0, 0);
                    lp.width = GSYVideoHelper.this.mNormalItemSize[0];
                    lp.height = GSYVideoHelper.this.mNormalItemSize[1];
                    lp.gravity = 0;
                    gsyVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
                    GSYVideoHelper.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            GSYVideoHelper.this.resolveToNormal();
                        }
                    }, 400L);
                }
            }, (long)delay);
        } else {
            this.resolveToNormal();
        }
    }

    private void resolveChangeFirstLogic(int time) {
        if (this.mVideoOptionBuilder.isLockLand()) {
            if (time > 0) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (GSYVideoHelper.this.mOrientationUtils.getIsLand() != 1) {
                            if (GSYVideoHelper.this.mFullViewContainer != null) {
                                GSYVideoHelper.this.mFullViewContainer.setBackgroundColor(-16777216);
                            }
                            GSYVideoHelper.this.mOrientationUtils.resolveByClick();
                        }
                    }
                }, (long)time);
            } else if (this.mOrientationUtils.getIsLand() != 1) {
                if (this.mFullViewContainer != null) {
                    this.mFullViewContainer.setBackgroundColor(-16777216);
                }
                this.mOrientationUtils.resolveByClick();
            }
        }
        this.mGsyVideoPlayer.setIfCurrentIsFullscreen(true);
        this.mGsyVideoPlayer.restartTimerTask();
        if (this.mVideoOptionBuilder.getVideoAllCallBack() != null) {
            Debuger.printfLog("onEnterFullscreen");
            this.mVideoOptionBuilder.getVideoAllCallBack().onEnterFullscreen(this.mVideoOptionBuilder.getUrl(), this.mVideoOptionBuilder.getVideoTitle(), this.mGsyVideoPlayer);
        }
    }

    private void saveLocationStatus(Context context, boolean statusBar, boolean actionBar) {
        this.mParent.getLocationOnScreen(this.mNormalItemRect);
        int statusBarH = CommonUtil.getStatusBarHeight(context);
        int actionBerH = CommonUtil.getActionBarHeight((Activity)context);
        if (statusBar) {
            this.mNormalItemRect[1] = this.mNormalItemRect[1] - statusBarH;
        }
        if (actionBar) {
            this.mNormalItemRect[1] = this.mNormalItemRect[1] - actionBerH;
        }
        this.mNormalItemSize[0] = this.mParent.getWidth();
        this.mNormalItemSize[1] = this.mParent.getHeight();
    }

    private boolean isPlayView(int position, String tag) {
        return this.mPlayPosition == position && this.TAG.equals(tag);
    }

    private boolean isCurrentViewPlaying(int position, String tag) {
        return this.isPlayView(position, tag);
    }

    private boolean removeWindowContainer() {
        if (this.mWindowViewContainer != null && this.mWindowViewContainer.indexOfChild((View)this.mGsyVideoPlayer) != -1) {
            this.mWindowViewContainer.removeView((View)this.mGsyVideoPlayer);
            return true;
        }
        return false;
    }

    public void addVideoPlayer(int position, View imgView, String tag, ViewGroup container, View playBtn) {
        container.removeAllViews();
        if (this.isCurrentViewPlaying(position, tag)) {
            if (!this.isFull) {
                ViewGroup viewGroup = (ViewGroup)this.mGsyVideoPlayer.getParent();
                if (viewGroup != null) {
                    viewGroup.removeAllViews();
                }
                container.addView((View)this.mGsyVideoPlayer);
                playBtn.setVisibility(4);
            }
        } else {
            playBtn.setVisibility(0);
            container.removeAllViews();
            container.addView(imgView);
        }
    }

    public void setPlayPositionAndTag(int playPosition, String tag) {
        this.mPlayPosition = playPosition;
        this.TAG = tag;
    }

    public void startPlay() {
        if (this.isSmall()) {
            this.smallVideoToNormal();
        }
        this.mGsyVideoPlayer.release();
        if (this.mVideoOptionBuilder == null) {
            throw new NullPointerException("mVideoOptionBuilder can't be null");
        }
        this.mVideoOptionBuilder.build(this.mGsyVideoPlayer);
        if (this.mGsyVideoPlayer.getTitleTextView() != null) {
            this.mGsyVideoPlayer.getTitleTextView().setVisibility(8);
        }
        if (this.mGsyVideoPlayer.getBackButton() != null) {
            this.mGsyVideoPlayer.getBackButton().setVisibility(8);
        }
        if (this.mGsyVideoPlayer.getFullscreenButton() != null) {
            this.mGsyVideoPlayer.getFullscreenButton().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GSYVideoHelper.this.doFullBtnLogic();
                }
            });
        }
        this.mGsyVideoPlayer.startPlayLogic();
    }

    public void doFullBtnLogic() {
        if (!this.isFull) {
            this.resolveToFull();
        } else {
            this.resolveMaterialToNormal(this.mGsyVideoPlayer);
        }
    }

    public boolean backFromFull() {
        boolean isFull = false;
        if (this.mFullViewContainer != null && this.mFullViewContainer.getChildCount() > 0) {
            isFull = true;
            this.resolveMaterialToNormal(this.mGsyVideoPlayer);
        } else if (this.mWindowViewContainer != null && this.mWindowViewContainer.indexOfChild((View)this.mGsyVideoPlayer) != -1) {
            isFull = true;
            this.resolveMaterialToNormal(this.mGsyVideoPlayer);
        }
        return isFull;
    }

    public void releaseVideoPlayer() {
        this.removeWindowContainer();
        ViewGroup viewGroup = (ViewGroup)this.mGsyVideoPlayer.getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        this.mPlayPosition = -1;
        this.TAG = "NULL";
        if (this.mOrientationUtils != null) {
            this.mOrientationUtils.releaseListener();
        }
    }

    public void showSmallVideo(Point size, boolean actionBar, boolean statusBar) {
        if (this.mGsyVideoPlayer.getCurrentState() == 2) {
            this.mGsyVideoPlayer.showSmallVideo(size, actionBar, statusBar);
            this.isSmall = true;
        }
    }

    public void smallVideoToNormal() {
        this.isSmall = false;
        this.mGsyVideoPlayer.hideSmallVideo();
    }

    public void setFullViewContainer(ViewGroup fullViewContainer) {
        this.mFullViewContainer = fullViewContainer;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public void setGsyVideoOptionBuilder(GSYVideoHelperBuilder mVideoOptionBuilder) {
        this.mVideoOptionBuilder = mVideoOptionBuilder;
    }

    public GSYVideoOptionBuilder getGsyVideoOptionBuilder() {
        return this.mVideoOptionBuilder;
    }

    public int getPlayPosition() {
        return this.mPlayPosition;
    }

    public String getPlayTAG() {
        return this.TAG;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public StandardGSYVideoPlayer getGsyVideoPlayer() {
        return this.mGsyVideoPlayer;
    }

    public static class GSYVideoHelperBuilder
    extends GSYVideoOptionBuilder {
        protected boolean mHideActionBar;
        protected boolean mHideStatusBar;

        public boolean isHideActionBar() {
            return this.mHideActionBar;
        }

        public GSYVideoHelperBuilder setHideActionBar(boolean hideActionBar) {
            this.mHideActionBar = hideActionBar;
            return this;
        }

        public boolean isHideStatusBar() {
            return this.mHideStatusBar;
        }

        public GSYVideoHelperBuilder setHideStatusBar(boolean hideStatusBar) {
            this.mHideStatusBar = hideStatusBar;
            return this;
        }

        public int getShrinkImageRes() {
            return this.mShrinkImageRes;
        }

        public int getEnlargeImageRes() {
            return this.mEnlargeImageRes;
        }

        public int getPlayPosition() {
            return this.mPlayPosition;
        }

        public int getDialogProgressHighLightColor() {
            return this.mDialogProgressHighLightColor;
        }

        public int getDialogProgressNormalColor() {
            return this.mDialogProgressNormalColor;
        }

        public int getDismissControlTime() {
            return this.mDismissControlTime;
        }

        public long getSeekOnStart() {
            return this.mSeekOnStart;
        }

        public float getSeekRatio() {
            return this.mSeekRatio;
        }

        public float getSpeed() {
            return this.mSpeed;
        }

        public boolean isHideKey() {
            return this.mHideKey;
        }

        public boolean isShowFullAnimation() {
            return this.mShowFullAnimation;
        }

        public boolean isNeedShowWifiTip() {
            return this.mNeedShowWifiTip;
        }

        public boolean isRotateViewAuto() {
            return this.mRotateViewAuto;
        }

        public boolean isLockLand() {
            return this.mLockLand;
        }

        public boolean isLooping() {
            return this.mLooping;
        }

        public boolean isIsTouchWiget() {
            return this.mIsTouchWiget;
        }

        public boolean isIsTouchWigetFull() {
            return this.mIsTouchWigetFull;
        }

        public boolean isShowPauseCover() {
            return this.mShowPauseCover;
        }

        public boolean isRotateWithSystem() {
            return this.mRotateWithSystem;
        }

        public boolean isCacheWithPlay() {
            return this.mCacheWithPlay;
        }

        public boolean isNeedLockFull() {
            return this.mNeedLockFull;
        }

        public boolean isThumbPlay() {
            return this.mThumbPlay;
        }

        public boolean isSounchTouch() {
            return this.mSounchTouch;
        }

        public boolean isSetUpLazy() {
            return this.mSetUpLazy;
        }

        public String getPlayTag() {
            return this.mPlayTag;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public String getVideoTitle() {
            return this.mVideoTitle;
        }

        public File getCachePath() {
            return this.mCachePath;
        }

        public Map<String, String> getMapHeadData() {
            return this.mMapHeadData;
        }

        public VideoAllCallBack getVideoAllCallBack() {
            return this.mVideoAllCallBack;
        }

        public LockClickListener getLockClickListener() {
            return this.mLockClickListener;
        }

        public View getThumbImageView() {
            return this.mThumbImageView;
        }

        public Drawable getBottomProgressDrawable() {
            return this.mBottomProgressDrawable;
        }

        public Drawable getBottomShowProgressDrawable() {
            return this.mBottomShowProgressDrawable;
        }

        public Drawable getBottomShowProgressThumbDrawable() {
            return this.mBottomShowProgressThumbDrawable;
        }

        public Drawable getVolumeProgressDrawable() {
            return this.mVolumeProgressDrawable;
        }

        public Drawable getDialogProgressBarDrawable() {
            return this.mDialogProgressBarDrawable;
        }

        public GSYVideoGLView.ShaderInterface getEffectFilter() {
            return this.mEffectFilter;
        }

        public GSYVideoProgressListener getGSYVideoProgressListener() {
            return this.mGSYVideoProgressListener;
        }
    }
}

