/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.player;

import android.content.Context;
import android.net.Uri;
import android.os.Message;
import android.view.Surface;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.IPlayerManager;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import java.util.List;
import tv.danmaku.ijk.media.player.AndroidMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class SystemPlayerManager
implements IPlayerManager {
    private AndroidMediaPlayer mediaPlayer;
    private Surface surface;
    private boolean release;

    @Override
    public IMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initVideoPlayer(Context context, Message msg, List<VideoOptionModel> optionModelList) {
        this.mediaPlayer = new AndroidMediaPlayer();
        this.mediaPlayer.setAudioStreamType(3);
        this.release = false;
        try {
            this.mediaPlayer.setDataSource(context, Uri.parse((String)((GSYModel)msg.obj).getUrl()), ((GSYModel)msg.obj).getMapHeadData());
            this.mediaPlayer.setLooping(((GSYModel)msg.obj).isLooping());
            if (((GSYModel)msg.obj).getSpeed() != 1.0f && !(((GSYModel)msg.obj).getSpeed() > 0.0f)) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showDisplay(Message msg) {
        if (msg.obj == null && this.mediaPlayer != null && !this.release) {
            this.mediaPlayer.setSurface(null);
            if (this.surface != null) {
                this.surface.release();
                this.surface = null;
            }
        } else if (msg.obj != null) {
            Surface holder;
            this.surface = holder = (Surface)msg.obj;
            if (this.mediaPlayer != null && holder.isValid() && !this.release) {
                this.mediaPlayer.setSurface(holder);
            }
        }
    }

    @Override
    public void setSpeed(float speed, boolean soundTouch) {
        Debuger.printfError(" not support setSpeed");
    }

    @Override
    public void setNeedMute(boolean needMute) {
        try {
            if (this.mediaPlayer != null && !this.release) {
                if (needMute) {
                    this.mediaPlayer.setVolume(0.0f, 0.0f);
                } else {
                    this.mediaPlayer.setVolume(1.0f, 1.0f);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void releaseSurface() {
    }

    @Override
    public void release() {
        if (this.mediaPlayer != null) {
            this.release = true;
            this.mediaPlayer.release();
        }
    }
}

