/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.shuyu.gsyvideoplayer.GSYTextureView;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;

public abstract class GSYTextureRenderView
extends FrameLayout
implements TextureView.SurfaceTextureListener {
    protected Surface mSurface;
    protected GSYTextureView mTextureView;
    protected ViewGroup mTextureViewContainer;
    protected Bitmap mFullPauseBitmap;
    protected int mRotate;

    public GSYTextureRenderView(@NonNull Context context) {
        super(context);
    }

    public GSYTextureRenderView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GSYTextureRenderView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        this.showPauseCover();
        GSYVideoManager.instance().setDisplay(this.mSurface);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        GSYVideoManager.instance().setDisplay(null);
        surface.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.releasePauseCover();
    }

    protected void addTextureView() {
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        this.mTextureView = null;
        this.mTextureView = new GSYTextureView(this.getContext());
        this.mTextureView.setSurfaceTextureListener(this);
        this.mTextureView.setRotation(this.mRotate);
        int params = this.getTextureParams();
        if (this.mTextureViewContainer instanceof RelativeLayout) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(params, params);
            layoutParams.addRule(13);
            this.mTextureViewContainer.addView((View)this.mTextureView, (ViewGroup.LayoutParams)layoutParams);
        } else if (this.mTextureViewContainer instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(params, params);
            layoutParams.gravity = 17;
            this.mTextureViewContainer.addView((View)this.mTextureView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    protected int getTextureParams() {
        boolean typeChanged = GSYVideoType.getShowType() != 0;
        return typeChanged ? -2 : -1;
    }

    protected void changeTextureViewShowType() {
        int params = this.getTextureParams();
        ViewGroup.LayoutParams layoutParams = this.mTextureView.getLayoutParams();
        layoutParams.width = params;
        layoutParams.height = params;
        this.mTextureView.setLayoutParams(layoutParams);
    }

    protected void initCover() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.mTextureView.getSizeW(), (int)this.mTextureView.getSizeH(), (Bitmap.Config)Bitmap.Config.RGB_565);
        this.mFullPauseBitmap = this.mTextureView.getBitmap(bitmap);
    }

    protected void setSmallVideoTextureView(View.OnTouchListener onTouchListener) {
        this.mTextureViewContainer.setOnTouchListener(onTouchListener);
        this.mTextureViewContainer.setOnClickListener(null);
        this.setSmallVideoTextureView();
    }

    protected abstract void showPauseCover();

    protected abstract void releasePauseCover();

    protected abstract void setSmallVideoTextureView();
}

