/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.danikula.videocache.CacheListener;
import com.danikula.videocache.HttpProxyCacheServer;
import com.danikula.videocache.file.Md5FileNameGenerator;
import com.shuyu.gsyvideoplayer.GSYTextureView;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.NetInfoModule;
import com.shuyu.gsyvideoplayer.utils.StorageUtils;
import com.shuyu.gsyvideoplayer.video.GSYBaseVideoPlayer;
import java.io.File;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import tv.danmaku.ijk.media.player.IjkLibLoader;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public abstract class GSYVideoPlayer
extends GSYBaseVideoPlayer
implements View.OnClickListener,
View.OnTouchListener,
SeekBar.OnSeekBarChangeListener,
TextureView.SurfaceTextureListener {
    public static final String TAG = "GSYVideoPlayer";
    public static final int CURRENT_STATE_NORMAL = 0;
    public static final int CURRENT_STATE_PREPAREING = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_PLAYING_BUFFERING_START = 3;
    public static final int CURRENT_STATE_PAUSE = 5;
    public static final int CURRENT_STATE_AUTO_COMPLETE = 6;
    public static final int CURRENT_STATE_ERROR = 7;
    public static final int FULL_SCREEN_NORMAL_DELAY = 2000;
    protected static int mBackUpPlayingBufferState = -1;
    protected static boolean IF_FULLSCREEN_FROM_NORMAL = false;
    public static boolean IF_RELEASE_WHEN_ON_PAUSE = true;
    protected Timer updateProcessTimer;
    protected Surface mSurface;
    protected ProgressTimerTask mProgressTimerTask;
    protected AudioManager mAudioManager;
    protected Handler mHandler = new Handler();
    protected String mPlayTag = "";
    protected Matrix mTransformCover = null;
    protected NetInfoModule mNetInfoModule;
    protected int mPlayPosition = -22;
    protected float mDownX;
    protected float mDownY;
    protected float mMoveY;
    protected float mBrightnessData = -1.0f;
    protected int mDownPosition;
    protected int mGestureDownVolume;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected int mThreshold = 80;
    protected int mSeekToInAdvance = -1;
    protected int mBuffterPoint;
    protected int mSeekTimePosition;
    protected int mSeekEndOffset;
    protected long mSeekOnStart = -1L;
    protected long mPauseTime;
    protected long mCurrentPosition;
    protected boolean mTouchingProgressBar = false;
    protected boolean mChangeVolume = false;
    protected boolean mChangePosition = false;
    protected boolean mShowVKey = false;
    protected boolean mBrightness = false;
    protected boolean mFirstTouch = false;
    private AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: {
                    break;
                }
                case -1: {
                    GSYVideoPlayer.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            GSYVideoPlayer.releaseAllVideos();
                        }
                    });
                    break;
                }
                case -2: {
                    if (!GSYVideoManager.instance().getMediaPlayer().isPlaying()) break;
                    GSYVideoManager.instance().getMediaPlayer().pause();
                    break;
                }
            }
        }
    };

    public abstract int getLayoutId();

    public abstract void startPlayLogic();

    public GSYVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
        this.init(context);
    }

    public GSYVideoPlayer(Context context, IjkLibLoader ijkLibLoader) {
        super(context);
        GSYVideoManager.setIjkLibLoader(ijkLibLoader);
        this.init(context);
    }

    public GSYVideoPlayer(Context context) {
        super(context);
        this.init(context);
    }

    public GSYVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    protected void init(Context context) {
        this.mContext = this.getActivityContext() != null ? this.getActivityContext() : context;
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.mStartButton = this.findViewById(R.id.start);
        this.mSmallClose = this.findViewById(R.id.small_close);
        this.mBackButton = (ImageView)this.findViewById(R.id.back);
        this.mCoverImageView = (ImageView)this.findViewById(R.id.cover);
        this.mFullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.mProgressBar = (SeekBar)this.findViewById(R.id.progress);
        this.mCurrentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.mTotalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.mBottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.mTextureViewContainer = (ViewGroup)this.findViewById(R.id.surface_container);
        this.mTopContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        if (this.isInEditMode()) {
            return;
        }
        this.mStartButton.setOnClickListener((View.OnClickListener)this);
        this.mFullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.mProgressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mBottomContainer.setOnClickListener((View.OnClickListener)this);
        this.mTextureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.mProgressBar.setOnTouchListener((View.OnTouchListener)this);
        this.mTextureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.mFullscreenButton.setOnTouchListener((View.OnTouchListener)this);
        this.mScreenWidth = this.getActivityContext().getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getActivityContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getActivityContext().getApplicationContext().getSystemService("audio");
        this.mSeekEndOffset = CommonUtil.dip2px(this.getActivityContext(), 50.0f);
    }

    public void setIjkLibLoader(IjkLibLoader libLoader) {
        GSYVideoManager.setIjkLibLoader(libLoader);
    }

    public boolean setUp(String url, boolean cacheWithPlay, String title) {
        return this.setUp(url, cacheWithPlay, null, title);
    }

    @Override
    public boolean setUp(String url, boolean cacheWithPlay, File cachePath, Map<String, String> mapHeadData, String title) {
        if (this.setUp(url, cacheWithPlay, cachePath, title)) {
            this.mMapHeadData.clear();
            if (mapHeadData != null) {
                this.mMapHeadData.putAll(mapHeadData);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setUp(String url, boolean cacheWithPlay, File cachePath, String title) {
        this.mCache = cacheWithPlay;
        this.mCachePath = cachePath;
        this.mOriginUrl = url;
        if (this.isCurrentMediaListener() && System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 2000L) {
            return false;
        }
        this.mCurrentState = 0;
        if (cacheWithPlay && url.startsWith("http") && !url.contains("127.0.0.1") && !url.contains(".m3u8")) {
            HttpProxyCacheServer proxy = GSYVideoManager.getProxy(this.getActivityContext().getApplicationContext(), cachePath);
            url = proxy.getProxyUrl(url);
            boolean bl = this.mCacheFile = !url.startsWith("http");
            if (!this.mCacheFile && GSYVideoManager.instance() != null) {
                proxy.registerCacheListener((CacheListener)GSYVideoManager.instance(), this.mOriginUrl);
            }
        } else if (!(cacheWithPlay || url.startsWith("http") || url.startsWith("rtmp") || url.startsWith("rtsp") || url.contains(".m3u8"))) {
            this.mCacheFile = true;
        }
        this.mUrl = url;
        this.mTitle = title;
        this.setStateAndUi(0);
        return true;
    }

    @Override
    protected void setStateAndUi(int state) {
        this.mCurrentState = state;
        switch (this.mCurrentState) {
            case 0: {
                if (this.isCurrentMediaListener()) {
                    this.cancelProgressTimer();
                    GSYVideoManager.instance().releaseMediaPlayer();
                    this.releasePauseCoverAndBitmap();
                    this.mBuffterPoint = 0;
                }
                if (this.mAudioManager != null) {
                    this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
                }
                this.releaseNetWorkState();
                break;
            }
            case 1: {
                this.resetProgressAndTime();
                break;
            }
            case 2: {
                this.startProgressTimer();
                break;
            }
            case 5: {
                this.startProgressTimer();
                break;
            }
            case 7: {
                if (!this.isCurrentMediaListener()) break;
                GSYVideoManager.instance().releaseMediaPlayer();
                break;
            }
            case 6: {
                this.cancelProgressTimer();
                this.mProgressBar.setProgress(100);
                this.mCurrentTimeTextView.setText(this.mTotalTimeTextView.getText());
            }
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (this.mHideKey && this.mIfCurrentIsFullscreen) {
            CommonUtil.hideNavKey(this.mContext);
        }
        if (i == R.id.start) {
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                Toast.makeText((Context)this.getActivityContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.mCurrentState == 0 || this.mCurrentState == 7) {
                if (!this.mUrl.startsWith("file") && !CommonUtil.isWifiConnected(this.getContext()) && this.mNeedShowWifiTip) {
                    this.showWifiDialog();
                    return;
                }
                this.startButtonLogic();
            } else if (this.mCurrentState == 2) {
                GSYVideoManager.instance().getMediaPlayer().pause();
                this.setStateAndUi(5);
                if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                    if (this.mIfCurrentIsFullscreen) {
                        Debuger.printfLog("onClickStopFullscreen");
                        this.mVideoAllCallBack.onClickStopFullscreen(this.mOriginUrl, this.mTitle, this);
                    } else {
                        Debuger.printfLog("onClickStop");
                        this.mVideoAllCallBack.onClickStop(this.mOriginUrl, this.mTitle, this);
                    }
                }
            } else if (this.mCurrentState == 5) {
                if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                    if (this.mIfCurrentIsFullscreen) {
                        Debuger.printfLog("onClickResumeFullscreen");
                        this.mVideoAllCallBack.onClickResumeFullscreen(this.mOriginUrl, this.mTitle, this);
                    } else {
                        Debuger.printfLog("onClickResume");
                        this.mVideoAllCallBack.onClickResume(this.mOriginUrl, this.mTitle, this);
                    }
                }
                GSYVideoManager.instance().getMediaPlayer().start();
                this.setStateAndUi(2);
            } else if (this.mCurrentState == 6) {
                this.startButtonLogic();
            }
        } else if (i == R.id.surface_container && this.mCurrentState == 7) {
            if (this.mVideoAllCallBack != null) {
                Debuger.printfLog("onClickStartError");
                this.mVideoAllCallBack.onClickStartError(this.mOriginUrl, this.mTitle, this);
            }
            this.prepareVideo();
        }
    }

    protected void showWifiDialog() {
    }

    private void startButtonLogic() {
        if (this.mVideoAllCallBack != null && this.mCurrentState == 0) {
            Debuger.printfLog("onClickStartIcon");
            this.mVideoAllCallBack.onClickStartIcon(this.mOriginUrl, this.mTitle, this);
        } else if (this.mVideoAllCallBack != null) {
            Debuger.printfLog("onClickStartError");
            this.mVideoAllCallBack.onClickStartError(this.mOriginUrl, this.mTitle, this);
        }
        this.prepareVideo();
    }

    protected void prepareVideo() {
        if (GSYVideoManager.instance().listener() != null) {
            GSYVideoManager.instance().listener().onCompletion();
        }
        GSYVideoManager.instance().setListener(this);
        GSYVideoManager.instance().setPlayTag(this.mPlayTag);
        GSYVideoManager.instance().setPlayPosition(this.mPlayPosition);
        this.addTextureView();
        this.mAudioManager.requestAudioFocus(this.onAudioFocusChangeListener, 3, 2);
        ((Activity)this.getContext()).getWindow().addFlags(128);
        mBackUpPlayingBufferState = -1;
        GSYVideoManager.instance().prepare(this.mUrl, this.mMapHeadData, this.mLooping, this.mSpeed);
        this.setStateAndUi(1);
    }

    public void onVideoReset() {
        this.setStateAndUi(0);
    }

    @Override
    public void onVideoPause() {
        if (GSYVideoManager.instance().getMediaPlayer().isPlaying()) {
            this.setStateAndUi(5);
            this.mPauseTime = System.currentTimeMillis();
            this.mCurrentPosition = GSYVideoManager.instance().getMediaPlayer().getCurrentPosition();
            if (GSYVideoManager.instance().getMediaPlayer() != null) {
                GSYVideoManager.instance().getMediaPlayer().pause();
            }
        }
    }

    @Override
    public void onVideoResume() {
        this.mPauseTime = 0L;
        if (this.mCurrentState == 5 && this.mCurrentPosition > 0L && GSYVideoManager.instance().getMediaPlayer() != null) {
            this.setStateAndUi(2);
            GSYVideoManager.instance().getMediaPlayer().seekTo(this.mCurrentPosition);
            GSYVideoManager.instance().getMediaPlayer().start();
        }
    }

    @Override
    protected void addTextureView() {
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        this.mTextureView = null;
        this.mTextureView = new GSYTextureView(this.getContext());
        this.mTextureView.setSurfaceTextureListener(this);
        this.mTextureView.setRotation(this.mRotate);
        if (this.mTextureViewContainer instanceof RelativeLayout) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13);
            this.mTextureViewContainer.addView((View)this.mTextureView, (ViewGroup.LayoutParams)layoutParams);
        } else if (this.mTextureViewContainer instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            layoutParams.gravity = 17;
            this.mTextureViewContainer.addView((View)this.mTextureView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Override
    protected void setSmallVideoTextureView(View.OnTouchListener onTouchListener) {
        this.mTextureViewContainer.setOnTouchListener(onTouchListener);
        this.mProgressBar.setOnTouchListener(null);
        this.mFullscreenButton.setOnTouchListener(null);
        this.mFullscreenButton.setVisibility(4);
        this.mProgressBar.setVisibility(4);
        this.mCurrentTimeTextView.setVisibility(4);
        this.mTotalTimeTextView.setVisibility(4);
        this.mTextureViewContainer.setOnClickListener(null);
        this.mSmallClose.setVisibility(0);
        this.mSmallClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GSYVideoPlayer.this.hideSmallVideo();
                GSYVideoPlayer.releaseAllVideos();
            }
        });
    }

    public void setRotationView(int rotate) {
        this.mRotate = rotate;
        this.mTextureView.setRotation(rotate);
    }

    public void refreshVideo() {
        if (this.mTextureView != null) {
            this.mTextureView.requestLayout();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        GSYVideoManager.instance().setDisplay(this.mSurface);
        this.showPauseCover();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        GSYVideoManager.instance().setDisplay(null);
        surface.release();
        this.cancelProgressTimer();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.releasePauseCover();
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.fullscreen) {
            return false;
        }
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    this.mTouchingProgressBar = true;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mMoveY = 0.0f;
                    this.mChangeVolume = false;
                    this.mChangePosition = false;
                    this.mShowVKey = false;
                    this.mBrightness = false;
                    this.mFirstTouch = true;
                    break;
                }
                case 2: {
                    float deltaX = x - this.mDownX;
                    float deltaY = y - this.mDownY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if ((this.mIfCurrentIsFullscreen && this.mIsTouchWigetFull || this.mIsTouchWiget && !this.mIfCurrentIsFullscreen) && !this.mChangePosition && !this.mChangeVolume && !this.mBrightness && (absDeltaX > (float)this.mThreshold || absDeltaY > (float)this.mThreshold)) {
                        this.cancelProgressTimer();
                        if (absDeltaX >= (float)this.mThreshold) {
                            int screenWidth = CommonUtil.getScreenWidth(this.getContext());
                            if (Math.abs((float)screenWidth - this.mDownX) > (float)this.mSeekEndOffset) {
                                this.mChangePosition = true;
                                this.mDownPosition = this.getCurrentPositionWhenPlaying();
                            } else {
                                this.mShowVKey = true;
                            }
                        } else {
                            boolean noEnd;
                            int screenHeight = CommonUtil.getScreenHeight(this.getContext());
                            boolean bl = noEnd = Math.abs((float)screenHeight - this.mDownY) > (float)this.mSeekEndOffset;
                            if (this.mFirstTouch) {
                                this.mBrightness = this.mDownX < (float)this.mScreenWidth * 0.5f && noEnd;
                                this.mFirstTouch = false;
                            }
                            if (!this.mBrightness) {
                                this.mChangeVolume = noEnd;
                                this.mGestureDownVolume = this.mAudioManager.getStreamVolume(3);
                            }
                            boolean bl2 = this.mShowVKey = !noEnd;
                        }
                    }
                    if (this.mChangePosition) {
                        int totalTimeDuration = this.getDuration();
                        this.mSeekTimePosition = (int)((float)this.mDownPosition + deltaX * (float)totalTimeDuration / (float)this.mScreenWidth / this.mSeekRatio);
                        if (this.mSeekTimePosition > totalTimeDuration) {
                            this.mSeekTimePosition = totalTimeDuration;
                        }
                        String seekTime = CommonUtil.stringForTime(this.mSeekTimePosition);
                        String totalTime = CommonUtil.stringForTime(totalTimeDuration);
                        this.showProgressDialog(deltaX, seekTime, this.mSeekTimePosition, totalTime, totalTimeDuration);
                        break;
                    }
                    if (this.mChangeVolume) {
                        deltaY = -deltaY;
                        int max = this.mAudioManager.getStreamMaxVolume(3);
                        int deltaV = (int)((float)max * deltaY * 3.0f / (float)this.mScreenHeight);
                        this.mAudioManager.setStreamVolume(3, this.mGestureDownVolume + deltaV, 0);
                        int volumePercent = (int)((float)(this.mGestureDownVolume * 100 / max) + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                        this.showVolumeDialog(-deltaY, volumePercent);
                        break;
                    }
                    if (this.mChangePosition || !this.mBrightness || !(Math.abs(deltaY) > (float)this.mThreshold)) break;
                    float percent = -deltaY / (float)this.mScreenHeight;
                    this.onBrightnessSlide(percent);
                    this.mDownY = y;
                    break;
                }
                case 1: {
                    this.mTouchingProgressBar = false;
                    this.dismissProgressDialog();
                    this.dismissVolumeDialog();
                    this.dismissBrightnessDialog();
                    if (this.mChangePosition && GSYVideoManager.instance().getMediaPlayer() != null && (this.mCurrentState == 2 || this.mCurrentState == 5)) {
                        GSYVideoManager.instance().getMediaPlayer().seekTo((long)this.mSeekTimePosition);
                        int duration = this.getDuration();
                        int progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.mProgressBar.setProgress(progress);
                        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                            Debuger.printfLog("onTouchScreenSeekPosition");
                            this.mVideoAllCallBack.onTouchScreenSeekPosition(this.mOriginUrl, this.mTitle, this);
                        }
                    } else if (this.mBrightness) {
                        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                            Debuger.printfLog("onTouchScreenSeekLight");
                            this.mVideoAllCallBack.onTouchScreenSeekLight(this.mOriginUrl, this.mTitle, this);
                        }
                    } else if (this.mChangeVolume && this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                        Debuger.printfLog("onTouchScreenSeekVolume");
                        this.mVideoAllCallBack.onTouchScreenSeekVolume(this.mOriginUrl, this.mTitle, this);
                    }
                    this.startProgressTimer();
                    if (!this.mHideKey || !this.mShowVKey) break;
                    return true;
                }
            }
        } else if (id2 == R.id.progress) {
            switch (event.getAction()) {
                case 0: 
                case 2: {
                    this.cancelProgressTimer();
                    for (ViewParent vpdown = this.getParent(); vpdown != null; vpdown = vpdown.getParent()) {
                        vpdown.requestDisallowInterceptTouchEvent(true);
                    }
                    break;
                }
                case 1: {
                    this.startProgressTimer();
                    for (ViewParent vpup = this.getParent(); vpup != null; vpup = vpup.getParent()) {
                        vpup.requestDisallowInterceptTouchEvent(false);
                    }
                    this.mBrightnessData = -1.0f;
                }
            }
        }
        return false;
    }

    protected void showPauseCover() {
        try {
            if (this.mCurrentState == 5 && this.mFullPauseBitmap != null && !this.mFullPauseBitmap.isRecycled() && this.mShowPauseCover) {
                this.mCoverImageView.setRotation(this.mTextureView.getRotation());
                this.mCoverImageView.setImageBitmap(this.mFullPauseBitmap);
                if (this.mTransformCover != null) {
                    this.mCoverImageView.setScaleType(ImageView.ScaleType.MATRIX);
                    this.mCoverImageView.setImageMatrix(this.mTransformCover);
                }
                this.mCoverImageView.setVisibility(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void releasePauseCover() {
        try {
            if (this.mCurrentState != 5 && this.mFullPauseBitmap != null && !this.mFullPauseBitmap.isRecycled() && this.mShowPauseCover) {
                this.mCoverImageView.setImageResource(R.drawable.empty_drawable);
                this.mCoverImageView.setVisibility(8);
                this.mFullPauseBitmap = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void releasePauseCoverAndBitmap() {
        try {
            if (this.mCurrentState != 5 && this.mFullPauseBitmap != null && !this.mFullPauseBitmap.isRecycled() && this.mShowPauseCover) {
                this.mCoverImageView.setImageResource(R.drawable.empty_drawable);
                this.mCoverImageView.setVisibility(8);
                this.mFullPauseBitmap.recycle();
                this.mFullPauseBitmap = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showProgressDialog(float deltaX, String seekTime, int seekTimePosition, String totalTime, int totalTimeDuration) {
    }

    protected void dismissProgressDialog() {
    }

    protected void showVolumeDialog(float deltaY, int volumePercent) {
    }

    protected void dismissVolumeDialog() {
    }

    protected void showBrightnessDialog(float percent) {
    }

    protected void dismissBrightnessDialog() {
    }

    @Override
    protected void onClickUiToggle() {
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
            if (this.isIfCurrentIsFullscreen()) {
                Debuger.printfLog("onClickSeekbarFullscreen");
                this.mVideoAllCallBack.onClickSeekbarFullscreen(this.mOriginUrl, this.mTitle, this);
            } else {
                Debuger.printfLog("onClickSeekbar");
                this.mVideoAllCallBack.onClickSeekbar(this.mOriginUrl, this.mTitle, this);
            }
        }
        if (GSYVideoManager.instance().getMediaPlayer() != null && this.mHadPlay) {
            try {
                int time = seekBar.getProgress() * this.getDuration() / 100;
                GSYVideoManager.instance().getMediaPlayer().seekTo((long)time);
            }
            catch (Exception e) {
                Debuger.printfWarning(e.toString());
            }
        }
    }

    @Override
    public void onPrepared() {
        if (this.mCurrentState != 1) {
            return;
        }
        if (GSYVideoManager.instance().getMediaPlayer() != null) {
            GSYVideoManager.instance().getMediaPlayer().start();
        }
        if (GSYVideoManager.instance().getMediaPlayer() != null && this.mSeekToInAdvance != -1) {
            GSYVideoManager.instance().getMediaPlayer().seekTo((long)this.mSeekToInAdvance);
            this.mSeekToInAdvance = -1;
        }
        this.startProgressTimer();
        this.setStateAndUi(2);
        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
            Debuger.printfLog("onPrepared");
            this.mVideoAllCallBack.onPrepared(this.mOriginUrl, this.mTitle, this);
        }
        if (GSYVideoManager.instance().getMediaPlayer() != null && this.mSeekOnStart > 0L) {
            GSYVideoManager.instance().getMediaPlayer().seekTo(this.mSeekOnStart);
            this.mSeekOnStart = 0L;
        }
        this.createNetWorkState();
        this.listenerNetWorkState();
        this.mHadPlay = true;
    }

    @Override
    public void onAutoCompletion() {
        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
            Debuger.printfLog("onAutoComplete");
            this.mVideoAllCallBack.onAutoComplete(this.mOriginUrl, this.mTitle, this);
        }
        this.setStateAndUi(6);
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        if (IF_FULLSCREEN_FROM_NORMAL) {
            IF_FULLSCREEN_FROM_NORMAL = false;
            if (GSYVideoManager.instance().lastListener() != null) {
                GSYVideoManager.instance().lastListener().onAutoCompletion();
            }
        }
        if (!this.mIfCurrentIsFullscreen) {
            GSYVideoManager.instance().setLastListener(null);
        }
        this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        ((Activity)this.getContext()).getWindow().clearFlags(128);
        this.releaseNetWorkState();
    }

    @Override
    public void onCompletion() {
        this.setStateAndUi(0);
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        if (IF_FULLSCREEN_FROM_NORMAL) {
            IF_FULLSCREEN_FROM_NORMAL = false;
            if (GSYVideoManager.instance().lastListener() != null) {
                GSYVideoManager.instance().lastListener().onCompletion();
            }
        }
        if (!this.mIfCurrentIsFullscreen) {
            GSYVideoManager.instance().setListener(null);
            GSYVideoManager.instance().setLastListener(null);
        }
        GSYVideoManager.instance().setCurrentVideoHeight(0);
        GSYVideoManager.instance().setCurrentVideoWidth(0);
        this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        ((Activity)this.getContext()).getWindow().clearFlags(128);
        this.releaseNetWorkState();
    }

    @Override
    public void onBufferingUpdate(int percent) {
        if (this.mCurrentState != 0 && this.mCurrentState != 1) {
            if (percent != 0) {
                this.setTextAndProgress(percent);
                this.mBuffterPoint = percent;
                Debuger.printfLog("Net speed: " + this.getNetSpeedText() + " percent " + percent);
            }
            if (this.mLooping && this.mHadPlay && percent == 0 && this.mProgressBar.getProgress() >= this.mProgressBar.getMax() - 1) {
                this.loopSetProgressAndTime();
            }
        }
    }

    @Override
    public void onSeekComplete() {
    }

    @Override
    public void onError(int what, int extra) {
        if (this.mNetChanged) {
            this.mNetChanged = false;
            this.netWorkErrorLogic();
            if (this.mVideoAllCallBack != null) {
                this.mVideoAllCallBack.onPlayError(this.mOriginUrl, this.mTitle, this);
            }
            return;
        }
        if (what != 38 && what != -38) {
            this.setStateAndUi(7);
            this.deleteCacheFileWhenError();
            if (this.mVideoAllCallBack != null) {
                this.mVideoAllCallBack.onPlayError(this.mOriginUrl, this.mTitle, this);
            }
        }
    }

    @Override
    public void onInfo(int what, int extra) {
        if (what == 701) {
            mBackUpPlayingBufferState = this.mCurrentState;
            if (this.mHadPlay && this.mCurrentState != 1 && this.mCurrentState > 0) {
                this.setStateAndUi(3);
            }
        } else if (what == 702) {
            if (mBackUpPlayingBufferState != -1) {
                if (this.mHadPlay && this.mCurrentState != 1 && this.mCurrentState > 0) {
                    this.setStateAndUi(mBackUpPlayingBufferState);
                }
                mBackUpPlayingBufferState = -1;
            }
        } else if (what == 10001) {
            this.mRotate = extra;
            if (this.mTextureView != null) {
                this.mTextureView.setRotation(this.mRotate);
            }
        }
    }

    @Override
    public void onVideoSizeChanged() {
        int mVideoWidth = GSYVideoManager.instance().getCurrentVideoWidth();
        int mVideoHeight = GSYVideoManager.instance().getCurrentVideoHeight();
        if (mVideoWidth != 0 && mVideoHeight != 0) {
            this.mTextureView.requestLayout();
        }
    }

    @Override
    public void onBackFullscreen() {
    }

    @Override
    public GSYBaseVideoPlayer startWindowFullscreen(Context context, boolean actionBar, boolean statusBar) {
        GSYBaseVideoPlayer gsyBaseVideoPlayer = super.startWindowFullscreen(context, actionBar, statusBar);
        GSYVideoPlayer gsyVideoPlayer = (GSYVideoPlayer)gsyBaseVideoPlayer;
        gsyVideoPlayer.createNetWorkState();
        gsyVideoPlayer.listenerNetWorkState();
        return gsyBaseVideoPlayer;
    }

    @Override
    protected void resolveNormalVideoShow(View oldF, ViewGroup vp, GSYVideoPlayer gsyVideoPlayer) {
        if (gsyVideoPlayer != null) {
            gsyVideoPlayer.releaseNetWorkState();
        }
        super.resolveNormalVideoShow(oldF, vp, gsyVideoPlayer);
    }

    protected void netWorkErrorLogic() {
        final long currentPosition = this.getCurrentPositionWhenPlaying();
        Debuger.printfError("******* Net State Changed. renew player to connect *******" + currentPosition);
        GSYVideoManager.instance().releaseMediaPlayer();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                GSYVideoPlayer.this.setSeekOnStart(currentPosition);
                GSYVideoPlayer.this.startPlayLogic();
            }
        }, 500L);
    }

    public void clearCurrentCache() {
        if (this.mCacheFile && this.mCache) {
            Debuger.printfError(" mCacheFile Local Error " + this.mUrl);
            CommonUtil.deleteFile(this.mUrl.replace("file://", ""));
            this.mUrl = this.mOriginUrl;
        } else if (this.mUrl.contains("127.0.0.1")) {
            Md5FileNameGenerator md5FileNameGenerator = new Md5FileNameGenerator();
            String name = md5FileNameGenerator.generate(this.mOriginUrl);
            if (this.mCachePath != null) {
                String path = this.mCachePath.getAbsolutePath() + File.separator + name + ".download";
                CommonUtil.deleteFile(path);
            } else {
                String path = StorageUtils.getIndividualCacheDirectory(this.getActivityContext().getApplicationContext()).getAbsolutePath() + File.separator + name + ".download";
                CommonUtil.deleteFile(path);
            }
        }
    }

    private void deleteCacheFileWhenError() {
        this.clearCurrentCache();
        Debuger.printfError("Link Or mCache Error, Please Try Again" + this.mUrl);
        this.mUrl = this.mOriginUrl;
    }

    protected void startProgressTimer() {
        this.cancelProgressTimer();
        this.updateProcessTimer = new Timer();
        this.mProgressTimerTask = new ProgressTimerTask();
        this.updateProcessTimer.schedule((TimerTask)this.mProgressTimerTask, 0L, 300L);
    }

    protected void cancelProgressTimer() {
        if (this.updateProcessTimer != null) {
            this.updateProcessTimer.cancel();
        }
        if (this.mProgressTimerTask != null) {
            this.mProgressTimerTask.cancel();
        }
    }

    public int getCurrentPositionWhenPlaying() {
        int position = 0;
        if (this.mCurrentState == 2 || this.mCurrentState == 5) {
            try {
                position = (int)GSYVideoManager.instance().getMediaPlayer().getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return position;
            }
        }
        return position;
    }

    public int getDuration() {
        int duration = 0;
        try {
            duration = (int)GSYVideoManager.instance().getMediaPlayer().getDuration();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    protected void setTextAndProgress(int secProgress) {
        int position = this.getCurrentPositionWhenPlaying();
        int duration = this.getDuration();
        int progress = position * 100 / (duration == 0 ? 1 : duration);
        this.setProgressAndTime(progress, secProgress, position, duration);
    }

    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        if (!this.mTouchingProgressBar && progress != 0) {
            this.mProgressBar.setProgress(progress);
        }
        if (secProgress > 94) {
            secProgress = 100;
        }
        if (secProgress != 0 && !this.mCacheFile) {
            this.mProgressBar.setSecondaryProgress(secProgress);
        }
        this.mTotalTimeTextView.setText((CharSequence)CommonUtil.stringForTime(totalTime));
        if (currentTime > 0) {
            this.mCurrentTimeTextView.setText((CharSequence)CommonUtil.stringForTime(currentTime));
        }
    }

    protected void resetProgressAndTime() {
        this.mProgressBar.setProgress(0);
        this.mProgressBar.setSecondaryProgress(0);
        this.mCurrentTimeTextView.setText((CharSequence)CommonUtil.stringForTime(0));
        this.mTotalTimeTextView.setText((CharSequence)CommonUtil.stringForTime(0));
    }

    protected void loopSetProgressAndTime() {
        this.mProgressBar.setProgress(0);
        this.mProgressBar.setSecondaryProgress(0);
        this.mCurrentTimeTextView.setText((CharSequence)CommonUtil.stringForTime(0));
    }

    public static void releaseAllVideos() {
        if (IF_RELEASE_WHEN_ON_PAUSE) {
            if (GSYVideoManager.instance().listener() != null) {
                GSYVideoManager.instance().listener().onCompletion();
            }
            GSYVideoManager.instance().releaseMediaPlayer();
        } else {
            IF_RELEASE_WHEN_ON_PAUSE = true;
        }
    }

    public void release() {
        if (this.isCurrentMediaListener() && System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME > 2000L) {
            GSYVideoPlayer.releaseAllVideos();
        }
        this.mHadPlay = false;
    }

    protected boolean isCurrentMediaListener() {
        return GSYVideoManager.instance().listener() != null && GSYVideoManager.instance().listener() == this;
    }

    private void onBrightnessSlide(float percent) {
        this.mBrightnessData = ((Activity)this.mContext).getWindow().getAttributes().screenBrightness;
        if (this.mBrightnessData <= 0.0f) {
            this.mBrightnessData = 0.5f;
        } else if (this.mBrightnessData < 0.01f) {
            this.mBrightnessData = 0.01f;
        }
        WindowManager.LayoutParams lpa = ((Activity)this.mContext).getWindow().getAttributes();
        lpa.screenBrightness = this.mBrightnessData + percent;
        if (lpa.screenBrightness > 1.0f) {
            lpa.screenBrightness = 1.0f;
        } else if (lpa.screenBrightness < 0.01f) {
            lpa.screenBrightness = 0.01f;
        }
        this.showBrightnessDialog(lpa.screenBrightness);
        ((Activity)this.mContext).getWindow().setAttributes(lpa);
    }

    protected void createNetWorkState() {
        if (this.mNetInfoModule == null) {
            this.mNetInfoModule = new NetInfoModule(this.getActivityContext().getApplicationContext(), new NetInfoModule.NetChangeListener(){

                @Override
                public void changed(String state) {
                    if (!GSYVideoPlayer.this.mNetSate.equals(state)) {
                        Debuger.printfError("******* change network state ******* " + state);
                        GSYVideoPlayer.this.mNetChanged = true;
                    }
                    GSYVideoPlayer.this.mNetSate = state;
                }
            });
            this.mNetSate = this.mNetInfoModule.getCurrentConnectionType();
        }
    }

    protected void listenerNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostResume();
        }
    }

    protected void unListenerNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostPause();
        }
    }

    protected void releaseNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostPause();
            this.mNetInfoModule = null;
        }
    }

    public View getStartButton() {
        return this.mStartButton;
    }

    @Override
    public ImageView getFullscreenButton() {
        return this.mFullscreenButton;
    }

    @Override
    public ImageView getBackButton() {
        return this.mBackButton;
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public String getPlayTag() {
        return this.mPlayTag;
    }

    public void setPlayTag(String playTag) {
        this.mPlayTag = playTag;
    }

    public int getPlayPosition() {
        return this.mPlayPosition;
    }

    public void setPlayPosition(int playPosition) {
        this.mPlayPosition = playPosition;
    }

    public void setSmallCloseShow() {
        this.mSmallClose.setVisibility(0);
    }

    public void setSmallCloseHide() {
        this.mSmallClose.setVisibility(8);
    }

    public static boolean backFromWindowFull(Context context) {
        boolean backFrom = false;
        ViewGroup vp = (ViewGroup)CommonUtil.scanForActivity(context).findViewById(0x1020002);
        View oldF = vp.findViewById(85597);
        if (oldF != null) {
            backFrom = true;
            CommonUtil.hideNavKey(context);
            if (GSYVideoManager.instance().lastListener() != null) {
                GSYVideoManager.instance().lastListener().onBackFullscreen();
            }
        }
        return backFrom;
    }

    public long getNetSpeed() {
        if (GSYVideoManager.instance().getMediaPlayer() != null && GSYVideoManager.instance().getMediaPlayer() instanceof IjkMediaPlayer) {
            return ((IjkMediaPlayer)GSYVideoManager.instance().getMediaPlayer()).getTcpSpeed();
        }
        return -1L;
    }

    public String getNetSpeedText() {
        long speed = this.getNetSpeed();
        return CommonUtil.getTextSpeed(speed);
    }

    public long getSeekOnStart() {
        return this.mSeekOnStart;
    }

    public void setSeekOnStart(long seekOnStart) {
        this.mSeekOnStart = seekOnStart;
    }

    public int getBuffterPoint() {
        return this.mBuffterPoint;
    }

    public GSYVideoPlayer getFullWindowPlayer() {
        ViewGroup vp = (ViewGroup)CommonUtil.scanForActivity(this.getContext()).findViewById(0x1020002);
        View full = vp.findViewById(85597);
        GSYVideoPlayer gsyVideoPlayer = null;
        if (full != null) {
            gsyVideoPlayer = (GSYVideoPlayer)full;
        }
        return gsyVideoPlayer;
    }

    protected class ProgressTimerTask
    extends TimerTask {
        protected ProgressTimerTask() {
        }

        @Override
        public void run() {
            if (GSYVideoPlayer.this.mCurrentState == 2 || GSYVideoPlayer.this.mCurrentState == 5) {
                GSYVideoPlayer.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        GSYVideoPlayer.this.setTextAndProgress(0);
                    }
                });
            }
        }
    }
}

