/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;

@SuppressLint(value={"AppCompatCustomView"})
public class GSYImageCover
extends ImageView {
    private boolean fullView;
    private int originW;
    private int originH;

    public GSYImageCover(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GSYImageCover(Context context) {
        super(context);
    }

    public GSYImageCover(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean rotate;
        int videoWidth = GSYVideoManager.instance().getCurrentVideoWidth();
        int videoHeight = GSYVideoManager.instance().getCurrentVideoHeight();
        int width = GSYImageCover.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
        int height = GSYImageCover.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
        int widthS = GSYImageCover.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
        int heightS = GSYImageCover.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
        if (GSYVideoType.getShowType() == -4) {
            boolean rotate2;
            boolean bl = rotate2 = this.getRotation() != 0.0f && this.getRotation() % 90.0f == 0.0f && Math.abs(this.getRotation()) != 180.0f;
            if (rotate2) {
                this.setMeasuredDimension(heightMeasureSpec, widthMeasureSpec);
            } else {
                this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
            }
            return;
        }
        if (this.originW == 0 || this.originH == 0) {
            this.originW = widthS;
            this.originH = heightS;
        }
        if (videoWidth > 0 && videoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (videoWidth * height < width * videoHeight) {
                    width = height * videoWidth / videoHeight;
                } else if (videoWidth * height > width * videoHeight) {
                    height = width * videoHeight / videoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * videoHeight / videoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * videoWidth / videoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = videoWidth;
                height = videoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * videoWidth / videoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * videoHeight / videoWidth;
                }
            }
        }
        boolean bl = rotate = this.getRotation() != 0.0f && this.getRotation() % 90.0f == 0.0f && Math.abs(this.getRotation()) != 180.0f;
        if (rotate) {
            if (widthS < heightS) {
                if (width > height) {
                    width = (int)((float)width * (float)widthS / (float)height);
                    height = widthS;
                } else {
                    height = (int)((float)height * (float)width / (float)widthS);
                    width = widthS;
                }
            } else if (width > height) {
                height = (int)((float)height * (float)width / (float)widthS);
                width = widthS;
            } else {
                width = (int)((float)width * (float)widthS / (float)height);
                height = widthS;
            }
            if (width > height) {
                if (this.originH < this.originW) {
                    if (width > heightS) {
                        height = (int)((float)height * ((float)width / (float)heightS));
                        width = heightS;
                    }
                } else if (width > heightS) {
                    height = (int)((float)height / ((float)width / (float)heightS));
                    width = heightS;
                }
            } else if (height > widthS) {
                width = (int)((float)width * ((float)height / (float)widthS));
                height = widthS;
            }
        }
        if (GSYVideoType.getShowType() == 1) {
            if (height > width) {
                width = height * 9 / 16;
            } else {
                height = width * 9 / 16;
            }
        } else if (GSYVideoType.getShowType() == 2) {
            if (height > width) {
                width = height * 3 / 4;
            } else {
                height = width * 3 / 4;
            }
        }
        boolean bl2 = this.fullView = GSYVideoType.getShowType() == 4;
        if (this.fullView) {
            if (rotate && this.getRotation() != 0.0f) {
                if (width > height) {
                    if (height < this.originW) {
                        width = (int)((float)width * ((float)this.originW / (float)height));
                        height = this.originW;
                    } else if (width < this.originH) {
                        height = (int)((float)height * ((float)this.originH / (float)width));
                        width = this.originH;
                    }
                } else if (width < this.originH) {
                    height = (int)((float)height * ((float)this.originH / (float)width));
                    width = this.originH;
                } else if (height < this.originW) {
                    width = (int)((float)width * ((float)this.originW / (float)height));
                    height = this.originW;
                }
            } else if (height > width) {
                if (width < widthS) {
                    height = (int)((float)height * ((float)widthS / (float)width));
                    width = widthS;
                } else {
                    width = (int)((float)width * ((float)heightS / (float)height));
                    height = heightS;
                }
            } else if (height < heightS) {
                width = (int)((float)width * ((float)heightS / (float)height));
                height = heightS;
            } else {
                height = (int)((float)height * ((float)widthS / (float)width));
                width = widthS;
            }
        }
        this.setMeasuredDimension(width, height);
    }
}

