/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo2;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.ext.rtmp.RtmpDataSourceFactory;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.DefaultDashChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.DefaultSsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.RawResourceDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.CacheKeyFactory;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import java.io.File;
import java.util.Map;
import java.util.NavigableSet;
import tv.danmaku.ijk.media.exo2.ExoMediaSourceInterceptListener;

public class ExoSourceManager {
    private static final String TAG = "ExoSourceManager";
    private static final long DEFAULT_MAX_SIZE = 0x20000000L;
    public static final int TYPE_RTMP = 14;
    private static Cache mCache;
    @Deprecated
    private static boolean sSkipSSLChain;
    private static int sHttpReadTimeout;
    private static int sHttpConnectTimeout;
    private Context mAppContext;
    private Map<String, String> mMapHeadData;
    private String mDataSource;
    private static ExoMediaSourceInterceptListener sExoMediaSourceInterceptListener;
    private static DatabaseProvider sDatabaseProvider;
    private boolean isCached = false;

    public static ExoSourceManager newInstance(Context context, @Nullable Map<String, String> mapHeadData) {
        return new ExoSourceManager(context, mapHeadData);
    }

    private ExoSourceManager(Context context, Map<String, String> mapHeadData) {
        this.mAppContext = context.getApplicationContext();
        this.mMapHeadData = mapHeadData;
    }

    public MediaSource getMediaSource(String dataSource, boolean preview, boolean cacheEnable, boolean isLooping, File cacheDir, @Nullable String overrideExtension) {
        MediaSource mediaSource = null;
        if (sExoMediaSourceInterceptListener != null) {
            mediaSource = sExoMediaSourceInterceptListener.getMediaSource(dataSource, preview, cacheEnable, isLooping, cacheDir);
        }
        if (mediaSource != null) {
            return mediaSource;
        }
        this.mDataSource = dataSource;
        Uri contentUri = Uri.parse((String)dataSource);
        MediaItem mediaItem = MediaItem.fromUri((Uri)contentUri);
        int contentType = ExoSourceManager.inferContentType(dataSource, overrideExtension);
        String uerAgent = null;
        if (this.mMapHeadData != null) {
            uerAgent = this.mMapHeadData.get("User-Agent");
        }
        if ("android.resource".equals(contentUri.getScheme())) {
            DataSpec dataSpec = new DataSpec(contentUri);
            final RawResourceDataSource rawResourceDataSource = new RawResourceDataSource(this.mAppContext);
            try {
                rawResourceDataSource.open(dataSpec);
            }
            catch (RawResourceDataSource.RawResourceDataSourceException e) {
                e.printStackTrace();
            }
            DataSource.Factory factory = new DataSource.Factory(){

                public DataSource createDataSource() {
                    return rawResourceDataSource;
                }
            };
            return new ProgressiveMediaSource.Factory(factory).createMediaSource(mediaItem);
        }
        switch (contentType) {
            case 1: {
                mediaSource = new SsMediaSource.Factory((SsChunkSource.Factory)new DefaultSsChunkSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir, uerAgent)), (DataSource.Factory)new DefaultDataSourceFactory(this.mAppContext, null, this.getHttpDataSourceFactory(this.mAppContext, preview, uerAgent))).createMediaSource(mediaItem);
                break;
            }
            case 0: {
                mediaSource = new DashMediaSource.Factory((DashChunkSource.Factory)new DefaultDashChunkSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir, uerAgent)), (DataSource.Factory)new DefaultDataSourceFactory(this.mAppContext, null, this.getHttpDataSourceFactory(this.mAppContext, preview, uerAgent))).createMediaSource(mediaItem);
                break;
            }
            case 2: {
                mediaSource = new HlsMediaSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir, uerAgent)).setAllowChunklessPreparation(true).createMediaSource(mediaItem);
                break;
            }
            case 14: {
                RtmpDataSourceFactory rtmpDataSourceFactory = new RtmpDataSourceFactory(null);
                mediaSource = new ProgressiveMediaSource.Factory((DataSource.Factory)rtmpDataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(mediaItem);
                break;
            }
            default: {
                mediaSource = new ProgressiveMediaSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir, uerAgent), (ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(mediaItem);
            }
        }
        return mediaSource;
    }

    public static void setExoMediaSourceInterceptListener(ExoMediaSourceInterceptListener exoMediaSourceInterceptListener) {
        sExoMediaSourceInterceptListener = exoMediaSourceInterceptListener;
    }

    public static void resetExoMediaSourceInterceptListener() {
        sExoMediaSourceInterceptListener = null;
    }

    public static ExoMediaSourceInterceptListener getExoMediaSourceInterceptListener() {
        return sExoMediaSourceInterceptListener;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int inferContentType(String fileName, @Nullable String overrideExtension) {
        if ((fileName = Ascii.toLowerCase((String)fileName)).startsWith("rtmp:")) {
            return 14;
        }
        return ExoSourceManager.inferContentType(Uri.parse((String)fileName), overrideExtension);
    }

    public static int inferContentType(Uri uri, @Nullable String overrideExtension) {
        return Util.inferContentType((Uri)uri, (String)overrideExtension);
    }

    public static synchronized Cache getCacheSingleInstance(Context context, File cacheDir) {
        String path;
        boolean isLocked;
        String dirs = context.getCacheDir().getAbsolutePath();
        if (cacheDir != null) {
            dirs = cacheDir.getAbsolutePath();
        }
        if (mCache == null && !(isLocked = SimpleCache.isCacheFolderLocked((File)new File(path = dirs + File.separator + "exo")))) {
            mCache = new SimpleCache(new File(path), (CacheEvictor)new LeastRecentlyUsedCacheEvictor(0x20000000L), sDatabaseProvider);
        }
        return mCache;
    }

    public void release() {
        this.isCached = false;
        if (mCache != null) {
            try {
                mCache.release();
                mCache = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void clearCache(Context context, File cacheDir, String url) {
        try {
            Cache cache = ExoSourceManager.getCacheSingleInstance(context, cacheDir);
            if (!TextUtils.isEmpty((CharSequence)url)) {
                if (cache != null) {
                    ExoSourceManager.removeCache(cache, url);
                }
            } else if (cache != null) {
                for (String key : cache.getKeys()) {
                    ExoSourceManager.removeCache(cache, key);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeCache(Cache cache, String url) {
        NavigableSet cachedSpans = cache.getCachedSpans(ExoSourceManager.buildCacheKey(url));
        for (CacheSpan cachedSpan : cachedSpans) {
            try {
                cache.removeSpan(cachedSpan);
            }
            catch (Exception exception) {}
        }
    }

    public static String buildCacheKey(String url) {
        DataSpec dataSpec = new DataSpec(Uri.parse((String)url));
        String key = CacheKeyFactory.DEFAULT.buildCacheKey(dataSpec);
        return key;
    }

    public static boolean cachePreView(Context context, File cacheDir, String url) {
        return ExoSourceManager.resolveCacheState(ExoSourceManager.getCacheSingleInstance(context, cacheDir), url);
    }

    public boolean hadCached() {
        return this.isCached;
    }

    @Deprecated
    public static boolean isSkipSSLChain() {
        return sSkipSSLChain;
    }

    @Deprecated
    public static void setSkipSSLChain(boolean skipSSLChain) {
        sSkipSSLChain = skipSSLChain;
    }

    public static int getHttpReadTimeout() {
        return sHttpReadTimeout;
    }

    public static void setHttpReadTimeout(int httpReadTimeout) {
        sHttpReadTimeout = httpReadTimeout;
    }

    public static int getHttpConnectTimeout() {
        return sHttpConnectTimeout;
    }

    public static void setHttpConnectTimeout(int httpConnectTimeout) {
        sHttpConnectTimeout = httpConnectTimeout;
    }

    public static DatabaseProvider getDatabaseProvider() {
        return sDatabaseProvider;
    }

    public static void setDatabaseProvider(DatabaseProvider databaseProvider) {
        sDatabaseProvider = databaseProvider;
    }

    private DataSource.Factory getDataSourceFactoryCache(Context context, boolean cacheEnable, boolean preview, File cacheDir, String uerAgent) {
        Cache cache;
        if (cacheEnable && (cache = ExoSourceManager.getCacheSingleInstance(context, cacheDir)) != null) {
            this.isCached = ExoSourceManager.resolveCacheState(cache, this.mDataSource);
            CacheDataSource.Factory factory = new CacheDataSource.Factory();
            return factory.setCache(cache).setCacheReadDataSourceFactory(this.getDataSourceFactory(context, preview, uerAgent)).setFlags(2);
        }
        return this.getDataSourceFactory(context, preview, uerAgent);
    }

    private DataSource.Factory getDataSourceFactory(Context context, boolean preview, String uerAgent) {
        return new DefaultDataSourceFactory(context, (TransferListener)(preview ? null : new DefaultBandwidthMeter.Builder(context).build()), this.getHttpDataSourceFactory(context, preview, uerAgent));
    }

    private DataSource.Factory getHttpDataSourceFactory(Context context, boolean preview, String uerAgent) {
        DataSource.Factory dataSourceFactory;
        if (uerAgent == null) {
            uerAgent = Util.getUserAgent((Context)context, (String)TAG);
        }
        int connectTimeout = 8000;
        int readTimeout = 8000;
        if (sHttpConnectTimeout > 0) {
            connectTimeout = sHttpConnectTimeout;
        }
        if (sHttpReadTimeout > 0) {
            readTimeout = sHttpReadTimeout;
        }
        boolean allowCrossProtocolRedirects = false;
        if (this.mMapHeadData != null && this.mMapHeadData.size() > 0) {
            allowCrossProtocolRedirects = "true".equals(this.mMapHeadData.get("allowCrossProtocolRedirects"));
        }
        if (sExoMediaSourceInterceptListener != null) {
            dataSourceFactory = sExoMediaSourceInterceptListener.getHttpDataSourceFactory(uerAgent, (TransferListener)(preview ? null : new DefaultBandwidthMeter.Builder(this.mAppContext).build()), connectTimeout, readTimeout, this.mMapHeadData, allowCrossProtocolRedirects);
        } else {
            dataSourceFactory = new DefaultHttpDataSource.Factory().setAllowCrossProtocolRedirects(allowCrossProtocolRedirects).setConnectTimeoutMs(connectTimeout).setReadTimeoutMs(readTimeout).setTransferListener(preview ? null : new DefaultBandwidthMeter.Builder(this.mAppContext).build());
            if (this.mMapHeadData != null && this.mMapHeadData.size() > 0) {
                ((DefaultHttpDataSource.Factory)dataSourceFactory).setDefaultRequestProperties(this.mMapHeadData);
            }
        }
        return dataSourceFactory;
    }

    private static boolean resolveCacheState(Cache cache, String url) {
        boolean isCache = true;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            String key = ExoSourceManager.buildCacheKey(url);
            if (!TextUtils.isEmpty((CharSequence)key)) {
                NavigableSet cachedSpans = cache.getCachedSpans(key);
                if (cachedSpans.size() == 0) {
                    isCache = false;
                } else {
                    long contentLength = cache.getContentMetadata(key).get("exo_len", -1L);
                    long currentLength = 0L;
                    for (CacheSpan cachedSpan : cachedSpans) {
                        currentLength += cache.getCachedLength(key, cachedSpan.position, cachedSpan.length);
                    }
                    isCache = currentLength >= contentLength;
                }
            } else {
                isCache = false;
            }
        }
        return isCache;
    }

    static {
        sSkipSSLChain = false;
        sHttpReadTimeout = -1;
        sHttpConnectTimeout = -1;
    }
}

