/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo2;

import android.content.Context;
import android.net.Uri;
import androidx.media3.database.DatabaseProvider;
import androidx.media3.database.StandaloneDatabaseProvider;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.cache.Cache;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.datasource.cache.CacheWriter;
import androidx.media3.exoplayer.offline.DownloadManager;
import androidx.media3.exoplayer.offline.DownloadRequest;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import tv.danmaku.ijk.media.exo2.ExoSourceManager;

public class CacheHelper {
    private static boolean init = false;
    private static DownloadManager downloadManager;
    protected CacheWriter cacheWriter;

    public void preCacheVideo(Context context, Uri uri, long length, CacheWriter.ProgressListener progressListener) throws IOException {
        this.preCacheVideo(context, uri, null, false, null, null, length, progressListener);
    }

    public void preCacheVideo(Context context, Uri uri, File cacheDir, boolean preview, String uerAgent, Map<String, String> mapHeadData, long length, CacheWriter.ProgressListener progressListener) throws IOException {
        CacheDataSource.Factory factory = new CacheDataSource.Factory();
        Cache cache = ExoSourceManager.getCacheSingleInstance(context, cacheDir);
        DataSpec dataSpec = new DataSpec(uri, 0L, length);
        factory.setCache(cache).setCacheReadDataSourceFactory(ExoSourceManager.getDataSourceFactory(context, preview, uerAgent, mapHeadData)).setFlags(2).setUpstreamDataSourceFactory(ExoSourceManager.getHttpDataSourceFactory(context, preview, uerAgent, mapHeadData));
        this.cacheWriter = new CacheWriter(factory.createDataSource(), dataSpec, null, progressListener);
        this.cacheWriter.cache();
    }

    public void cancel() {
        if (this.cacheWriter != null) {
            this.cacheWriter.cancel();
        }
    }

    public static synchronized DownloadManager getDownloadManager() throws Exception {
        if (!init) {
            throw new Exception("downloadManager never init");
        }
        return downloadManager;
    }

    public static synchronized void ensureDownloadManagerInitialized(Context context, File cacheDir, boolean preview, String uerAgent, Map<String, String> mapHeadData) {
        init = true;
        if (downloadManager == null) {
            downloadManager = new DownloadManager(context, (DatabaseProvider)(ExoSourceManager.getDatabaseProvider() != null ? ExoSourceManager.getDatabaseProvider() : new StandaloneDatabaseProvider(context)), ExoSourceManager.getCacheSingleInstance(context, cacheDir), ExoSourceManager.getHttpDataSourceFactory(context, preview, uerAgent, mapHeadData), (Executor)Executors.newFixedThreadPool(6));
        }
    }

    public static synchronized void download(String contentId, Uri contentUri) {
        if (downloadManager != null) {
            downloadManager.addDownload(new DownloadRequest.Builder(contentId, contentUri).build());
            downloadManager.resumeDownloads();
        }
    }

    public static synchronized void pause() {
        if (downloadManager != null) {
            downloadManager.pauseDownloads();
        }
    }

    public static synchronized void release() {
        if (downloadManager != null) {
            downloadManager.release();
        }
        downloadManager = null;
        init = false;
    }
}

