/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper.utils;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import androidx.core.content.FileProvider;
import com.canhub.cropper.common.CommonVersionCheck;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"getUriForFile", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "cropper_release"})
public final class GetUriForFileKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Uri getUriForFile(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String authority = context.getPackageName() + ".cropper.fileprovider";
        try {
            Log.i((String)"AIC", (String)"Try get URI for scope storage - content://");
            Uri uri = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getUriForFile(context, authority, file)");
            return uri;
        }
        catch (Exception e) {
            try {
                Uri uri;
                Log.e((String)"AIC", (String)String.valueOf(e.getMessage()));
                Log.w((String)"AIC", (String)"ANR Risk -- Copying the file the location cache to avoid 'external-files-path' bug for N+ devices");
                File cacheFolder = new File(context.getCacheDir(), "CROP_LIB_CACHE");
                File cacheLocation = new File(cacheFolder, file.getName());
                InputStream input = null;
                OutputStream output = null;
                try {
                    input = new FileInputStream(file);
                    output = new FileOutputStream(cacheLocation);
                    ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    Log.i((String)"AIC", (String)"Completed Android N+ file copy. Attempting to return the cached file");
                    Uri uri2 = FileProvider.getUriForFile((Context)context, (String)authority, (File)cacheLocation);
                    Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"getUriForFile(context, authority, cacheLocation)");
                    uri = uri2;
                    input.close();
                }
                catch (Exception e2) {
                    Log.e((String)"AIC", (String)String.valueOf(e2.getMessage()));
                    Log.i((String)"AIC", (String)"Trying to provide URI manually");
                    String path = "content://" + authority + "/files/my_images/";
                    if (CommonVersionCheck.INSTANCE.isAtLeastO26()) {
                        Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
                    } else {
                        File directory = new File(path);
                        if (!directory.exists()) {
                            directory.mkdirs();
                        }
                    }
                    Uri uri3 = Uri.parse((String)(path + file.getName()));
                    Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"parse(\"$path${file.name}\")");
                    Uri uri4 = uri3;
                    return uri4;
                }
                finally {
                    InputStream inputStream = input;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    OutputStream outputStream = output;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                output.close();
                return uri;
            }
            catch (Exception e3) {
                Log.e((String)"AIC", (String)String.valueOf(e3.getMessage()));
                if (!CommonVersionCheck.INSTANCE.isAtLeastQ29()) {
                    File cacheDir;
                    File file2 = cacheDir = context.getExternalCacheDir();
                    if (file2 != null) {
                        File it = file2;
                        boolean bl = false;
                        try {
                            Log.i((String)"AIC", (String)"Use External storage, do not work for OS 29 and above");
                            Uri uri = Uri.fromFile((File)new File(cacheDir.getPath(), file.getAbsolutePath()));
                            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(File(cacheDir.path, file.absolutePath))");
                            return uri;
                        }
                        catch (Exception e4) {
                            Log.e((String)"AIC", (String)String.valueOf(e4.getMessage()));
                        }
                    }
                }
                Log.i((String)"AIC", (String)"Try get URI using file://");
                Uri uri = Uri.fromFile((File)file);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(file)");
                return uri;
            }
        }
    }
}

