/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.MediaStore;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import com.canhub.cropper.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000fJ\u0014\u0010\u001c\u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/canhub/cropper/CropImageIntentChooser;", "", "activity", "Landroidx/activity/ComponentActivity;", "callback", "Lcom/canhub/cropper/CropImageIntentChooser$ResultCallback;", "(Landroidx/activity/ComponentActivity;Lcom/canhub/cropper/CropImageIntentChooser$ResultCallback;)V", "cameraImgUri", "Landroid/net/Uri;", "intentChooser", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "priorityIntentList", "", "", "title", "getCameraIntents", "context", "Landroid/content/Context;", "packageManager", "Landroid/content/pm/PackageManager;", "getGalleryIntents", "action", "hasCameraPermissionInManifest", "", "isExplicitCameraPermissionRequired", "setIntentChooserTitle", "setupPriorityAppsList", "appsList", "showChooserIntent", "", "includeCamera", "includeGallery", "Companion", "ResultCallback", "cropper_release"})
public final class CropImageIntentChooser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentActivity activity;
    @NotNull
    private final ResultCallback callback;
    @NotNull
    private String title;
    @NotNull
    private List<String> priorityIntentList;
    @Nullable
    private Uri cameraImgUri;
    @NotNull
    private final ActivityResultLauncher<Intent> intentChooser;
    @NotNull
    public static final String GOOGLE_PHOTOS = "com.google.android.apps.photos";
    @NotNull
    public static final String GOOGLE_PHOTOS_GO = "com.google.android.apps.photosgo";
    @NotNull
    public static final String SAMSUNG_GALLERY = "com.sec.android.gallery3d";
    @NotNull
    public static final String ONEPLUS_GALLERY = "com.oneplus.gallery";
    @NotNull
    public static final String MIUI_GALLERY = "com.miui.gallery";

    public CropImageIntentChooser(@NotNull ComponentActivity activity, @NotNull ResultCallback callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.activity = activity;
        this.callback = callback;
        String[] stringArray = this.activity.getString(R.string.pick_image_chooser_title);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"activity.getString(R.string.pick_image_chooser_title)");
        this.title = stringArray;
        stringArray = new String[]{GOOGLE_PHOTOS, GOOGLE_PHOTOS_GO, SAMSUNG_GALLERY, ONEPLUS_GALLERY, MIUI_GALLERY};
        this.priorityIntentList = CollectionsKt.listOf((Object[])stringArray);
        stringArray = this.activity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> CropImageIntentChooser.intentChooser$lambda-1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"activity.registerForActivityResult(ActivityResultContracts.StartActivityForResult()) { activityRes ->\n            if (activityRes.resultCode == Activity.RESULT_OK) {\n                /*\n                    Here we don't know whether a gallery app or the camera app is selected\n                    via the intent chooser. If a gallery app is selected and an image is\n                    chosen then we get the result from activityRes.\n                    If a camera app is selected we take the uri we passed to the camera\n                    app for storing the captured image\n                 */\n                (activityRes.data?.data ?: cameraImgUri).let { uri ->\n                    callback.onSuccess(uri)\n                }\n            } else {\n                callback.onCancelled()\n            }\n        }");
        this.intentChooser = stringArray;
    }

    public final void showChooserIntent(boolean includeCamera, boolean includeGallery, @Nullable Uri cameraImgUri) {
        Intent intent;
        this.cameraImgUri = cameraImgUri;
        List allIntents = new ArrayList();
        PackageManager packageManager = this.activity.getPackageManager();
        if (!this.isExplicitCameraPermissionRequired((Context)this.activity) && includeCamera) {
            Context context = (Context)this.activity;
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"packageManager");
            allIntents.addAll((Collection)this.getCameraIntents(context, packageManager));
        }
        if (includeGallery) {
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"packageManager");
            List<Intent> galleryIntents = this.getGalleryIntents(packageManager, "android.intent.action.GET_CONTENT");
            if (galleryIntents.isEmpty()) {
                galleryIntents = this.getGalleryIntents(packageManager, "android.intent.action.PICK");
            }
            allIntents.addAll((Collection)galleryIntents);
        }
        if (allIntents.isEmpty()) {
            intent = new Intent();
        } else {
            Intent intent2 = new Intent("android.intent.action.CHOOSER", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$showChooserIntent_u24lambda_u2d2 = intent2;
            boolean bl3 = false;
            if (includeGallery) {
                $this$showChooserIntent_u24lambda_u2d2.setAction("android.intent.action.PICK");
                $this$showChooserIntent_u24lambda_u2d2.setType("image/*");
            }
            intent = intent2;
        }
        Intent target = intent;
        Intent chooserIntent = Intent.createChooser((Intent)target, (CharSequence)this.title);
        Collection $this$toTypedArray$iv = allIntents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Parcelable[] parcelableArray = thisCollection$iv.toArray(new Parcelable[0]);
        if (parcelableArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", parcelableArray);
        this.intentChooser.launch((Object)chooserIntent);
    }

    public static /* synthetic */ void showChooserIntent$default(CropImageIntentChooser cropImageIntentChooser, boolean bl, boolean bl2, Uri uri, int n, Object object) {
        if ((n & 4) != 0) {
            uri = null;
        }
        cropImageIntentChooser.showChooserIntent(bl, bl2, uri);
    }

    private final List<Intent> getCameraIntents(Context context, PackageManager packageManager) {
        List allIntents = new ArrayList();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        List list = packageManager.queryIntentActivities(captureIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryIntentActivities(captureIntent, 0)");
        List listCam = list;
        for (ResolveInfo resolveInfo : listCam) {
            Intent intent = new Intent(captureIntent);
            intent.setComponent(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name));
            intent.setPackage(resolveInfo.activityInfo.packageName);
            if (context instanceof Activity) {
                context.grantUriPermission(resolveInfo.activityInfo.packageName, this.cameraImgUri, 3);
            }
            intent.putExtra("output", (Parcelable)this.cameraImgUri);
            allIntents.add(intent);
        }
        return allIntents;
    }

    private final List<Intent> getGalleryIntents(PackageManager packageManager, String action) {
        List intents = new ArrayList();
        Intent galleryIntent = Intrinsics.areEqual((Object)action, (Object)"android.intent.action.GET_CONTENT") ? new Intent(action) : new Intent(action, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        galleryIntent.setType("image/*");
        List list = packageManager.queryIntentActivities(galleryIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryIntentActivities(galleryIntent, 0)");
        List listGallery = list;
        for (ResolveInfo res : listGallery) {
            Intent intent = new Intent(galleryIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage(res.activityInfo.packageName);
            intents.add(intent);
        }
        boolean bl = false;
        List priorityIntents = new ArrayList();
        for (String pkgName : this.priorityIntentList) {
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = intents;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Intent it = (Intent)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getPackage(), (Object)pkgName)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            Intent intent = v0;
            if (intent == null) continue;
            Intent intent2 = intent;
            boolean bl3 = false;
            boolean bl4 = false;
            Intent it = intent2;
            boolean bl5 = false;
            intents.remove(it);
            priorityIntents.add(it);
        }
        intents.addAll(0, priorityIntents);
        return intents;
    }

    private final boolean isExplicitCameraPermissionRequired(Context context) {
        return Build.VERSION.SDK_INT >= 23 && this.hasCameraPermissionInManifest(context) && context.checkSelfPermission("android.permission.CAMERA") != 0;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasCameraPermissionInManifest(Context context) {
        String packageName = context.getPackageName();
        try {
            boolean bl;
            String[] declaredPermissions;
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 4096);
            String[] stringArray = declaredPermissions = packageInfo.requestedPermissions;
            if (stringArray == null) {
                bl = false;
            } else {
                boolean bl2;
                block5: {
                    void $this$any$iv;
                    String[] stringArray2 = stringArray;
                    boolean $i$f$any = false;
                    void var8_9 = $this$any$iv;
                    int n = ((void)var8_9).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var8_9[i];
                        boolean bl3 = false;
                        void var14_15 = it;
                        if (!(var14_15 == null ? false : StringsKt.equals((String)var14_15, (String)"android.permission.CAMERA", (boolean)true))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public final CropImageIntentChooser setupPriorityAppsList(@NotNull List<String> appsList) {
        Intrinsics.checkNotNullParameter(appsList, (String)"appsList");
        CropImageIntentChooser cropImageIntentChooser = this;
        boolean bl = false;
        boolean bl2 = false;
        CropImageIntentChooser $this$setupPriorityAppsList_u24lambda_u2d6 = cropImageIntentChooser;
        boolean bl3 = false;
        $this$setupPriorityAppsList_u24lambda_u2d6.priorityIntentList = appsList;
        return cropImageIntentChooser;
    }

    @NotNull
    public final CropImageIntentChooser setIntentChooserTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        CropImageIntentChooser cropImageIntentChooser = this;
        boolean bl = false;
        boolean bl2 = false;
        CropImageIntentChooser $this$setIntentChooserTitle_u24lambda_u2d7 = cropImageIntentChooser;
        boolean bl3 = false;
        $this$setIntentChooserTitle_u24lambda_u2d7.title = title;
        return cropImageIntentChooser;
    }

    private static final void intentChooser$lambda-1(CropImageIntentChooser this$0, ActivityResult activityRes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (activityRes.getResultCode() == -1) {
            Intent intent = activityRes.getData();
            Uri uri = intent == null ? null : intent.getData();
            uri = uri == null ? this$0.cameraImgUri : uri;
            boolean bl = false;
            boolean bl2 = false;
            Uri uri2 = uri;
            boolean bl3 = false;
            this$0.callback.onSuccess(uri2);
        } else {
            this$0.callback.onCancelled();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&\u00a8\u0006\u0007"}, d2={"Lcom/canhub/cropper/CropImageIntentChooser$ResultCallback;", "", "onCancelled", "", "onSuccess", "uri", "Landroid/net/Uri;", "cropper_release"})
    public static interface ResultCallback {
        public void onSuccess(@Nullable Uri var1);

        public void onCancelled();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/canhub/cropper/CropImageIntentChooser$Companion;", "", "()V", "GOOGLE_PHOTOS", "", "GOOGLE_PHOTOS_GO", "MIUI_GALLERY", "ONEPLUS_GALLERY", "SAMSUNG_GALLERY", "cropper_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

