/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.DrawableRes;
import androidx.annotation.RequiresApi;
import androidx.core.content.FileProvider;
import com.canhub.cropper.CropImageActivity;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropImageView;
import com.canhub.cropper.R;
import com.canhub.cropper.common.CommonVersionCheck;
import com.canhub.cropper.utils.GetFilePathFromUriKt;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000389:B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010 \u001a\u00020!J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020!J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J*\u0010%\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010$\u001a\u00020!2\u0006\u0010(\u001a\u00020!H\u0007J\u001a\u0010)\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J$\u0010*\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010 \u001a\u00020!H\u0007J\u0016\u0010+\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\bJ\u000e\u0010-\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010.\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010/\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u000202H\u0007J\u0018\u00100\u001a\u0002012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00103\u001a\u000204H\u0007J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u000206R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/canhub/cropper/CropImage;", "", "()V", "CAMERA_CAPTURE_PERMISSIONS_REQUEST_CODE", "", "CROP_IMAGE_ACTIVITY_REQUEST_CODE", "CROP_IMAGE_ACTIVITY_RESULT_ERROR_CODE", "CROP_IMAGE_EXTRA_BUNDLE", "", "CROP_IMAGE_EXTRA_OPTIONS", "CROP_IMAGE_EXTRA_RESULT", "CROP_IMAGE_EXTRA_SOURCE", "PICK_IMAGE_CHOOSER_REQUEST_CODE", "PICK_IMAGE_PERMISSIONS_REQUEST_CODE", "activity", "Lcom/canhub/cropper/CropImage$ActivityBuilder;", "uri", "Landroid/net/Uri;", "getActivityResult", "Lcom/canhub/cropper/CropImage$ActivityResult;", "data", "Landroid/content/Intent;", "getCameraIntent", "context", "Landroid/content/Context;", "outputFileUri", "getCameraIntents", "", "packageManager", "Landroid/content/pm/PackageManager;", "getCaptureImageOutputUriContent", "getCaptureImageOutputUriFilePath", "uniqueName", "", "getGalleryIntents", "action", "includeDocuments", "getPickImageChooserIntent", "title", "", "includeCamera", "getPickImageResultUriContent", "getPickImageResultUriFilePath", "hasPermissionInManifest", "permissionName", "isExplicitCameraPermissionRequired", "isReadExternalStoragePermissionsRequired", "isUriRequiresPermissions", "startPickImageActivity", "", "Landroid/app/Activity;", "fragment", "Landroidx/fragment/app/Fragment;", "toOvalBitmap", "Landroid/graphics/Bitmap;", "bitmap", "ActivityBuilder", "ActivityResult", "CancelledResult", "cropper_release"})
public final class CropImage {
    @NotNull
    public static final CropImage INSTANCE = new CropImage();
    @NotNull
    public static final String CROP_IMAGE_EXTRA_SOURCE = "CROP_IMAGE_EXTRA_SOURCE";
    @NotNull
    public static final String CROP_IMAGE_EXTRA_OPTIONS = "CROP_IMAGE_EXTRA_OPTIONS";
    @NotNull
    public static final String CROP_IMAGE_EXTRA_BUNDLE = "CROP_IMAGE_EXTRA_BUNDLE";
    @NotNull
    public static final String CROP_IMAGE_EXTRA_RESULT = "CROP_IMAGE_EXTRA_RESULT";
    public static final int PICK_IMAGE_CHOOSER_REQUEST_CODE = 200;
    public static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 201;
    public static final int CAMERA_CAPTURE_PERMISSIONS_REQUEST_CODE = 2011;
    public static final int CROP_IMAGE_ACTIVITY_REQUEST_CODE = 203;
    public static final int CROP_IMAGE_ACTIVITY_RESULT_ERROR_CODE = 204;

    private CropImage() {
    }

    @NotNull
    public final Bitmap toOvalBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        canvas.drawOval(rect, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        bitmap.recycle();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        return output;
    }

    @Deprecated(message="use the PickImageContract ActivityResultContract instead")
    public final void startPickImageActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.startActivityForResult(CropImage.getPickImageChooserIntent((Context)activity), 200);
    }

    @Deprecated(message="use the PickImageContract ActivityResultContract instead")
    public final void startPickImageActivity(@NotNull Context context, @NotNull androidx.fragment.app.Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        fragment.startActivityForResult(CropImage.getPickImageChooserIntent(context), 200);
    }

    @JvmStatic
    @NotNull
    public static final Intent getPickImageChooserIntent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CropImage.getPickImageChooserIntent(context, context.getString(R.string.pick_image_intent_chooser_title), false, true);
    }

    @JvmStatic
    @NotNull
    public static final Intent getPickImageChooserIntent(@NotNull Context context, @Nullable CharSequence title, boolean includeDocuments, boolean includeCamera) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List allIntents = new ArrayList();
        PackageManager packageManager = context.getPackageManager();
        if (!INSTANCE.isExplicitCameraPermissionRequired(context) && includeCamera) {
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"packageManager");
            allIntents.addAll((Collection)INSTANCE.getCameraIntents(context, packageManager));
        }
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"packageManager");
        allIntents.addAll((Collection)INSTANCE.getGalleryIntents(packageManager, "android.intent.action.GET_CONTENT", includeDocuments));
        Intent chooserIntent = Intent.createChooser((Intent)((Intent)allIntents.remove(allIntents.size() - 1)), (CharSequence)title);
        Collection $this$toTypedArray$iv = allIntents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Parcelable[] parcelableArray = thisCollection$iv.toArray(new Parcelable[0]);
        if (parcelableArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", parcelableArray);
        Intrinsics.checkNotNullExpressionValue((Object)chooserIntent, (String)"chooserIntent");
        return chooserIntent;
    }

    @NotNull
    public final Intent getCameraIntent(@NotNull Context context, @Nullable Uri outputFileUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri newOutputFileUri = outputFileUri;
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (newOutputFileUri == null) {
            newOutputFileUri = this.getCaptureImageOutputUriContent(context);
        }
        intent.putExtra("output", (Parcelable)newOutputFileUri);
        return intent;
    }

    @NotNull
    public final List<Intent> getCameraIntents(@NotNull Context context, @NotNull PackageManager packageManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        List allIntents = new ArrayList();
        Uri outputFileUri = this.getCaptureImageOutputUriContent(context);
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        List list = packageManager.queryIntentActivities(captureIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryIntentActivities(captureIntent, 0)");
        List listCam = list;
        for (ResolveInfo res : listCam) {
            Intent intent = new Intent(captureIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage(res.activityInfo.packageName);
            intent.putExtra("output", (Parcelable)outputFileUri);
            allIntents.add(intent);
        }
        if (allIntents.isEmpty()) {
            allIntents.add(captureIntent);
        }
        return allIntents;
    }

    @NotNull
    public final List<Intent> getGalleryIntents(@NotNull PackageManager packageManager, @Nullable String action, boolean includeDocuments) {
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        List intents = new ArrayList();
        Intent galleryIntent = new Intent(action);
        galleryIntent.setType(includeDocuments ? "*/*" : "image/*");
        galleryIntent.addCategory("android.intent.category.OPENABLE");
        List list = packageManager.queryIntentActivities(galleryIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryIntentActivities(galleryIntent, 0)");
        List listGallery = list;
        if (CommonVersionCheck.INSTANCE.isAtLeastQ29() && listGallery.size() > 2) {
            CollectionsKt.sortWith((List)listGallery, CropImage::getGalleryIntents$lambda-0);
            listGallery = listGallery.subList(0, 2);
        }
        for (ResolveInfo res : listGallery) {
            Intent intent = new Intent(galleryIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage(res.activityInfo.packageName);
            intents.add(intent);
        }
        if (intents.isEmpty()) {
            intents.add(galleryIntent);
        }
        return intents;
    }

    public final boolean isExplicitCameraPermissionRequired(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CommonVersionCheck.INSTANCE.isAtLeastM23() && this.hasPermissionInManifest(context, "android.permission.CAMERA") && context.checkSelfPermission("android.permission.CAMERA") != 0;
    }

    public final boolean hasPermissionInManifest(@NotNull Context context, @NotNull String permissionName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)permissionName, (String)"permissionName");
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 4096);
            String[] declaredPermissions = packageInfo.requestedPermissions;
            if (declaredPermissions != null) {
                String[] stringArray = declaredPermissions;
                int n = 0;
                String[] stringArray2 = stringArray;
                boolean bl = false;
                if (!(stringArray2.length == 0)) {
                    for (String p : declaredPermissions) {
                        if (!StringsKt.equals((String)p, (String)permissionName, (boolean)true)) continue;
                        return true;
                    }
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public final Uri getCaptureImageOutputUriContent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri outputFileUri = null;
        File getImage = null;
        if (CommonVersionCheck.INSTANCE.isAtLeastQ29()) {
            Uri uri;
            getImage = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
            try {
                String string2 = context.getPackageName() + ".cropper.fileprovider";
                File file = getImage;
                Intrinsics.checkNotNull((Object)file);
                uri = FileProvider.getUriForFile((Context)context, (String)string2, (File)new File(file.getPath(), "pickImageResult.jpeg"));
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"{\n                FileProvider.getUriForFile(\n                    context,\n                    context.packageName + CommonValues.authority,\n                    File(getImage!!.path, \"pickImageResult.jpeg\")\n                )\n            }");
            }
            catch (Exception e) {
                File file = getImage;
                Intrinsics.checkNotNull((Object)file);
                Uri uri2 = Uri.fromFile((File)new File(file.getPath(), "pickImageResult.jpeg"));
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n                Uri.fromFile(File(getImage!!.path, \"pickImageResult.jpeg\"))\n            }");
                uri = uri2;
            }
            outputFileUri = uri;
        } else {
            File file = getImage = context.getExternalCacheDir();
            Intrinsics.checkNotNull((Object)file);
            Uri uri = Uri.fromFile((File)new File(file.getPath(), "pickImageResult.jpeg"));
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(File(getImage!!.path, \"pickImageResult.jpeg\"))");
            outputFileUri = uri;
        }
        return outputFileUri;
    }

    @NotNull
    public final String getCaptureImageOutputUriFilePath(@NotNull Context context, boolean uniqueName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return GetFilePathFromUriKt.getFilePathFromUri(context, this.getCaptureImageOutputUriContent(context), uniqueName);
    }

    public static /* synthetic */ String getCaptureImageOutputUriFilePath$default(CropImage cropImage, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return cropImage.getCaptureImageOutputUriFilePath(context, bl);
    }

    @JvmStatic
    @NotNull
    public static final Uri getPickImageResultUriContent(@NotNull Context context, @Nullable Intent data) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isCamera = true;
        Intent intent = data;
        Uri uri2 = uri = intent == null ? null : intent.getData();
        if (uri != null) {
            String action = data.getAction();
            isCamera = action != null && Intrinsics.areEqual((Object)action, (Object)"android.media.action.IMAGE_CAPTURE");
        }
        return isCamera || uri == null ? INSTANCE.getCaptureImageOutputUriContent(context) : uri;
    }

    @JvmStatic
    @NotNull
    public static final String getPickImageResultUriFilePath(@NotNull Context context, @Nullable Intent data, boolean uniqueName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return GetFilePathFromUriKt.getFilePathFromUri(context, CropImage.getPickImageResultUriContent(context, data), uniqueName);
    }

    public static /* synthetic */ String getPickImageResultUriFilePath$default(Context context, Intent intent, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return CropImage.getPickImageResultUriFilePath(context, intent, bl);
    }

    @JvmStatic
    public static final boolean isReadExternalStoragePermissionsRequired(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return CommonVersionCheck.INSTANCE.isAtLeastM23() && context.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0 && INSTANCE.isUriRequiresPermissions(context, uri);
    }

    public final boolean isUriRequiresPermissions(@NotNull Context context, @NotNull Uri uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            InputStream stream;
            ContentResolver resolver = context.getContentResolver();
            InputStream inputStream = stream = resolver.openInputStream(uri);
            if (inputStream != null) {
                inputStream.close();
            }
            bl = false;
        }
        catch (Exception e) {
            bl = true;
        }
        return bl;
    }

    @JvmStatic
    @Deprecated(message="use the CropImageContract ActivityResultContract instead")
    @NotNull
    public static final ActivityBuilder activity() {
        return new ActivityBuilder(null);
    }

    @JvmStatic
    @Deprecated(message="use the CropImageContract ActivityResultContract instead")
    @NotNull
    public static final ActivityBuilder activity(@Nullable Uri uri) {
        return new ActivityBuilder(uri);
    }

    @JvmStatic
    @Deprecated(message="use the CropImageContract ActivityResultContract instead")
    @Nullable
    public static final ActivityResult getActivityResult(@Nullable Intent data) {
        Intent intent = data;
        Parcelable parcelable = intent == null ? null : intent.getParcelableExtra(CROP_IMAGE_EXTRA_RESULT);
        return parcelable instanceof ActivityResult ? (ActivityResult)parcelable : null;
    }

    private static final int getGalleryIntents$lambda-0(ResolveInfo o1, ResolveInfo $noName_1) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        String packageName = o1.activityInfo.packageName;
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        if (StringsKt.contains$default((CharSequence)packageName, (CharSequence)"photo", (boolean)false, (int)2, null)) {
            return -1;
        }
        if (StringsKt.contains$default((CharSequence)packageName, (CharSequence)"gallery", (boolean)false, (int)2, null)) {
            return -1;
        }
        if (StringsKt.contains$default((CharSequence)packageName, (CharSequence)"album", (boolean)false, (int)2, null)) {
            return -1;
        }
        if (StringsKt.contains$default((CharSequence)packageName, (CharSequence)"media", (boolean)false, (int)2, null)) {
            return -1;
        }
        return 0;
    }

    @Deprecated(message="use the CropImageContract ActivityResultContract instead")
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0015J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020%J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020%J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u000fJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020%J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0015J\u0010\u00100\u001a\u00020\u00002\b\b\u0001\u00101\u001a\u00020\u000fJ\u0010\u00102\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u00010\u0012J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0015J\u000e\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0015J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0015J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u000fJ\u000e\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020%J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020%J\u0010\u0010F\u001a\u00020\u00002\b\u0010G\u001a\u0004\u0018\u00010HJ\u000e\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u000fJ\u0016\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u000fJ\u000e\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u000fJ\u0016\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020\u000fJ\u0016\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u000f2\u0006\u0010U\u001a\u00020\u000fJ\u000e\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0015J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\u0015J\u0010\u0010Z\u001a\u00020\u00002\b\u0010[\u001a\u0004\u0018\u00010\\J\u000e\u0010]\u001a\u00020\u00002\u0006\u0010^\u001a\u00020\u000fJ\u0010\u0010_\u001a\u00020\u00002\b\u0010`\u001a\u0004\u0018\u00010\u0003J\u0016\u0010a\u001a\u00020\u00002\u0006\u0010b\u001a\u00020\u000f2\u0006\u0010c\u001a\u00020\u000fJ \u0010a\u001a\u00020\u00002\u0006\u0010b\u001a\u00020\u000f2\u0006\u0010c\u001a\u00020\u000f2\b\u0010d\u001a\u0004\u0018\u00010eJ\u000e\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u000fJ\u000e\u0010h\u001a\u00020\u00002\u0006\u0010i\u001a\u00020jJ\u000e\u0010k\u001a\u00020\u00002\u0006\u0010l\u001a\u00020\u0015J\u000e\u0010m\u001a\u00020\u00002\u0006\u0010n\u001a\u00020%J\u000e\u0010o\u001a\u00020\u00002\u0006\u0010p\u001a\u00020%J\u000e\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020tJ\u001c\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020t2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fJ\u0018\u0010q\u001a\u00020r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010u\u001a\u00020vH\u0007J&\u0010q\u001a\u00020r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010u\u001a\u00020v2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0007J\u0016\u0010q\u001a\u00020r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010u\u001a\u00020wJ$\u0010q\u001a\u00020r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010u\u001a\u00020w2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/canhub/cropper/CropImage$ActivityBuilder;", "", "mSource", "Landroid/net/Uri;", "(Landroid/net/Uri;)V", "cropImageOptions", "Lcom/canhub/cropper/CropImageOptions;", "getIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "cls", "Ljava/lang/Class;", "setActivityMenuIconColor", "activityMenuIconColor", "", "setActivityTitle", "activityTitle", "", "setAllowCounterRotation", "allowCounterRotation", "", "setAllowFlipping", "allowFlipping", "setAllowRotation", "allowRotation", "setAspectRatio", "aspectRatioX", "aspectRatioY", "setAutoZoomEnabled", "autoZoomEnabled", "setBackgroundColor", "backgroundColor", "setBorderCornerColor", "borderCornerColor", "setBorderCornerLength", "borderCornerLength", "", "setBorderCornerOffset", "borderCornerOffset", "setBorderCornerThickness", "borderCornerThickness", "setBorderLineColor", "borderLineColor", "setBorderLineThickness", "borderLineThickness", "setCenterMoveEnabled", "centerMoveEnabled", "setCropMenuCropButtonIcon", "drawableResource", "setCropMenuCropButtonTitle", "title", "setCropShape", "cropShape", "Lcom/canhub/cropper/CropImageView$CropShape;", "setFixAspectRatio", "fixAspectRatio", "setFlipHorizontally", "flipHorizontally", "setFlipVertically", "flipVertically", "setGuidelines", "guidelines", "Lcom/canhub/cropper/CropImageView$Guidelines;", "setGuidelinesColor", "guidelinesColor", "setGuidelinesThickness", "guidelinesThickness", "setInitialCropWindowPaddingRatio", "initialCropWindowPaddingRatio", "setInitialCropWindowRectangle", "initialCropWindowRectangle", "Landroid/graphics/Rect;", "setInitialRotation", "initialRotation", "setMaxCropResultSize", "maxCropResultWidth", "maxCropResultHeight", "setMaxZoom", "maxZoom", "setMinCropResultSize", "minCropResultWidth", "minCropResultHeight", "setMinCropWindowSize", "minCropWindowWidth", "minCropWindowHeight", "setMultiTouchEnabled", "multiTouchEnabled", "setNoOutputImage", "noOutputImage", "setOutputCompressFormat", "outputCompressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "setOutputCompressQuality", "outputCompressQuality", "setOutputUri", "outputUri", "setRequestedSize", "reqWidth", "reqHeight", "options", "Lcom/canhub/cropper/CropImageView$RequestSizeOptions;", "setRotationDegrees", "rotationDegrees", "setScaleType", "scaleType", "Lcom/canhub/cropper/CropImageView$ScaleType;", "setShowCropOverlay", "showCropOverlay", "setSnapRadius", "snapRadius", "setTouchRadius", "touchRadius", "start", "", "activity", "Landroid/app/Activity;", "fragment", "Landroid/app/Fragment;", "Landroidx/fragment/app/Fragment;", "cropper_release"})
    public static final class ActivityBuilder {
        @Nullable
        private final Uri mSource;
        @NotNull
        private final CropImageOptions cropImageOptions;

        public ActivityBuilder(@Nullable Uri mSource) {
            this.mSource = mSource;
            this.cropImageOptions = new CropImageOptions();
        }

        @NotNull
        public final Intent getIntent(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.getIntent(context, CropImageActivity.class);
        }

        @NotNull
        public final Intent getIntent(@NotNull Context context, @Nullable Class<?> cls) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.cropImageOptions.validate();
            Intent intent = new Intent();
            Class<?> clazz = cls;
            Intrinsics.checkNotNull(clazz);
            intent.setClass(context, clazz);
            Bundle bundle = new Bundle();
            bundle.putParcelable(CropImage.CROP_IMAGE_EXTRA_SOURCE, (Parcelable)this.mSource);
            bundle.putParcelable(CropImage.CROP_IMAGE_EXTRA_OPTIONS, (Parcelable)this.cropImageOptions);
            intent.putExtra(CropImage.CROP_IMAGE_EXTRA_BUNDLE, bundle);
            return intent;
        }

        public final void start(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.cropImageOptions.validate();
            activity.startActivityForResult(this.getIntent((Context)activity), 203);
        }

        public final void start(@NotNull Activity activity, @Nullable Class<?> cls) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.cropImageOptions.validate();
            activity.startActivityForResult(this.getIntent((Context)activity, cls), 203);
        }

        public final void start(@NotNull Context context, @NotNull androidx.fragment.app.Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            fragment.startActivityForResult(this.getIntent(context), 203);
        }

        @RequiresApi(api=11)
        public final void start(@NotNull Context context, @NotNull Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            fragment.startActivityForResult(this.getIntent(context), 203);
        }

        public final void start(@NotNull Context context, @NotNull androidx.fragment.app.Fragment fragment, @Nullable Class<?> cls) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            fragment.startActivityForResult(this.getIntent(context, cls), 203);
        }

        @RequiresApi(api=11)
        public final void start(@NotNull Context context, @NotNull Fragment fragment, @Nullable Class<?> cls) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            fragment.startActivityForResult(this.getIntent(context, cls), 203);
        }

        @NotNull
        public final ActivityBuilder setCropShape(@NotNull CropImageView.CropShape cropShape) {
            Intrinsics.checkNotNullParameter((Object)((Object)cropShape), (String)"cropShape");
            this.cropImageOptions.cropShape = cropShape;
            return this;
        }

        @NotNull
        public final ActivityBuilder setSnapRadius(float snapRadius) {
            this.cropImageOptions.snapRadius = snapRadius;
            return this;
        }

        @NotNull
        public final ActivityBuilder setTouchRadius(float touchRadius) {
            this.cropImageOptions.touchRadius = touchRadius;
            return this;
        }

        @NotNull
        public final ActivityBuilder setGuidelines(@NotNull CropImageView.Guidelines guidelines) {
            Intrinsics.checkNotNullParameter((Object)((Object)guidelines), (String)"guidelines");
            this.cropImageOptions.guidelines = guidelines;
            return this;
        }

        @NotNull
        public final ActivityBuilder setScaleType(@NotNull CropImageView.ScaleType scaleType) {
            Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"scaleType");
            this.cropImageOptions.scaleType = scaleType;
            return this;
        }

        @NotNull
        public final ActivityBuilder setShowCropOverlay(boolean showCropOverlay) {
            this.cropImageOptions.showCropOverlay = showCropOverlay;
            return this;
        }

        @NotNull
        public final ActivityBuilder setAutoZoomEnabled(boolean autoZoomEnabled) {
            this.cropImageOptions.autoZoomEnabled = autoZoomEnabled;
            return this;
        }

        @NotNull
        public final ActivityBuilder setMultiTouchEnabled(boolean multiTouchEnabled) {
            this.cropImageOptions.multiTouchEnabled = multiTouchEnabled;
            return this;
        }

        @NotNull
        public final ActivityBuilder setCenterMoveEnabled(boolean centerMoveEnabled) {
            this.cropImageOptions.centerMoveEnabled = centerMoveEnabled;
            return this;
        }

        @NotNull
        public final ActivityBuilder setMaxZoom(int maxZoom) {
            this.cropImageOptions.maxZoom = maxZoom;
            return this;
        }

        @NotNull
        public final ActivityBuilder setInitialCropWindowPaddingRatio(float initialCropWindowPaddingRatio) {
            this.cropImageOptions.initialCropWindowPaddingRatio = initialCropWindowPaddingRatio;
            return this;
        }

        @NotNull
        public final ActivityBuilder setFixAspectRatio(boolean fixAspectRatio) {
            this.cropImageOptions.fixAspectRatio = fixAspectRatio;
            return this;
        }

        @NotNull
        public final ActivityBuilder setAspectRatio(int aspectRatioX, int aspectRatioY) {
            this.cropImageOptions.aspectRatioX = aspectRatioX;
            this.cropImageOptions.aspectRatioY = aspectRatioY;
            this.cropImageOptions.fixAspectRatio = true;
            return this;
        }

        @NotNull
        public final ActivityBuilder setBorderLineThickness(float borderLineThickness) {
            this.cropImageOptions.borderLineThickness = borderLineThickness;
            return this;
        }

        @NotNull
        public final ActivityBuilder setBorderLineColor(int borderLineColor) {
            this.cropImageOptions.borderLineColor = borderLineColor;
            return this;
        }

        @NotNull
        public final ActivityBuilder setBorderCornerThickness(float borderCornerThickness) {
            this.cropImageOptions.borderCornerThickness = borderCornerThickness;
            return this;
        }

        @NotNull
        public final ActivityBuilder setBorderCornerOffset(float borderCornerOffset) {
            this.cropImageOptions.borderCornerOffset = borderCornerOffset;
            return this;
        }

        @NotNull
        public final ActivityBuilder setBorderCornerLength(float borderCornerLength) {
            this.cropImageOptions.borderCornerLength = borderCornerLength;
            return this;
        }

        @NotNull
        public final ActivityBuilder setBorderCornerColor(int borderCornerColor) {
            this.cropImageOptions.borderCornerColor = borderCornerColor;
            return this;
        }

        @NotNull
        public final ActivityBuilder setGuidelinesThickness(float guidelinesThickness) {
            this.cropImageOptions.guidelinesThickness = guidelinesThickness;
            return this;
        }

        @NotNull
        public final ActivityBuilder setGuidelinesColor(int guidelinesColor) {
            this.cropImageOptions.guidelinesColor = guidelinesColor;
            return this;
        }

        @NotNull
        public final ActivityBuilder setBackgroundColor(int backgroundColor) {
            this.cropImageOptions.backgroundColor = backgroundColor;
            return this;
        }

        @NotNull
        public final ActivityBuilder setMinCropWindowSize(int minCropWindowWidth, int minCropWindowHeight) {
            this.cropImageOptions.minCropWindowWidth = minCropWindowWidth;
            this.cropImageOptions.minCropWindowHeight = minCropWindowHeight;
            return this;
        }

        @NotNull
        public final ActivityBuilder setMinCropResultSize(int minCropResultWidth, int minCropResultHeight) {
            this.cropImageOptions.minCropResultWidth = minCropResultWidth;
            this.cropImageOptions.minCropResultHeight = minCropResultHeight;
            return this;
        }

        @NotNull
        public final ActivityBuilder setMaxCropResultSize(int maxCropResultWidth, int maxCropResultHeight) {
            this.cropImageOptions.maxCropResultWidth = maxCropResultWidth;
            this.cropImageOptions.maxCropResultHeight = maxCropResultHeight;
            return this;
        }

        @NotNull
        public final ActivityBuilder setActivityTitle(@Nullable CharSequence activityTitle) {
            CharSequence charSequence = activityTitle;
            Intrinsics.checkNotNull((Object)charSequence);
            this.cropImageOptions.activityTitle = charSequence;
            return this;
        }

        @NotNull
        public final ActivityBuilder setActivityMenuIconColor(int activityMenuIconColor) {
            this.cropImageOptions.activityMenuIconColor = activityMenuIconColor;
            return this;
        }

        @NotNull
        public final ActivityBuilder setOutputUri(@Nullable Uri outputUri) {
            this.cropImageOptions.customOutputUri = outputUri;
            return this;
        }

        @NotNull
        public final ActivityBuilder setOutputCompressFormat(@Nullable Bitmap.CompressFormat outputCompressFormat) {
            Bitmap.CompressFormat compressFormat = outputCompressFormat;
            Intrinsics.checkNotNull((Object)compressFormat);
            this.cropImageOptions.outputCompressFormat = compressFormat;
            return this;
        }

        @NotNull
        public final ActivityBuilder setOutputCompressQuality(int outputCompressQuality) {
            this.cropImageOptions.outputCompressQuality = outputCompressQuality;
            return this;
        }

        @NotNull
        public final ActivityBuilder setRequestedSize(int reqWidth, int reqHeight) {
            return this.setRequestedSize(reqWidth, reqHeight, CropImageView.RequestSizeOptions.RESIZE_INSIDE);
        }

        @NotNull
        public final ActivityBuilder setRequestedSize(int reqWidth, int reqHeight, @Nullable CropImageView.RequestSizeOptions options2) {
            this.cropImageOptions.outputRequestWidth = reqWidth;
            this.cropImageOptions.outputRequestHeight = reqHeight;
            CropImageView.RequestSizeOptions requestSizeOptions = options2;
            Intrinsics.checkNotNull((Object)((Object)requestSizeOptions));
            this.cropImageOptions.outputRequestSizeOptions = requestSizeOptions;
            return this;
        }

        @NotNull
        public final ActivityBuilder setNoOutputImage(boolean noOutputImage) {
            this.cropImageOptions.noOutputImage = noOutputImage;
            return this;
        }

        @NotNull
        public final ActivityBuilder setInitialCropWindowRectangle(@Nullable Rect initialCropWindowRectangle) {
            this.cropImageOptions.initialCropWindowRectangle = initialCropWindowRectangle;
            return this;
        }

        @NotNull
        public final ActivityBuilder setInitialRotation(int initialRotation) {
            this.cropImageOptions.initialRotation = (initialRotation + 360) % 360;
            return this;
        }

        @NotNull
        public final ActivityBuilder setAllowRotation(boolean allowRotation) {
            this.cropImageOptions.allowRotation = allowRotation;
            return this;
        }

        @NotNull
        public final ActivityBuilder setAllowFlipping(boolean allowFlipping) {
            this.cropImageOptions.allowFlipping = allowFlipping;
            return this;
        }

        @NotNull
        public final ActivityBuilder setAllowCounterRotation(boolean allowCounterRotation) {
            this.cropImageOptions.allowCounterRotation = allowCounterRotation;
            return this;
        }

        @NotNull
        public final ActivityBuilder setRotationDegrees(int rotationDegrees) {
            this.cropImageOptions.rotationDegrees = (rotationDegrees + 360) % 360;
            return this;
        }

        @NotNull
        public final ActivityBuilder setFlipHorizontally(boolean flipHorizontally) {
            this.cropImageOptions.flipHorizontally = flipHorizontally;
            return this;
        }

        @NotNull
        public final ActivityBuilder setFlipVertically(boolean flipVertically) {
            this.cropImageOptions.flipVertically = flipVertically;
            return this;
        }

        @NotNull
        public final ActivityBuilder setCropMenuCropButtonTitle(@Nullable CharSequence title) {
            this.cropImageOptions.cropMenuCropButtonTitle = title;
            return this;
        }

        @NotNull
        public final ActivityBuilder setCropMenuCropButtonIcon(@DrawableRes int drawableResource) {
            this.cropImageOptions.cropMenuCropButtonIcon = drawableResource;
            return this;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aBY\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0014\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000eH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/canhub/cropper/CropImage$ActivityResult;", "Lcom/canhub/cropper/CropImageView$CropResult;", "Landroid/os/Parcelable;", "originalUri", "Landroid/net/Uri;", "uriContent", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cropPoints", "", "cropRect", "Landroid/graphics/Rect;", "rotation", "", "wholeImageRect", "sampleSize", "(Landroid/net/Uri;Landroid/net/Uri;Ljava/lang/Exception;[FLandroid/graphics/Rect;ILandroid/graphics/Rect;I)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "describeContents", "writeToParcel", "", "dest", "flags", "Companion", "cropper_release"})
    public static class ActivityResult
    extends CropImageView.CropResult
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public static final Parcelable.Creator<ActivityResult> CREATOR = (Parcelable.Creator)new Parcelable.Creator<ActivityResult>(){

            @NotNull
            public ActivityResult createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new ActivityResult(in);
            }

            @NotNull
            public ActivityResult[] newArray(int size) {
                return new ActivityResult[size];
            }
        };

        public ActivityResult(@Nullable Uri originalUri, @Nullable Uri uriContent, @Nullable Exception error, @Nullable float[] cropPoints, @Nullable Rect cropRect, int rotation, @Nullable Rect wholeImageRect, int sampleSize) {
            Intrinsics.checkNotNull((Object)cropPoints);
            super(null, originalUri, null, uriContent, error, cropPoints, cropRect, wholeImageRect, rotation, sampleSize);
        }

        protected ActivityResult(@NotNull Parcel in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Uri uri = (Uri)in.readParcelable(Uri.class.getClassLoader());
            Uri uri2 = (Uri)in.readParcelable(Uri.class.getClassLoader());
            Exception exception = (Exception)in.readSerializable();
            float[] fArray = in.createFloatArray();
            Intrinsics.checkNotNull((Object)fArray);
            float[] fArray2 = fArray;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"`in`.createFloatArray()!!");
            super(null, uri, null, uri2, exception, fArray2, (Rect)in.readParcelable(Rect.class.getClassLoader()), (Rect)in.readParcelable(Rect.class.getClassLoader()), in.readInt(), in.readInt());
        }

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeParcelable((Parcelable)this.getOriginalUri(), flags);
            dest.writeParcelable((Parcelable)this.getUriContent(), flags);
            dest.writeSerializable((Serializable)this.getError());
            dest.writeFloatArray(this.getCropPoints());
            dest.writeParcelable((Parcelable)this.getCropRect(), flags);
            dest.writeParcelable((Parcelable)this.getWholeImageRect(), flags);
            dest.writeInt(this.getRotation());
            dest.writeInt(this.getSampleSize());
        }

        public int describeContents() {
            return 0;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/canhub/cropper/CropImage$ActivityResult$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/canhub/cropper/CropImage$ActivityResult;", "cropper_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/canhub/cropper/CropImage$CancelledResult;", "Lcom/canhub/cropper/CropImageView$CropResult;", "()V", "cropper_release"})
    public static final class CancelledResult
    extends CropImageView.CropResult {
        @NotNull
        public static final CancelledResult INSTANCE = new CancelledResult();

        private CancelledResult() {
            super(null, null, null, null, new Exception("cropping has been cancelled by the user"), new float[0], null, null, 0, 0);
        }
    }
}

