/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.graphics.PointF;
import android.graphics.RectF;
import com.canhub.cropper.CropWindowHandler;
import com.canhub.cropper.CropWindowMoveHandler$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001f\u0018\u0000 82\u00020\u0001:\u000289B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJH\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J@\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J \u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007H\u0002JH\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J@\u0010(\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J \u0010*\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0018\u0010+\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J \u0010,\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002JN\u0010-\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0007J@\u00101\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u0007H\u0002JH\u00103\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J@\u00104\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J \u00105\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0007H\u0002R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/canhub/cropper/CropWindowMoveHandler;", "", "type", "Lcom/canhub/cropper/CropWindowMoveHandler$Type;", "cropWindowHandler", "Lcom/canhub/cropper/CropWindowHandler;", "touchX", "", "touchY", "(Lcom/canhub/cropper/CropWindowMoveHandler$Type;Lcom/canhub/cropper/CropWindowHandler;FF)V", "mMaxCropHeight", "mMaxCropWidth", "mMinCropHeight", "mMinCropWidth", "mTouchOffset", "Landroid/graphics/PointF;", "adjustBottom", "", "rect", "Landroid/graphics/RectF;", "bottom", "bounds", "viewHeight", "", "snapMargin", "aspectRatio", "leftMoves", "", "rightMoves", "adjustBottomByAspectRatio", "adjustLeft", "left", "topMoves", "bottomMoves", "adjustLeftByAspectRatio", "adjustLeftRightByAspectRatio", "adjustRight", "right", "viewWidth", "adjustRightByAspectRatio", "adjustTop", "top", "adjustTopBottomByAspectRatio", "adjustTopByAspectRatio", "calculateTouchOffset", "move", "x", "y", "fixedAspectRatio", "moveCenter", "snapRadius", "moveSizeWithFixedAspectRatio", "moveSizeWithFreeAspectRatio", "snapEdgesToBounds", "edges", "margin", "Companion", "Type", "cropper_release"})
public final class CropWindowMoveHandler {
    private final float mMinCropWidth;
    private final float mMinCropHeight;
    private final float mMaxCropWidth;
    private final float mMaxCropHeight;
    private final PointF mTouchOffset;
    private final Type type;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void move(@NotNull RectF rect, float x, float y, @NotNull RectF bounds, int viewWidth, int viewHeight, float snapMargin, boolean fixedAspectRatio, float aspectRatio) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        float adjX = x + this.mTouchOffset.x;
        float adjY = y + this.mTouchOffset.y;
        if (this.type == Type.CENTER) {
            this.moveCenter(rect, adjX, adjY, bounds, viewWidth, viewHeight, snapMargin);
        } else if (fixedAspectRatio) {
            this.moveSizeWithFixedAspectRatio(rect, adjX, adjY, bounds, viewWidth, viewHeight, snapMargin, aspectRatio);
        } else {
            this.moveSizeWithFreeAspectRatio(rect, adjX, adjY, bounds, viewWidth, viewHeight, snapMargin);
        }
    }

    private final void calculateTouchOffset(RectF rect, float touchX, float touchY) {
        float touchOffsetX = 0.0f;
        float touchOffsetY = 0.0f;
        switch (CropWindowMoveHandler$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                touchOffsetX = rect.left - touchX;
                touchOffsetY = rect.top - touchY;
                break;
            }
            case 2: {
                touchOffsetX = rect.right - touchX;
                touchOffsetY = rect.top - touchY;
                break;
            }
            case 3: {
                touchOffsetX = rect.left - touchX;
                touchOffsetY = rect.bottom - touchY;
                break;
            }
            case 4: {
                touchOffsetX = rect.right - touchX;
                touchOffsetY = rect.bottom - touchY;
                break;
            }
            case 5: {
                touchOffsetX = rect.left - touchX;
                touchOffsetY = 0.0f;
                break;
            }
            case 6: {
                touchOffsetX = 0.0f;
                touchOffsetY = rect.top - touchY;
                break;
            }
            case 7: {
                touchOffsetX = rect.right - touchX;
                touchOffsetY = 0.0f;
                break;
            }
            case 8: {
                touchOffsetX = 0.0f;
                touchOffsetY = rect.bottom - touchY;
                break;
            }
            case 9: {
                touchOffsetX = rect.centerX() - touchX;
                touchOffsetY = rect.centerY() - touchY;
                break;
            }
        }
        this.mTouchOffset.x = touchOffsetX;
        this.mTouchOffset.y = touchOffsetY;
    }

    private final void moveCenter(RectF rect, float x, float y, RectF bounds, int viewWidth, int viewHeight, float snapRadius) {
        float dx = x - rect.centerX();
        float dy = y - rect.centerY();
        if (rect.left + dx < 0.0f || rect.right + dx > (float)viewWidth || rect.left + dx < bounds.left || rect.right + dx > bounds.right) {
            this.mTouchOffset.x -= (dx /= 1.05f) / (float)2;
        }
        if (rect.top + dy < 0.0f || rect.bottom + dy > (float)viewHeight || rect.top + dy < bounds.top || rect.bottom + dy > bounds.bottom) {
            this.mTouchOffset.y -= (dy /= 1.05f) / (float)2;
        }
        rect.offset(dx, dy);
        this.snapEdgesToBounds(rect, bounds, snapRadius);
    }

    private final void moveSizeWithFreeAspectRatio(RectF rect, float x, float y, RectF bounds, int viewWidth, int viewHeight, float snapMargin) {
        switch (CropWindowMoveHandler$WhenMappings.$EnumSwitchMapping$1[this.type.ordinal()]) {
            case 1: {
                this.adjustTop(rect, y, bounds, snapMargin, 0.0f, false, false);
                this.adjustLeft(rect, x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case 2: {
                this.adjustTop(rect, y, bounds, snapMargin, 0.0f, false, false);
                this.adjustRight(rect, x, bounds, viewWidth, snapMargin, 0.0f, false, false);
                break;
            }
            case 3: {
                this.adjustBottom(rect, y, bounds, viewHeight, snapMargin, 0.0f, false, false);
                this.adjustLeft(rect, x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case 4: {
                this.adjustBottom(rect, y, bounds, viewHeight, snapMargin, 0.0f, false, false);
                this.adjustRight(rect, x, bounds, viewWidth, snapMargin, 0.0f, false, false);
                break;
            }
            case 5: {
                this.adjustLeft(rect, x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case 6: {
                this.adjustTop(rect, y, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case 7: {
                this.adjustRight(rect, x, bounds, viewWidth, snapMargin, 0.0f, false, false);
                break;
            }
            case 8: {
                this.adjustBottom(rect, y, bounds, viewHeight, snapMargin, 0.0f, false, false);
                break;
            }
            case 9: {
                break;
            }
        }
    }

    private final void moveSizeWithFixedAspectRatio(RectF rect, float x, float y, RectF bounds, int viewWidth, int viewHeight, float snapMargin, float aspectRatio) {
        switch (CropWindowMoveHandler$WhenMappings.$EnumSwitchMapping$2[this.type.ordinal()]) {
            case 1: {
                if (CropWindowMoveHandler.Companion.calculateAspectRatio(x, y, rect.right, rect.bottom) < aspectRatio) {
                    this.adjustTop(rect, y, bounds, snapMargin, aspectRatio, true, false);
                    this.adjustLeftByAspectRatio(rect, aspectRatio);
                    break;
                }
                this.adjustLeft(rect, x, bounds, snapMargin, aspectRatio, true, false);
                this.adjustTopByAspectRatio(rect, aspectRatio);
                break;
            }
            case 2: {
                if (CropWindowMoveHandler.Companion.calculateAspectRatio(rect.left, y, x, rect.bottom) < aspectRatio) {
                    this.adjustTop(rect, y, bounds, snapMargin, aspectRatio, false, true);
                    this.adjustRightByAspectRatio(rect, aspectRatio);
                    break;
                }
                this.adjustRight(rect, x, bounds, viewWidth, snapMargin, aspectRatio, true, false);
                this.adjustTopByAspectRatio(rect, aspectRatio);
                break;
            }
            case 3: {
                if (CropWindowMoveHandler.Companion.calculateAspectRatio(x, rect.top, rect.right, y) < aspectRatio) {
                    this.adjustBottom(rect, y, bounds, viewHeight, snapMargin, aspectRatio, true, false);
                    this.adjustLeftByAspectRatio(rect, aspectRatio);
                    break;
                }
                this.adjustLeft(rect, x, bounds, snapMargin, aspectRatio, false, true);
                this.adjustBottomByAspectRatio(rect, aspectRatio);
                break;
            }
            case 4: {
                if (CropWindowMoveHandler.Companion.calculateAspectRatio(rect.left, rect.top, x, y) < aspectRatio) {
                    this.adjustBottom(rect, y, bounds, viewHeight, snapMargin, aspectRatio, false, true);
                    this.adjustRightByAspectRatio(rect, aspectRatio);
                    break;
                }
                this.adjustRight(rect, x, bounds, viewWidth, snapMargin, aspectRatio, false, true);
                this.adjustBottomByAspectRatio(rect, aspectRatio);
                break;
            }
            case 5: {
                this.adjustLeft(rect, x, bounds, snapMargin, aspectRatio, true, true);
                this.adjustTopBottomByAspectRatio(rect, bounds, aspectRatio);
                break;
            }
            case 6: {
                this.adjustTop(rect, y, bounds, snapMargin, aspectRatio, true, true);
                this.adjustLeftRightByAspectRatio(rect, bounds, aspectRatio);
                break;
            }
            case 7: {
                this.adjustRight(rect, x, bounds, viewWidth, snapMargin, aspectRatio, true, true);
                this.adjustTopBottomByAspectRatio(rect, bounds, aspectRatio);
                break;
            }
            case 8: {
                this.adjustBottom(rect, y, bounds, viewHeight, snapMargin, aspectRatio, true, true);
                this.adjustLeftRightByAspectRatio(rect, bounds, aspectRatio);
                break;
            }
            case 9: {
                break;
            }
        }
    }

    private final void snapEdgesToBounds(RectF edges, RectF bounds, float margin) {
        if (edges.left < bounds.left + margin) {
            edges.offset(bounds.left - edges.left, 0.0f);
        }
        if (edges.top < bounds.top + margin) {
            edges.offset(0.0f, bounds.top - edges.top);
        }
        if (edges.right > bounds.right - margin) {
            edges.offset(bounds.right - edges.right, 0.0f);
        }
        if (edges.bottom > bounds.bottom - margin) {
            edges.offset(0.0f, bounds.bottom - edges.bottom);
        }
    }

    private final void adjustLeft(RectF rect, float left, RectF bounds, float snapMargin, float aspectRatio, boolean topMoves, boolean bottomMoves) {
        float newLeft = left;
        if (newLeft < 0.0f) {
            this.mTouchOffset.x -= (newLeft /= 1.05f) / 1.1f;
        }
        if (newLeft < bounds.left) {
            this.mTouchOffset.x -= (newLeft - bounds.left) / 2.0f;
        }
        if (newLeft - bounds.left < snapMargin) {
            newLeft = bounds.left;
        }
        if (rect.right - newLeft < this.mMinCropWidth) {
            newLeft = rect.right - this.mMinCropWidth;
        }
        if (rect.right - newLeft > this.mMaxCropWidth) {
            newLeft = rect.right - this.mMaxCropWidth;
        }
        if (newLeft - bounds.left < snapMargin) {
            newLeft = bounds.left;
        }
        if (aspectRatio > 0.0f) {
            boolean bl;
            float f;
            float f2;
            float newHeight = (rect.right - newLeft) / aspectRatio;
            if (newHeight < this.mMinCropHeight) {
                f2 = bounds.left;
                f = rect.right - this.mMinCropHeight * aspectRatio;
                bl = false;
                newLeft = Math.max(f2, f);
                newHeight = (rect.right - newLeft) / aspectRatio;
            }
            if (newHeight > this.mMaxCropHeight) {
                f2 = bounds.left;
                f = rect.right - this.mMaxCropHeight * aspectRatio;
                bl = false;
                newLeft = Math.max(f2, f);
                newHeight = (rect.right - newLeft) / aspectRatio;
            }
            if (topMoves && bottomMoves) {
                f2 = bounds.left;
                f = rect.right - bounds.height() * aspectRatio;
                bl = false;
                f2 = Math.max(f2, f);
                boolean bl2 = false;
                newLeft = Math.max(newLeft, f2);
            } else {
                if (topMoves && rect.bottom - newHeight < bounds.top) {
                    f2 = bounds.left;
                    f = rect.right - (rect.bottom - bounds.top) * aspectRatio;
                    bl = false;
                    newLeft = Math.max(f2, f);
                    newHeight = (rect.right - newLeft) / aspectRatio;
                }
                if (bottomMoves && rect.top + newHeight > bounds.bottom) {
                    f2 = bounds.left;
                    f = rect.right - (bounds.bottom - rect.top) * aspectRatio;
                    bl = false;
                    f2 = Math.max(f2, f);
                    boolean bl3 = false;
                    newLeft = Math.max(newLeft, f2);
                }
            }
        }
        rect.left = newLeft;
    }

    private final void adjustRight(RectF rect, float right, RectF bounds, int viewWidth, float snapMargin, float aspectRatio, boolean topMoves, boolean bottomMoves) {
        float newRight = right;
        if (newRight > (float)viewWidth) {
            newRight = (float)viewWidth + (newRight - (float)viewWidth) / 1.05f;
            this.mTouchOffset.x -= (newRight - (float)viewWidth) / 1.1f;
        }
        if (newRight > bounds.right) {
            this.mTouchOffset.x -= (newRight - bounds.right) / 2.0f;
        }
        if (bounds.right - newRight < snapMargin) {
            newRight = bounds.right;
        }
        if (newRight - rect.left < this.mMinCropWidth) {
            newRight = rect.left + this.mMinCropWidth;
        }
        if (newRight - rect.left > this.mMaxCropWidth) {
            newRight = rect.left + this.mMaxCropWidth;
        }
        if (bounds.right - newRight < snapMargin) {
            newRight = bounds.right;
        }
        if (aspectRatio > 0.0f) {
            boolean bl;
            float f;
            float f2;
            float newHeight = (newRight - rect.left) / aspectRatio;
            if (newHeight < this.mMinCropHeight) {
                f2 = bounds.right;
                f = rect.left + this.mMinCropHeight * aspectRatio;
                bl = false;
                newRight = Math.min(f2, f);
                newHeight = (newRight - rect.left) / aspectRatio;
            }
            if (newHeight > this.mMaxCropHeight) {
                f2 = bounds.right;
                f = rect.left + this.mMaxCropHeight * aspectRatio;
                bl = false;
                newRight = Math.min(f2, f);
                newHeight = (newRight - rect.left) / aspectRatio;
            }
            if (topMoves && bottomMoves) {
                f2 = bounds.right;
                f = rect.left + bounds.height() * aspectRatio;
                bl = false;
                f2 = Math.min(f2, f);
                boolean bl2 = false;
                newRight = Math.min(newRight, f2);
            } else {
                if (topMoves && rect.bottom - newHeight < bounds.top) {
                    f2 = bounds.right;
                    f = rect.left + (rect.bottom - bounds.top) * aspectRatio;
                    bl = false;
                    newRight = Math.min(f2, f);
                    newHeight = (newRight - rect.left) / aspectRatio;
                }
                if (bottomMoves && rect.top + newHeight > bounds.bottom) {
                    f2 = bounds.right;
                    f = rect.left + (bounds.bottom - rect.top) * aspectRatio;
                    bl = false;
                    f2 = Math.min(f2, f);
                    boolean bl3 = false;
                    newRight = Math.min(newRight, f2);
                }
            }
        }
        rect.right = newRight;
    }

    private final void adjustTop(RectF rect, float top, RectF bounds, float snapMargin, float aspectRatio, boolean leftMoves, boolean rightMoves) {
        float newTop = top;
        if (newTop < 0.0f) {
            this.mTouchOffset.y -= (newTop /= 1.05f) / 1.1f;
        }
        if (newTop < bounds.top) {
            this.mTouchOffset.y -= (newTop - bounds.top) / 2.0f;
        }
        if (newTop - bounds.top < snapMargin) {
            newTop = bounds.top;
        }
        if (rect.bottom - newTop < this.mMinCropHeight) {
            newTop = rect.bottom - this.mMinCropHeight;
        }
        if (rect.bottom - newTop > this.mMaxCropHeight) {
            newTop = rect.bottom - this.mMaxCropHeight;
        }
        if (newTop - bounds.top < snapMargin) {
            newTop = bounds.top;
        }
        if (aspectRatio > 0.0f) {
            boolean bl;
            float f;
            float f2;
            float newWidth = (rect.bottom - newTop) * aspectRatio;
            if (newWidth < this.mMinCropWidth) {
                f2 = bounds.top;
                f = rect.bottom - this.mMinCropWidth / aspectRatio;
                bl = false;
                newTop = Math.max(f2, f);
                newWidth = (rect.bottom - newTop) * aspectRatio;
            }
            if (newWidth > this.mMaxCropWidth) {
                f2 = bounds.top;
                f = rect.bottom - this.mMaxCropWidth / aspectRatio;
                bl = false;
                newTop = Math.max(f2, f);
                newWidth = (rect.bottom - newTop) * aspectRatio;
            }
            if (leftMoves && rightMoves) {
                f2 = bounds.top;
                f = rect.bottom - bounds.width() / aspectRatio;
                bl = false;
                f2 = Math.max(f2, f);
                boolean bl2 = false;
                newTop = Math.max(newTop, f2);
            } else {
                if (leftMoves && rect.right - newWidth < bounds.left) {
                    f2 = bounds.top;
                    f = rect.bottom - (rect.right - bounds.left) / aspectRatio;
                    bl = false;
                    newTop = Math.max(f2, f);
                    newWidth = (rect.bottom - newTop) * aspectRatio;
                }
                if (rightMoves && rect.left + newWidth > bounds.right) {
                    f2 = bounds.top;
                    f = rect.bottom - (bounds.right - rect.left) / aspectRatio;
                    bl = false;
                    f2 = Math.max(f2, f);
                    boolean bl3 = false;
                    newTop = Math.max(newTop, f2);
                }
            }
        }
        rect.top = newTop;
    }

    private final void adjustBottom(RectF rect, float bottom, RectF bounds, int viewHeight, float snapMargin, float aspectRatio, boolean leftMoves, boolean rightMoves) {
        float newBottom = bottom;
        if (newBottom > (float)viewHeight) {
            newBottom = (float)viewHeight + (newBottom - (float)viewHeight) / 1.05f;
            this.mTouchOffset.y -= (newBottom - (float)viewHeight) / 1.1f;
        }
        if (newBottom > bounds.bottom) {
            this.mTouchOffset.y -= (newBottom - bounds.bottom) / 2.0f;
        }
        if (bounds.bottom - newBottom < snapMargin) {
            newBottom = bounds.bottom;
        }
        if (newBottom - rect.top < this.mMinCropHeight) {
            newBottom = rect.top + this.mMinCropHeight;
        }
        if (newBottom - rect.top > this.mMaxCropHeight) {
            newBottom = rect.top + this.mMaxCropHeight;
        }
        if (bounds.bottom - newBottom < snapMargin) {
            newBottom = bounds.bottom;
        }
        if (aspectRatio > 0.0f) {
            boolean bl;
            float f;
            float f2;
            float newWidth = (newBottom - rect.top) * aspectRatio;
            if (newWidth < this.mMinCropWidth) {
                f2 = bounds.bottom;
                f = rect.top + this.mMinCropWidth / aspectRatio;
                bl = false;
                newBottom = Math.min(f2, f);
                newWidth = (newBottom - rect.top) * aspectRatio;
            }
            if (newWidth > this.mMaxCropWidth) {
                f2 = bounds.bottom;
                f = rect.top + this.mMaxCropWidth / aspectRatio;
                bl = false;
                newBottom = Math.min(f2, f);
                newWidth = (newBottom - rect.top) * aspectRatio;
            }
            if (leftMoves && rightMoves) {
                f2 = bounds.bottom;
                f = rect.top + bounds.width() / aspectRatio;
                bl = false;
                f2 = Math.min(f2, f);
                boolean bl2 = false;
                newBottom = Math.min(newBottom, f2);
            } else {
                if (leftMoves && rect.right - newWidth < bounds.left) {
                    f2 = bounds.bottom;
                    f = rect.top + (rect.right - bounds.left) / aspectRatio;
                    bl = false;
                    newBottom = Math.min(f2, f);
                    newWidth = (newBottom - rect.top) * aspectRatio;
                }
                if (rightMoves && rect.left + newWidth > bounds.right) {
                    f2 = bounds.bottom;
                    f = rect.top + (bounds.right - rect.left) / aspectRatio;
                    bl = false;
                    f2 = Math.min(f2, f);
                    boolean bl3 = false;
                    newBottom = Math.min(newBottom, f2);
                }
            }
        }
        rect.bottom = newBottom;
    }

    private final void adjustLeftByAspectRatio(RectF rect, float aspectRatio) {
        rect.left = rect.right - rect.height() * aspectRatio;
    }

    private final void adjustTopByAspectRatio(RectF rect, float aspectRatio) {
        rect.top = rect.bottom - rect.width() / aspectRatio;
    }

    private final void adjustRightByAspectRatio(RectF rect, float aspectRatio) {
        rect.right = rect.left + rect.height() * aspectRatio;
    }

    private final void adjustBottomByAspectRatio(RectF rect, float aspectRatio) {
        rect.bottom = rect.top + rect.width() / aspectRatio;
    }

    private final void adjustLeftRightByAspectRatio(RectF rect, RectF bounds, float aspectRatio) {
        rect.inset((rect.width() - rect.height() * aspectRatio) / (float)2, 0.0f);
        if (rect.left < bounds.left) {
            rect.offset(bounds.left - rect.left, 0.0f);
        }
        if (rect.right > bounds.right) {
            rect.offset(bounds.right - rect.right, 0.0f);
        }
    }

    private final void adjustTopBottomByAspectRatio(RectF rect, RectF bounds, float aspectRatio) {
        rect.inset(0.0f, (rect.height() - rect.width() / aspectRatio) / (float)2);
        if (rect.top < bounds.top) {
            rect.offset(0.0f, bounds.top - rect.top);
        }
        if (rect.bottom > bounds.bottom) {
            rect.offset(0.0f, bounds.bottom - rect.bottom);
        }
    }

    public CropWindowMoveHandler(@NotNull Type type, @NotNull CropWindowHandler cropWindowHandler, float touchX, float touchY) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)cropWindowHandler, (String)"cropWindowHandler");
        this.type = type;
        this.mMinCropWidth = cropWindowHandler.getMinCropWidth();
        this.mMinCropHeight = cropWindowHandler.getMinCropHeight();
        this.mMaxCropWidth = cropWindowHandler.getMaxCropWidth();
        this.mMaxCropHeight = cropWindowHandler.getMaxCropHeight();
        this.mTouchOffset = new PointF(0.0f, 0.0f);
        this.calculateTouchOffset(cropWindowHandler.getRect(), touchX, touchY);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/canhub/cropper/CropWindowMoveHandler$Type;", "", "(Ljava/lang/String;I)V", "TOP_LEFT", "TOP_RIGHT", "BOTTOM_LEFT", "BOTTOM_RIGHT", "LEFT", "TOP", "RIGHT", "BOTTOM", "CENTER", "cropper_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type TOP_LEFT;
        public static final /* enum */ Type TOP_RIGHT;
        public static final /* enum */ Type BOTTOM_LEFT;
        public static final /* enum */ Type BOTTOM_RIGHT;
        public static final /* enum */ Type LEFT;
        public static final /* enum */ Type TOP;
        public static final /* enum */ Type RIGHT;
        public static final /* enum */ Type BOTTOM;
        public static final /* enum */ Type CENTER;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[9];
            Type[] typeArray2 = typeArray;
            typeArray[0] = TOP_LEFT = new Type();
            typeArray[1] = TOP_RIGHT = new Type();
            typeArray[2] = BOTTOM_LEFT = new Type();
            typeArray[3] = BOTTOM_RIGHT = new Type();
            typeArray[4] = LEFT = new Type();
            typeArray[5] = TOP = new Type();
            typeArray[6] = RIGHT = new Type();
            typeArray[7] = BOTTOM = new Type();
            typeArray[8] = CENTER = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"Lcom/canhub/cropper/CropWindowMoveHandler$Companion;", "", "()V", "calculateAspectRatio", "", "left", "top", "right", "bottom", "cropper_release"})
    public static final class Companion {
        private final float calculateAspectRatio(float left, float top, float right, float bottom) {
            return (right - left) / (bottom - top);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

